/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.QueryBitSetProducer;
import org.apache.lucene.search.join.ToParentBlockJoinSortField;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.ValueSourceParser;
import org.apache.solr.search.join.BlockJoinParentQParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildFieldValueSourceParser
extends ValueSourceParser {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String NAME = "childfield";

    @Override
    public ValueSource parse(FunctionQParser fp) throws SyntaxError {
        SchemaField sf;
        BitSetProducer childFilter;
        BitSetProducer parentFilter;
        String sortFieldName = fp.parseArg();
        Query query = fp.hasMoreArguments() ? fp.parseNestedQuery() : fp.subQuery(fp.getParam("q"), null).getQuery();
        try {
            if (!(query instanceof BlockJoinParentQParser.AllParentsAware)) {
                throw new SyntaxError("expect a reference to block join query " + BlockJoinParentQParser.AllParentsAware.class.getSimpleName() + " in " + fp.getString());
            }
            BlockJoinParentQParser.AllParentsAware bjQ = (BlockJoinParentQParser.AllParentsAware)query;
            parentFilter = BlockJoinParentQParser.getCachedBitSetProducer(fp.getReq(), bjQ.getParentQuery());
            childFilter = BlockJoinParentQParser.getCachedBitSetProducer(fp.getReq(), bjQ.getChildQuery());
            if (sortFieldName == null || sortFieldName.equals("")) {
                throw new SyntaxError("field is omitted in " + fp.getString());
            }
            sf = fp.getReq().getSchema().getFieldOrNull(sortFieldName);
            if (null == sf) {
                throw new SyntaxError("childfield sort param field \"" + sortFieldName + "\" can't be found in schema");
            }
        }
        catch (SyntaxError e) {
            log.error("can't parse {}", (Object)fp.getString(), (Object)e);
            throw e;
        }
        return new BlockJoinSortFieldValueSource(childFilter, parentFilter, sf);
    }

    private static final class BlockJoinSortFieldValueSource
    extends ValueSource {
        private final BitSetProducer childFilter;
        private final BitSetProducer parentFilter;
        private final SchemaField childField;

        private BlockJoinSortFieldValueSource(BitSetProducer childFilter, BitSetProducer parentFilter, SchemaField childField) {
            this.childFilter = childFilter;
            this.parentFilter = parentFilter;
            this.childField = childField;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.childField == null ? 0 : this.childField.hashCode());
            result = 31 * result + (this.childFilter == null ? 0 : this.childFilter.hashCode());
            result = 31 * result + (this.parentFilter == null ? 0 : this.parentFilter.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            BlockJoinSortFieldValueSource other = (BlockJoinSortFieldValueSource)((Object)obj);
            if (this.childField == null ? other.childField != null : !this.childField.equals(other.childField)) {
                return false;
            }
            if (this.childFilter == null ? other.childFilter != null : !this.childFilter.equals(other.childFilter)) {
                return false;
            }
            return !(this.parentFilter == null ? other.parentFilter != null : !this.parentFilter.equals(other.parentFilter));
        }

        public String toString() {
            return "BlockJoinSortFieldValueSource [childFilter=" + this.childFilter + ", parentFilter=" + this.parentFilter + ", childField=" + this.childField + "]";
        }

        public SortField getSortField(boolean reverse) {
            final SortField.Type type = this.childField.getSortField(reverse).getType();
            return new ToParentBlockJoinSortField(this.childField.getName(), type, reverse, this.parentFilter, this.childFilter){

                public FieldComparator<?> getComparator(int numHits, boolean enableSkipping) {
                    FieldComparator comparator = super.getComparator(numHits, enableSkipping);
                    return type == SortField.Type.STRING ? new BytesToStringComparator((FieldComparator<BytesRef>)comparator) : comparator;
                }
            };
        }

        public String description() {
            return "childfield for " + this.childField.getName() + " of " + this.query(this.childFilter);
        }

        private String query(BitSetProducer bits) {
            return bits instanceof QueryBitSetProducer ? ((QueryBitSetProducer)bits).getQuery().toString() : bits.toString();
        }

        public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
            throw new UnsupportedOperationException(this + " is only for sorting");
        }

        private static final class BytesToStringComparator
        extends FieldComparator<String> {
            private final FieldComparator<BytesRef> byteRefs;

            private BytesToStringComparator(FieldComparator<BytesRef> byteRefs) {
                this.byteRefs = byteRefs;
            }

            public int compare(int slot1, int slot2) {
                return this.byteRefs.compare(slot1, slot2);
            }

            public void setTopValue(String value) {
                this.byteRefs.setTopValue((Object)new BytesRef((CharSequence)value));
            }

            public String value(int slot) {
                BytesRef value = (BytesRef)this.byteRefs.value(slot);
                return value != null ? value.utf8ToString() : null;
            }

            public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
                return this.byteRefs.getLeafComparator(context);
            }
        }
    }
}

