/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.servlet.BaseSolrServlet;
import org.apache.solr.servlet.ServletUtils;

public final class LoadAdminUiServlet
extends BaseSolrServlet {
    private static final boolean disabled = Boolean.parseBoolean(System.getProperty("disableAdminUI", "false"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest _request, HttpServletResponse _response) throws IOException {
        block4: {
            HttpServletResponse response;
            block3: {
                if (disabled) {
                    _response.sendError(404, "Solr Admin UI is disabled. To enable it, change the default value of SOLR_ADMIN_UI_ENABLED in bin/solr.in.sh or solr.in.cmd.");
                    return;
                }
                HttpServletRequest request = ServletUtils.closeShield(_request, false);
                response = ServletUtils.closeShield(_response, false);
                response.addHeader("X-Frame-Options", "DENY");
                String admin = request.getRequestURI().substring(request.getContextPath().length());
                CoreContainer cores = (CoreContainer)request.getAttribute("org.apache.solr.CoreContainer");
                InputStream in = this.getServletContext().getResourceAsStream(admin);
                OutputStreamWriter out = null;
                if (in == null || cores == null) break block3;
                try {
                    response.setCharacterEncoding("UTF-8");
                    response.setContentType("text/html");
                    out = new OutputStreamWriter((OutputStream)new CloseShieldOutputStream((OutputStream)response.getOutputStream()), StandardCharsets.UTF_8);
                    String html = IOUtils.toString((InputStream)in, (String)"UTF-8");
                    Package pack = SolrCore.class.getPackage();
                    String[] search = new String[]{"${contextPath}", "${adminPath}", "${version}"};
                    String[] replace = new String[]{StringEscapeUtils.escapeEcmaScript((String)request.getContextPath()), StringEscapeUtils.escapeEcmaScript((String)"/admin/cores"), StringEscapeUtils.escapeEcmaScript((String)pack.getSpecificationVersion())};
                    out.write(StringUtils.replaceEach((String)html, (String[])search, (String[])replace));
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly((InputStream)in);
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((Writer)out);
                break block4;
            }
            response.sendError(404);
        }
    }
}

