/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class RedactionUtils {
    public static final String SOLR_REDACTION_SYSTEM_PATTERN_PROP = "solr.redaction.system.pattern";
    private static Pattern pattern = Pattern.compile(System.getProperty("solr.redaction.system.pattern", ".*password.*"), 2);
    private static final String REDACT_STRING = "--REDACTED--";
    public static final String NODE_REDACTION_PREFIX = "N_";
    public static final String COLL_REDACTION_PREFIX = "COLL_";
    private static boolean redactSystemProperty = Boolean.parseBoolean(System.getProperty("solr.redaction.system.enabled", "true"));

    public static boolean isSystemPropertySensitive(String name) {
        return redactSystemProperty && pattern.matcher(name).matches();
    }

    public static String getRedactString() {
        return REDACT_STRING;
    }

    public static void setRedactSystemProperty(boolean redactSystemProperty) {
        RedactionUtils.redactSystemProperty = redactSystemProperty;
    }

    public static String redactNames(Map<String, String> redactions, String data) {
        TreeMap<String, String> sorted = new TreeMap<String, String>(Comparator.comparing(String::length).reversed().thenComparing(String::compareTo));
        sorted.putAll(redactions);
        for (Map.Entry entry : sorted.entrySet()) {
            data = data.replaceAll("\\Q" + (String)entry.getKey() + "\\E", (String)entry.getValue());
        }
        return data;
    }
}

