/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene91;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import java.util.SplittableRandom;
import org.apache.lucene.backward_codecs.lucene91.Lucene91BoundsChecker;
import org.apache.lucene.backward_codecs.lucene91.Lucene91NeighborArray;
import org.apache.lucene.backward_codecs.lucene91.Lucene91OnHeapHnswGraph;
import org.apache.lucene.index.RandomAccessVectorValues;
import org.apache.lucene.index.RandomAccessVectorValuesProducer;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.hnsw.HnswGraph;
import org.apache.lucene.util.hnsw.HnswGraphSearcher;
import org.apache.lucene.util.hnsw.NeighborQueue;

public final class Lucene91HnswGraphBuilder {
    private static final long DEFAULT_RAND_SEED = 42L;
    public static final String HNSW_COMPONENT = "HNSW";
    public static long randSeed = 42L;
    private final int maxConn;
    private final int beamWidth;
    private final double ml;
    private final Lucene91NeighborArray scratch;
    private final VectorSimilarityFunction similarityFunction;
    private final RandomAccessVectorValues vectorValues;
    private final SplittableRandom random;
    private final Lucene91BoundsChecker bound;
    private final HnswGraphSearcher graphSearcher;
    final Lucene91OnHeapHnswGraph hnsw;
    private InfoStream infoStream = InfoStream.getDefault();
    private RandomAccessVectorValues buildVectors;

    public Lucene91HnswGraphBuilder(RandomAccessVectorValuesProducer vectors, VectorSimilarityFunction similarityFunction, int maxConn, int beamWidth, long seed) throws IOException {
        this.vectorValues = vectors.randomAccess();
        this.buildVectors = vectors.randomAccess();
        this.similarityFunction = Objects.requireNonNull(similarityFunction);
        if (maxConn <= 0) {
            throw new IllegalArgumentException("maxConn must be positive");
        }
        if (beamWidth <= 0) {
            throw new IllegalArgumentException("beamWidth must be positive");
        }
        this.maxConn = maxConn;
        this.beamWidth = beamWidth;
        this.ml = 1.0 / Math.log(1.0 * (double)maxConn);
        this.random = new SplittableRandom(seed);
        int levelOfFirstNode = Lucene91HnswGraphBuilder.getRandomGraphLevel(this.ml, this.random);
        this.hnsw = new Lucene91OnHeapHnswGraph(maxConn, levelOfFirstNode);
        this.graphSearcher = new HnswGraphSearcher(similarityFunction, new NeighborQueue(beamWidth, true), (BitSet)new FixedBitSet(this.vectorValues.size()));
        this.bound = Lucene91BoundsChecker.create(false);
        this.scratch = new Lucene91NeighborArray(Math.max(beamWidth, maxConn + 1));
    }

    public Lucene91OnHeapHnswGraph build(RandomAccessVectorValues vectors) throws IOException {
        long start;
        if (vectors == this.vectorValues) {
            throw new IllegalArgumentException("Vectors to build must be independent of the source of vectors provided to HnswGraphBuilder()");
        }
        if (this.infoStream.isEnabled(HNSW_COMPONENT)) {
            this.infoStream.message(HNSW_COMPONENT, "build graph from " + vectors.size() + " vectors");
        }
        long t = start = System.nanoTime();
        for (int node = 1; node < vectors.size(); ++node) {
            this.addGraphNode(node, vectors.vectorValue(node));
            if (node % 10000 != 0 || !this.infoStream.isEnabled(HNSW_COMPONENT)) continue;
            t = this.printGraphBuildStatus(node, start, t);
        }
        return this.hnsw;
    }

    public void setInfoStream(InfoStream infoStream) {
        this.infoStream = infoStream;
    }

    void addGraphNode(int node, float[] value) throws IOException {
        NeighborQueue candidates;
        int level;
        int nodeLevel = Lucene91HnswGraphBuilder.getRandomGraphLevel(this.ml, this.random);
        int curMaxLevel = this.hnsw.numLevels() - 1;
        int[] eps = new int[]{this.hnsw.entryNode()};
        for (level = nodeLevel; level > curMaxLevel; --level) {
            this.hnsw.addNode(level, node);
        }
        for (level = curMaxLevel; level > nodeLevel; --level) {
            candidates = this.graphSearcher.searchLevel(value, 1, level, eps, this.vectorValues, (HnswGraph)this.hnsw);
            eps = new int[]{candidates.pop()};
        }
        for (level = Math.min(nodeLevel, curMaxLevel); level >= 0; --level) {
            candidates = this.graphSearcher.searchLevel(value, this.beamWidth, level, eps, this.vectorValues, (HnswGraph)this.hnsw);
            eps = candidates.nodes();
            this.hnsw.addNode(level, node);
            this.addDiverseNeighbors(level, node, candidates);
        }
    }

    private long printGraphBuildStatus(int node, long start, long t) {
        long now = System.nanoTime();
        this.infoStream.message(HNSW_COMPONENT, String.format(Locale.ROOT, "built %d in %d/%d ms", node, (now - t) / 1000000L, (now - start) / 1000000L));
        return now;
    }

    private void addDiverseNeighbors(int level, int node, NeighborQueue candidates) throws IOException {
        Lucene91NeighborArray neighbors = this.hnsw.getNeighbors(level, node);
        assert (neighbors.size() == 0);
        this.popToScratch(candidates);
        this.selectDiverse(neighbors, this.scratch);
        int size = neighbors.size();
        for (int i = 0; i < size; ++i) {
            int nbr = neighbors.node[i];
            Lucene91NeighborArray nbrNbr = this.hnsw.getNeighbors(level, nbr);
            nbrNbr.add(node, neighbors.score[i]);
            if (nbrNbr.size() <= this.maxConn) continue;
            this.diversityUpdate(nbrNbr);
        }
    }

    private void selectDiverse(Lucene91NeighborArray neighbors, Lucene91NeighborArray candidates) throws IOException {
        for (int i = candidates.size() - 1; neighbors.size() < this.maxConn && i >= 0; --i) {
            int cNode = candidates.node[i];
            float cScore = candidates.score[i];
            assert (cNode < this.hnsw.size());
            if (!this.diversityCheck(this.vectorValues.vectorValue(cNode), cScore, neighbors, this.buildVectors)) continue;
            neighbors.add(cNode, cScore);
        }
    }

    private void popToScratch(NeighborQueue candidates) {
        this.scratch.clear();
        int candidateCount = candidates.size();
        for (int i = 0; i < candidateCount; ++i) {
            float similarity = candidates.topScore();
            this.scratch.add(candidates.pop(), similarity);
        }
    }

    private boolean diversityCheck(float[] candidate, float score, Lucene91NeighborArray neighbors, RandomAccessVectorValues vectorValues) throws IOException {
        this.bound.set(score);
        for (int i = 0; i < neighbors.size(); ++i) {
            float neighborSimilarity = this.similarityFunction.compare(candidate, vectorValues.vectorValue(neighbors.node[i]));
            if (this.bound.check(neighborSimilarity)) continue;
            return false;
        }
        return true;
    }

    private void diversityUpdate(Lucene91NeighborArray neighbors) throws IOException {
        assert (neighbors.size() == this.maxConn + 1);
        int replacePoint = this.findNonDiverse(neighbors);
        if (replacePoint == -1) {
            this.bound.set(neighbors.score[0]);
            if (this.bound.check(neighbors.score[this.maxConn])) {
                neighbors.removeLast();
                return;
            }
            replacePoint = 0;
        }
        neighbors.node[replacePoint] = neighbors.node[this.maxConn];
        neighbors.score[replacePoint] = neighbors.score[this.maxConn];
        neighbors.removeLast();
    }

    private int findNonDiverse(Lucene91NeighborArray neighbors) throws IOException {
        for (int i = neighbors.size() - 1; i >= 0; --i) {
            int neighborId = neighbors.node[i];
            this.bound.set(neighbors.score[i]);
            float[] neighborVector = this.vectorValues.vectorValue(neighborId);
            for (int j = this.maxConn; j > i; --j) {
                float neighborSimilarity = this.similarityFunction.compare(neighborVector, this.buildVectors.vectorValue(neighbors.node[j]));
                if (this.bound.check(neighborSimilarity)) continue;
                return i;
            }
        }
        return -1;
    }

    private static int getRandomGraphLevel(double ml, SplittableRandom random) {
        double randDouble;
        while ((randDouble = random.nextDouble()) == 0.0) {
        }
        return (int)(-Math.log(randDouble) * ml);
    }
}

