/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import tr.view.actions.screens.ActionsScreen;
import tr.view.actions.screens.filters.ActionsFilter;
import tr.view.actions.screens.filters.FilterCriterion;
import tr.view.actions.screens.filters.FilterDate;
import tr.view.actions.screens.filters.FilterFactory;
import tr.view.filters.FilterCombo;

public class FiltersDialog
extends JDialog {
    private JPanel bottomPanel;
    private JButton cancelButton;
    private JButton okButton;
    private JPanel panel;
    private JScrollPane scrollPane;
    private final ActionsScreen screen;
    private JPanel filtersPanel;
    private boolean ok;
    private List<FilterFields> filtersList;

    public FiltersDialog(ActionsScreen screen) {
        super(WindowManager.getDefault().getMainWindow(), true);
        this.screen = screen;
        this.initComponents();
        this.scrollPane.setViewportView(this.getPanel());
    }

    private String getText(String key) {
        return NbBundle.getMessage(this.getClass(), (String)key);
    }

    private JPanel getPanel() {
        this.filtersList = new Vector<FilterFields>();
        this.filtersPanel = new JPanel((LayoutManager)new MigLayout("", "4[]4[]4[]4[]4[]4", "0[]0"));
        this.filtersPanel.setBackground(Color.white);
        this.filtersPanel.add((Component)new HeadLabel("FiltersDialog.column.name"), "align center");
        this.filtersPanel.add((Component)new HeadLabel("FiltersDialog.column.used"), "align center");
        this.filtersPanel.add((Component)new HeadLabel("FiltersDialog.column.visible"), "align center");
        this.filtersPanel.add((Component)new HeadLabel("FiltersDialog.column.values"), "align center");
        this.filtersPanel.add((Component)new HeadLabel("FiltersDialog.column.nulls"), "align left, wrap");
        HashMap<Byte, ActionsFilter> actionsFilterMap = new HashMap<Byte, ActionsFilter>();
        for (ActionsFilter af : this.screen.getFilters()) {
            actionsFilterMap.put(af.getIndex(), af);
        }
        for (int i = 0; i < FilterFactory.INDICES.length; ++i) {
            byte index = FilterFactory.INDICES[i];
            if (!actionsFilterMap.containsKey(index)) {
                ActionsFilter af = FilterFactory.instance.createFilter(index);
                actionsFilterMap.put(af.getIndex(), af);
                this.screen.getFilters().add(af);
            }
            FilterFields ff = new FilterFields((ActionsFilter)((Object)actionsFilterMap.get(index)));
            this.filtersList.add(ff);
            this.filtersPanel.add((Component)ff.label, "align left");
            this.filtersPanel.add((Component)ff.useCheckBox, "align left");
            this.filtersPanel.add((Component)ff.seeCheckBox, "align left");
            if (ff.nullsCheckBox == null) {
                this.filtersPanel.add((Component)ff.valFilterCombo.getJComboBox(), "align left, sgx g1, wrap");
                continue;
            }
            this.filtersPanel.add((Component)ff.valFilterCombo.getJComboBox(), "align left, sgx g1");
            this.filtersPanel.add((Component)ff.nullsCheckBox, "align left, wrap");
        }
        return this.filtersPanel;
    }

    public int showDialog() {
        this.ok = false;
        this.setVisible(true);
        return this.ok ? 0 : 2;
    }

    private void initComponents() {
        this.bottomPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.scrollPane = new JScrollPane();
        this.panel = this.getPanel();
        this.setDefaultCloseOperation(2);
        this.setTitle(this.getText("FiltersDialog.title"));
        this.setModal(true);
        this.bottomPanel.setFocusable(false);
        this.bottomPanel.setLayout(new FlowLayout(2, 10, 5));
        this.cancelButton.setText(NbBundle.getMessage(FiltersDialog.class, (String)"FiltersDialog.cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FiltersDialog.this.cancelActionPerformed(evt);
            }
        });
        this.bottomPanel.add(this.cancelButton);
        this.okButton.setText(this.getText("FiltersDialog.ok"));
        this.okButton.setFocusCycleRoot(true);
        this.okButton.setSelected(true);
        this.getRootPane().setDefaultButton(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FiltersDialog.this.okActionPerformed(evt);
            }
        });
        this.bottomPanel.add(this.okButton);
        this.getContentPane().add((Component)this.bottomPanel, "Last");
        this.scrollPane.setViewportView(this.panel);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.pack();
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void okActionPerformed(ActionEvent evt) {
        for (FilterFields ff : this.filtersList) {
            ff.commit();
        }
        this.ok = true;
        this.setVisible(false);
        this.dispose();
    }

    private static class FilterFields {
        public final ActionsFilter filter;
        public final JLabel label;
        public final JCheckBox useCheckBox;
        public final JCheckBox seeCheckBox;
        public final JCheckBox nullsCheckBox;
        public final FilterCombo valFilterCombo;
        private final ActionsFilter tempFilter;

        public FilterFields(ActionsFilter filter) {
            this.filter = filter;
            this.label = new JLabel(filter.getLabel());
            this.label.setBackground(Color.white);
            this.useCheckBox = new JCheckBox();
            this.useCheckBox.setBackground(Color.white);
            this.useCheckBox.setSelected(filter.isUsed());
            this.useCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FilterFields.this.enableDisableComponents(FilterFields.this.useCheckBox.isSelected());
                }
            });
            this.seeCheckBox = new JCheckBox();
            this.seeCheckBox.setBackground(Color.white);
            this.seeCheckBox.setSelected(filter.isShown());
            this.tempFilter = FilterFactory.instance.createFilter(filter.getIndex());
            this.tempFilter.setSerialValues(filter.getSerialValues());
            this.valFilterCombo = this.tempFilter.getFilterCombo();
            if (filter instanceof FilterDate) {
                FilterDate dateFilter = (FilterDate)filter;
                this.nullsCheckBox = new JCheckBox();
                this.nullsCheckBox.setBackground(Color.white);
                this.nullsCheckBox.setSelected(dateFilter.isExcludeNulls());
            } else if (filter instanceof FilterCriterion) {
                FilterCriterion criterionFilter = (FilterCriterion)filter;
                this.nullsCheckBox = new JCheckBox();
                this.nullsCheckBox.setBackground(Color.white);
                this.nullsCheckBox.setSelected(criterionFilter.isExcludeNulls());
            } else {
                this.nullsCheckBox = null;
            }
            this.enableDisableComponents(this.useCheckBox.isSelected());
        }

        private void enableDisableComponents(boolean used) {
            if (!used) {
                this.seeCheckBox.setSelected(false);
                this.valFilterCombo.getJComboBox().setSelectedItem(null);
                if (this.nullsCheckBox != null) {
                    this.nullsCheckBox.setSelected(false);
                }
            }
            this.seeCheckBox.setEnabled(used);
            this.valFilterCombo.getJComboBox().setEnabled(used);
            if (this.nullsCheckBox != null) {
                this.nullsCheckBox.setEnabled(used);
            }
        }

        public void commit() {
            this.filter.setUsed(this.useCheckBox.isSelected());
            this.filter.setShown(this.seeCheckBox.isSelected());
            this.filter.setSerialValues(this.tempFilter.getSerialValues());
            if (this.filter instanceof FilterDate) {
                ((FilterDate)this.filter).setExcludeNulls(this.nullsCheckBox.isSelected());
            } else if (this.filter instanceof FilterCriterion) {
                ((FilterCriterion)this.filter).setExcludeNulls(this.nullsCheckBox.isSelected());
            }
            this.filter.getFilterCombo().fireValueChange();
        }
    }

    private static class HeadLabel
    extends JLabel {
        public HeadLabel(String key) {
            super(NbBundle.getMessage(FiltersDialog.class, (String)key));
            this.setFont(this.getFont().deriveFont(1));
        }
    }
}

