/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import org.netbeans.core.windows.view.Controller;
import org.netbeans.core.windows.view.ui.MainWindow;
import org.openide.util.NbBundle;

public class EditorAreaFrame
extends JFrame {
    private Component desktop;
    private Controller controller;
    private long frametimestamp = 0L;
    private long timeStamp = 0L;
    private long mainWindowStamp = 0L;

    public EditorAreaFrame() {
        super(NbBundle.getMessage(EditorAreaFrame.class, (String)"LBL_EditorAreaFrameTitle"));
        MainWindow.initFrameIcons(this);
    }

    public void setWindowActivationListener(Controller controller) {
        this.controller = controller;
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                if (EditorAreaFrame.this.frametimestamp != 0L && System.currentTimeMillis() > EditorAreaFrame.this.frametimestamp + 500L) {
                    EditorAreaFrame.this.controller.userActivatedEditorWindow();
                }
            }

            public void windowOpened(WindowEvent windowEvent) {
                EditorAreaFrame.this.frametimestamp = System.currentTimeMillis();
            }
        });
    }

    public void toFront() {
        this.frametimestamp = System.currentTimeMillis();
        super.toFront();
    }

    public void setVisible(boolean bl) {
        this.frametimestamp = System.currentTimeMillis();
        super.setVisible(bl);
    }

    public void setDesktop(Component component) {
        if (this.desktop == component) {
            return;
        }
        if (this.desktop != null) {
            this.getContentPane().remove(this.desktop);
        }
        this.desktop = component;
        if (component != null) {
            this.getContentPane().add(component);
        }
    }

    public void setUserStamp(long l) {
        this.timeStamp = l;
    }

    public long getUserStamp() {
        return this.timeStamp;
    }

    public void setMainWindowStamp(long l) {
        this.mainWindowStamp = l;
    }

    public long getMainWindowStamp() {
        return this.mainWindowStamp;
    }
}

