/*===------- llvm/Config/llvm-config.h - llvm configuration -------*- C -*-===*/
/*                                                                            */
/*                     The LLVM Compiler Infrastructure                       */
/*                                                                            */
/* This file is distributed under the University of Illinois Open Source      */
/* License. See LICENSE.TXT for details.                                      */
/*                                                                            */
/*===----------------------------------------------------------------------===*/

/* This file enumerates variables from the LLVM configuration so that they
   can be in exported headers and won't override package specific directives.
   This is a C header that can be included in the llvm-c headers. */

#ifndef LLVM_CONFIG_H
#define LLVM_CONFIG_H

/*
 * When bsd.lib.mk builds shared libraries it builds with -DPIC which 
 * causes problems in the following files which use PIC as a variable name.
 * undefine PIC here to minimise the diff to upstream LLVM
 *
 * include/llvm/MC/MCObjectFileInfo.h
 * lib/MC/MCObjectFileInfo.cpp
 * lib/Transforms/Scalar/LICM.cpp
 * lib/Transforms/Utils/PredicateInfo.cpp
 */
#undef PIC

/* Define if LLVM_ENABLE_DUMP is enabled */
/* #undef LLVM_ENABLE_DUMP */

/* Define if threads enabled */
#define LLVM_ENABLE_THREADS 1

/* Has gcc/MSVC atomic intrinsics */
#define LLVM_HAS_ATOMICS 1

/* Define if this is Unixish platform */
#define LLVM_ON_UNIX 1

/* Define if we have the Intel JIT API runtime support library */
#define LLVM_USE_INTEL_JITEVENTS 0

/* Define if we have the oprofile JIT-support library */
#define LLVM_USE_OPROFILE 0

/* Define if we have the perf JIT-support library */
#define LLVM_USE_PERF 0

/* Major version of the LLVM API */
#define LLVM_VERSION_MAJOR 13

/* Minor version of the LLVM API */
#define LLVM_VERSION_MINOR 0

/* Patch version of the LLVM API */
#define LLVM_VERSION_PATCH 0

/* LLVM version string */
#define LLVM_VERSION_STRING "13.0.0"

/* Whether LLVM records statistics for use with GetStatistics(),
 * PrintStatistics() or PrintStatisticsJSON()
 */
#define LLVM_FORCE_ENABLE_STATS 0

/* Define if we have z3 and want to build it */
/* #undef LLVM_WITH_Z3 */

/* Define if LLVM was built with a dependency to the libtensorflow dynamic library */
/* #undef LLVM_HAVE_TF_API */

/* Define if LLVM was built with a dependency to the tensorflow compiler */
/* #undef LLVM_HAVE_TF_AOT */

/* Define to 1 if you have the <sysexits.h> header file. */
#define HAVE_SYSEXITS_H 1

/* Define to 1 to enable the experimental new pass manager by default */
#define LLVM_ENABLE_NEW_PASS_MANAGER 0

/* Define if the xar_open() function is supported on this platform. */
/* #undef LLVM_HAVE_LIBXAR */

/* Whether Timers signpost passes in Xcode Instruments */
#define LLVM_SUPPORT_XCODE_SIGNPOSTS 0


#define LLVM_DEFAULT_TARGET_TRIPLE "sparc64-unknown-openbsd7.3"
#define LLVM_HOST_TRIPLE "sparc64-unknown-openbsd7.3"
#define LLVM_NATIVE_ARCH Sparc
#define LLVM_NATIVE_ASMPARSER LLVMInitializeSparcAsmParser
#define LLVM_NATIVE_ASMPRINTER LLVMInitializeSparcAsmPrinter
#define LLVM_NATIVE_DISASSEMBLER LLVMInitializeSparcDisassembler
#define LLVM_NATIVE_TARGET LLVMInitializeSparcTarget
#define LLVM_NATIVE_TARGETINFO LLVMInitializeSparcTargetInfo
#define LLVM_NATIVE_TARGETMC LLVMInitializeSparcTargetMC

#endif
