untrusted comment: verify with openbsd-66-base.pub
RWSvK/c+cFe24MXlbKl6/FdwgJMOyKyF4W8yvcEIvE8/Ld7ajh2fTGo/eJ6+PSWlQ03VziJELootkXWb8y3CLzaFVqNcOGRzWAE=

OpenBSD 6.6 errata 016, December 20, 2019:

ripd(8) fails to validate authentication lengths.

Apply by doing:
    signify -Vep /etc/signify/openbsd-66-base.pub -x 016_ripd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install ripd:
    cd /usr/src/usr.sbin/ripd
    make obj
    make
    make install

Index: usr.sbin/ripd/auth.c
===================================================================
RCS file: /cvs/src/usr.sbin/ripd/auth.c,v
diff -u -p -u -r1.11 auth.c
--- usr.sbin/ripd/auth.c	26 May 2010 13:56:08 -0000	1.11
+++ usr.sbin/ripd/auth.c	19 Dec 2019 01:26:50 -0000
@@ -144,6 +144,14 @@ auth_validate(u_int8_t **buf, u_int16_t 
 			return (-1);
 		}
 
+		if (ntohs(a->auth_offset) != *len + RIP_HDR_LEN -
+		    AUTH_TRLR_HDR_LEN - MD5_DIGEST_LENGTH) {
+			log_debug("auth_validate: invalid authentication data "
+			    "offset %hu, interface %s", ntohs(a->auth_offset),
+			    iface->name);
+			return (-1);
+		}
+
 		auth_data = *buf;
 		auth_data += ntohs(a->auth_offset);
 
