/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl;

import ca.sqlpower.architect.ddl.DDLStatement;
import ca.sqlpower.architect.ddl.GenericDDLGenerator;
import ca.sqlpower.architect.ddl.GenericTypeDescriptor;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.SPResolverRegistry;
import ca.sqlpower.object.SPVariableHelper;
import ca.sqlpower.object.SPVariableResolver;
import ca.sqlpower.sqlobject.SQLCheckConstraint;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLEnumeration;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.sqlobject.SQLTypePhysicalProperties;
import ca.sqlpower.sqlobject.UserDefinedSQLType;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class H2DDLGenerator
extends GenericDDLGenerator {
    public static final String GENERATOR_VERSION = "$Revision: 2933 $";

    @Override
    public String getName() {
        return "H2 Database";
    }

    @Override
    public String getCatalogTerm() {
        return null;
    }

    @Override
    public String getSchemaTerm() {
        return "Schema";
    }

    @Override
    protected String getPlatformName() {
        return "H2 Database";
    }

    @Override
    public String columnType(SQLColumn c) {
        if (c.isAutoIncrement()) {
            return "IDENTITY";
        }
        return super.columnType(c);
    }

    @Override
    public String getDeferrabilityClause(SQLRelationship r) {
        if (this.supportsDeferrabilityPolicy(r)) {
            return "";
        }
        throw new UnsupportedOperationException(this.getName() + " does not support " + r.getName() + "'s deferrability policy (" + r.getDeferrability() + ").");
    }

    @Override
    public boolean supportsDeferrabilityPolicy(SQLRelationship r) {
        if (!Arrays.asList(SQLRelationship.Deferrability.values()).contains(r.getDeferrability())) {
            throw new IllegalArgumentException("Unknown deferrability policy: " + r.getDeferrability());
        }
        return r.getDeferrability() == SQLRelationship.Deferrability.NOT_DEFERRABLE;
    }

    @Override
    protected void createTypeMap() throws SQLException {
        this.typeMap = new HashMap();
        this.typeMap.put(-5, new GenericTypeDescriptor("BIGINT", -5, 1000L, null, null, 1, true, false));
        this.typeMap.put(-2, new GenericTypeDescriptor("BINARY", -2, 4000000000L, null, null, 1, false, false));
        this.typeMap.put(-7, new GenericTypeDescriptor("BIT", -7, 1L, null, null, 1, true, false));
        this.typeMap.put(2004, new GenericTypeDescriptor("LONGVARBINARY", 2004, 4000000000L, null, null, 1, false, false));
        this.typeMap.put(16, new GenericTypeDescriptor("BOOLEAN", 16, 1L, null, null, 1, false, false));
        this.typeMap.put(1, new GenericTypeDescriptor("CHAR", 1, 4000000000L, "'", "'", 1, true, false));
        this.typeMap.put(2005, new GenericTypeDescriptor("LONGVARCHAR", 2005, 4000000000L, null, null, 1, false, false));
        this.typeMap.put(91, new GenericTypeDescriptor("DATE", 91, 0L, "'", "'", 1, false, false));
        this.typeMap.put(3, new GenericTypeDescriptor("DECIMAL", 3, 1000L, null, null, 1, true, true));
        this.typeMap.put(8, new GenericTypeDescriptor("DOUBLE", 8, 38L, null, null, 1, false, false));
        this.typeMap.put(6, new GenericTypeDescriptor("FLOAT", 6, 38L, null, null, 1, false, false));
        this.typeMap.put(4, new GenericTypeDescriptor("INTEGER", 4, 38L, null, null, 1, false, false));
        this.typeMap.put(-4, new GenericTypeDescriptor("LONGVARBINARY", -4, 4000000000L, null, null, 1, false, false));
        this.typeMap.put(-1, new GenericTypeDescriptor("LONGVARCHAR", -1, 4000000000L, "'", "'", 1, false, false));
        this.typeMap.put(2, new GenericTypeDescriptor("NUMERIC", 2, 1000L, null, null, 1, true, true));
        this.typeMap.put(7, new GenericTypeDescriptor("REAL", 7, 38L, null, null, 1, false, false));
        this.typeMap.put(5, new GenericTypeDescriptor("SMALLINT", 5, 16L, null, null, 1, false, false));
        this.typeMap.put(92, new GenericTypeDescriptor("TIME", 92, 0L, "'", "'", 1, false, false));
        this.typeMap.put(93, new GenericTypeDescriptor("TIMESTAMP", 93, 0L, "'", "'", 1, false, false));
        this.typeMap.put(-6, new GenericTypeDescriptor("TINYINT", -6, 16L, null, null, 1, false, false));
        this.typeMap.put(-3, new GenericTypeDescriptor("VARBINARY", -3, 4000000000L, null, null, 1, false, false));
        this.typeMap.put(12, new GenericTypeDescriptor("VARCHAR", 12, 4000000000L, "'", "'", 1, true, false));
        this.typeMap.put(-9, new GenericTypeDescriptor("NVARCHAR", -9, 4000000000L, "'", "'", 1, true, false));
        this.typeMap.put(-15, new GenericTypeDescriptor("NCHAR", -15, 4000000000L, "'", "'", 1, true, false));
        this.typeMap.put(2011, new GenericTypeDescriptor("NCLOB", 2011, 4000000000L, "'", "'", 1, true, false));
    }

    @Override
    public boolean supportsUpdateAction(SQLRelationship r) {
        return r.getUpdateRule() != SQLRelationship.UpdateDeleteRule.RESTRICT;
    }

    @Override
    public String getUpdateActionClause(SQLRelationship r) {
        if (r.getUpdateRule() == SQLRelationship.UpdateDeleteRule.RESTRICT) {
            throw new IllegalArgumentException("Unsupported update action: " + r.getUpdateRule());
        }
        return super.getUpdateActionClause(r);
    }

    @Override
    public boolean supportsDeleteAction(SQLRelationship r) {
        return r.getDeleteRule() != SQLRelationship.UpdateDeleteRule.RESTRICT;
    }

    @Override
    public String getDeleteActionClause(SQLRelationship r) {
        if (r.getDeleteRule() == SQLRelationship.UpdateDeleteRule.RESTRICT) {
            throw new IllegalArgumentException("Unsupported update action: " + r.getDeleteRule());
        }
        return super.getDeleteActionClause(r);
    }

    public String toString() {
        return "SQL Power H2 DDL Generator $Revision: 2933 $";
    }

    @Override
    public void renameColumn(SQLColumn oldCol, SQLColumn newCol) {
        HashMap<String, SQLObject> colNameMap = new HashMap<String, SQLObject>();
        this.print("\nALTER TABLE ");
        this.print(this.toQualifiedName(oldCol.getParent()));
        this.print(" ALTER COLUMN ");
        this.print(this.createPhysicalName(colNameMap, (SQLObject)oldCol));
        this.print(" RENAME TO ");
        this.print(this.createPhysicalName(colNameMap, (SQLObject)newCol));
        this.endStatement(DDLStatement.StatementType.ALTER, (SQLObject)newCol);
    }

    @Override
    public void addTable(SQLTable t) throws SQLException, SQLObjectException {
        HashMap<String, SQLObject> colNameMap = new HashMap<String, SQLObject>();
        this.createPhysicalName(this.topLevelNames, (SQLObject)t);
        this.print("\nCREATE TABLE ");
        this.print(this.toQualifiedName(t));
        this.println(" (");
        boolean firstCol = true;
        List columns = t.getColumns();
        for (SQLColumn c : columns) {
            if (!firstCol) {
                this.println(",");
            }
            this.print("                ");
            this.print(this.columnDefinition(c, colNameMap));
            firstCol = false;
        }
        SQLIndex pk = t.getPrimaryKeyIndex();
        if (pk.getChildCount() > 0) {
            this.print(",\n");
            this.print("                ");
            this.writePKConstraintClause(pk);
        }
        for (SQLColumn c : columns) {
            List checkConstraints;
            UserDefinedSQLType type = c.getUserDefinedSQLType();
            SQLTypePhysicalProperties.SQLTypeConstraint constraintType = type.getConstraintType(this.getPlatformName());
            if (constraintType == null) {
                constraintType = type.getDefaultPhysicalProperties().getConstraintType();
                checkConstraints = type.getDefaultPhysicalProperties().getCheckConstraints();
            } else {
                checkConstraints = type.getCheckConstraints(this.getPlatformName());
            }
            if (constraintType != SQLTypePhysicalProperties.SQLTypeConstraint.CHECK) continue;
            this.print(",\n");
            this.print(this.columnCheckConstraint(c, checkConstraints));
        }
        this.print("\n)");
        this.endStatement(DDLStatement.StatementType.CREATE, (SQLObject)t);
        this.addComment(t, true);
    }

    @Override
    protected String columnCheckConstraint(SQLColumn c, List<SQLCheckConstraint> checkConstraints) {
        if (!this.supportsCheckConstraint() || c == null || checkConstraints == null || checkConstraints.isEmpty()) {
            return "";
        }
        SPVariableResolver resolver = c.getVariableResolver();
        SPVariableHelper helper = new SPVariableHelper((SPObject)c);
        SPResolverRegistry.register((SPObject)c, (SPVariableResolver)resolver);
        StringBuilder sb = new StringBuilder();
        for (SQLCheckConstraint constraint : checkConstraints) {
            if (sb.length() > 0) {
                sb.append(",\n");
            }
            sb.append("                ");
            sb.append(String.format("CONSTRAINT %s CHECK (%s)", constraint.getName(), helper.substitute(constraint.getConstraint())));
        }
        SPResolverRegistry.deregister((SPObject)c, (SPVariableResolver)resolver);
        return sb.toString();
    }

    @Override
    protected String columnDefinition(SQLColumn c, Map<String, SQLObject> colNameMap) {
        String columnEnumeration;
        List enumerations;
        StringBuffer def = new StringBuffer();
        def.append(this.createPhysicalName(colNameMap, (SQLObject)c));
        def.append(" ");
        def.append(this.columnType(c));
        UserDefinedSQLType type = c.getUserDefinedSQLType();
        String defaultValue = type.getDefaultValue(this.getPlatformName());
        if (defaultValue != null && !defaultValue.equals("")) {
            def.append(" ");
            def.append("DEFAULT ");
            def.append(defaultValue);
        }
        def.append(this.columnNullability(c));
        SQLTypePhysicalProperties.SQLTypeConstraint constraintType = type.getConstraintType(this.getPlatformName());
        if (constraintType == null) {
            constraintType = type.getDefaultPhysicalProperties().getConstraintType();
            enumerations = type.getDefaultPhysicalProperties().getChildrenWithoutPopulating(SQLEnumeration.class);
        } else {
            enumerations = type.getEnumerations(this.getPlatformName());
        }
        if (constraintType == SQLTypePhysicalProperties.SQLTypeConstraint.ENUM && (columnEnumeration = this.columnEnumeration(c, enumerations)) != null && columnEnumeration.length() > 0) {
            def.append(" " + columnEnumeration);
        }
        return def.toString();
    }
}

