/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.PlayPenLabel;
import ca.sqlpower.architect.swingui.Relationship;
import ca.sqlpower.architect.swingui.Selectable;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.action.Messages;
import ca.sqlpower.architect.swingui.event.SelectionEvent;
import ca.sqlpower.architect.swingui.event.SelectionListener;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLTable;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class EditSelectedAction
extends AbstractArchitectAction
implements SelectionListener {
    private static final Logger logger = Logger.getLogger(EditSelectedAction.class);

    public EditSelectedAction(ArchitectFrame frame) {
        super(frame, Messages.getString("EditSelectedAction.name"), Messages.getString("EditSelectedAction.description"), "edit_selected");
        frame.addSelectionListener(this);
        this.setupAction(this.getPlaypen().getSelectedItems());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<PlayPenComponent> selection = this.getPlaypen().getSelectedItems();
        boolean tablesSelected = false;
        boolean relationshipsSelected = false;
        boolean columnsSelected = false;
        boolean labelsSelected = false;
        for (PlayPenComponent ppc : selection) {
            if (ppc instanceof TablePane) {
                tablesSelected = true;
                TablePane tp = (TablePane)ppc;
                if (tp.getSelectedItemIndex() < 0) continue;
                columnsSelected = true;
                continue;
            }
            if (ppc instanceof Relationship) {
                relationshipsSelected = true;
                continue;
            }
            if (!(ppc instanceof PlayPenLabel)) continue;
            labelsSelected = true;
        }
        if (columnsSelected && !relationshipsSelected && !labelsSelected) {
            this.frame.getEditColumnAction().actionPerformed(e);
        } else if (tablesSelected && !relationshipsSelected && !labelsSelected) {
            this.frame.getEditTableAction().actionPerformed(e);
        } else if (relationshipsSelected && !tablesSelected && !labelsSelected) {
            this.frame.getEditRelationshipAction().actionPerformed(e);
        } else if (labelsSelected && !tablesSelected && !relationshipsSelected) {
            this.frame.getEditLabelAction().actionPerformed(e);
        } else if (selection.size() > 0) {
            JOptionPane.showMessageDialog(this.frame, Messages.getString("EditSelectedAction.multipleItemsSelected"));
        } else {
            JOptionPane.showMessageDialog(this.frame, Messages.getString("EditSelectedAction.noItemsSelected"));
        }
    }

    @Override
    public void itemSelected(SelectionEvent e) {
        this.setupAction(this.getPlaypen().getSelectedItems());
    }

    @Override
    public void itemDeselected(SelectionEvent e) {
        this.setupAction(this.getPlaypen().getSelectedItems());
    }

    private void setupAction(List<PlayPenComponent> selectedItems) {
        String description;
        if (selectedItems.size() == 0) {
            this.setEnabled(false);
            description = Messages.getString("EditSelectedAction.editSelected");
        } else if (selectedItems.size() == 1) {
            String name;
            block13: {
                Selectable item = selectedItems.get(0);
                this.setEnabled(true);
                name = Messages.getString("EditSelectedAction.selected");
                if (item instanceof TablePane) {
                    TablePane tp = (TablePane)item;
                    if (tp.getSelectedItemIndex() >= 0) {
                        try {
                            List selectedColumns = tp.getSelectedItems();
                            if (selectedColumns.size() > 1) {
                                name = Messages.getString("EditSelectedAction.numberOfitems", String.valueOf(selectedColumns.size()));
                                break block13;
                            }
                            name = ((SQLTable)tp.getModel()).getColumn(tp.getSelectedItemIndex()).getName();
                        }
                        catch (SQLObjectException ex) {
                            logger.error((Object)"Couldn't get selected column name", (Throwable)ex);
                        }
                    } else {
                        name = ((SQLTable)tp.getModel()).getName();
                    }
                } else if (item instanceof Relationship) {
                    name = ((Relationship)item).getModel().getName();
                }
            }
            description = Messages.getString("EditSelectedAction.editItem", name);
        } else {
            this.setEnabled(true);
            int numSelectedItems = 0;
            for (PlayPenComponent item : selectedItems) {
                ++numSelectedItems;
                if (!(item instanceof TablePane)) continue;
                numSelectedItems += Math.max(((TablePane)item).getSelectedItems().size() - 1, 0);
            }
            description = Messages.getString("EditSelectedAction.editNumberOfItems", String.valueOf(numSelectedItems));
        }
        this.putValue("ShortDescription", description + Messages.getString("EditSelectedAction.shortcut"));
    }
}

