/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.compatibility;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import org.pentaho.di.compatibility.ValueInterface;

public class ValueBigNumber
implements ValueInterface,
Cloneable {
    private BigDecimal number;
    private int length;
    private int precision;

    public ValueBigNumber() {
        this.number = null;
        this.length = -1;
        this.precision = -1;
    }

    public ValueBigNumber(BigDecimal number) {
        this.number = number;
        this.length = -1;
        this.precision = -1;
    }

    public int getType() {
        return 6;
    }

    public Serializable getSerializable() {
        return this.number;
    }

    public String getTypeDesc() {
        return "BigNumber";
    }

    public String getString() {
        if (this.number == null) {
            return null;
        }
        return this.number.toString();
    }

    public double getNumber() {
        if (this.number == null) {
            return 0.0;
        }
        return this.number.doubleValue();
    }

    public Date getDate() {
        if (this.number == null) {
            return null;
        }
        return new Date(this.number.longValue());
    }

    public boolean getBoolean() {
        if (this.number == null) {
            return false;
        }
        return this.number.longValue() != 0L;
    }

    public long getInteger() {
        if (this.number == null) {
            return 0L;
        }
        return this.number.longValue();
    }

    public void setString(String string) {
        try {
            this.number = new BigDecimal(string);
        }
        catch (NumberFormatException e) {
            this.number = BigDecimal.ZERO;
        }
    }

    public void setNumber(double number) {
        this.number = BigDecimal.valueOf(number);
    }

    public void setDate(Date date) {
        this.number = new BigDecimal(date.getTime());
    }

    public void setBoolean(boolean bool) {
        this.number = bool ? BigDecimal.ONE : BigDecimal.ZERO;
    }

    public void setInteger(long number) {
        this.number = new BigDecimal(number);
    }

    public void setSerializable(Serializable ser) {
    }

    public int getLength() {
        return this.length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setLength(int length, int precision) {
        this.length = length;
        this.precision = precision;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public Object clone() {
        try {
            ValueBigNumber retval = (ValueBigNumber)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public BigDecimal getBigNumber() {
        return this.number;
    }

    public void setBigNumber(BigDecimal number) {
        this.number = number;
    }

    public byte[] getBytes() {
        return null;
    }

    public void setBytes(byte[] b) {
    }
}

