/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.transform;

import java.util.ArrayList;
import java.util.List;
import org.olap4j.transform.TreeNodeCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TreeNode<T> {
    private TreeNode<T> parent = null;
    private final List<TreeNode<T>> children;
    private T reference;

    public TreeNode(T data) {
        this.reference = data;
        this.children = new ArrayList<TreeNode<T>>();
    }

    public void remove() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
    }

    public void removeChild(TreeNode<T> child) {
        if (this.children.contains(child)) {
            this.children.remove(child);
        }
    }

    public void addChildNode(TreeNode<T> child) {
        child.parent = this;
        if (!this.children.contains(child)) {
            this.children.add(child);
        }
    }

    public TreeNode<T> deepCopy() {
        TreeNode<T> newNode = new TreeNode<T>(this.reference);
        for (TreeNode<T> child : this.children) {
            newNode.addChildNode(child.deepCopy());
        }
        return newNode;
    }

    public TreeNode<T> deepCopyPrune(int depth) {
        if (depth < 0) {
            throw new IllegalArgumentException("Depth is negative");
        }
        TreeNode<T> newNode = new TreeNode<T>(this.reference);
        if (depth == 0) {
            return newNode;
        }
        for (TreeNode<T> child : this.children) {
            newNode.addChildNode(child.deepCopyPrune(depth - 1));
        }
        return newNode;
    }

    public int getLevel() {
        int level = 0;
        TreeNode<T> p = this.parent;
        while (p != null) {
            ++level;
            p = p.parent;
        }
        return level;
    }

    public List<TreeNode<T>> getChildren() {
        return this.children;
    }

    public TreeNode<T> getParent() {
        return this.parent;
    }

    public T getReference() {
        return this.reference;
    }

    public void setReference(T ref) {
        this.reference = ref;
    }

    public int walkTree(TreeNodeCallback<T> callbackHandler) {
        int code = callbackHandler.handleTreeNode(this);
        if (code != 0) {
            return code;
        }
        for (TreeNode<T> child : this.children) {
            code = child.walkTree(callbackHandler);
            if (code < 2) continue;
            return code;
        }
        return code;
    }

    public int walkChildren(TreeNodeCallback<T> callbackHandler) {
        int code = 0;
        for (TreeNode<T> child : this.children) {
            code = callbackHandler.handleTreeNode(child);
            if (code >= 2) {
                return code;
            }
            if (code != 0 || (code = child.walkChildren(callbackHandler)) <= 2) continue;
            return code;
        }
        return code;
    }
}

