/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.xml;

import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XMLWriter;

public class XmlWriterUtil {
    public static final String LS = System.getProperty("line.separator");
    public static final int DEFAULT_INDENTATION_SIZE = 2;
    public static final int DEFAULT_COLUMN_LINE = 80;

    public static void writeLineBreak(XMLWriter writer2) {
        XmlWriterUtil.writeLineBreak(writer2, 1);
    }

    public static void writeLineBreak(XMLWriter writer2, int repeat2) {
        for (int i = 0; i < repeat2; ++i) {
            writer2.writeMarkup(LS);
        }
    }

    public static void writeLineBreak(XMLWriter writer2, int repeat2, int indent2) {
        XmlWriterUtil.writeLineBreak(writer2, repeat2, indent2, 2);
    }

    public static void writeLineBreak(XMLWriter writer2, int repeat2, int indent2, int indentSize) {
        XmlWriterUtil.writeLineBreak(writer2, repeat2);
        if (indent2 < 0) {
            indent2 = 0;
        }
        if (indentSize < 0) {
            indentSize = 0;
        }
        writer2.writeText(StringUtils.repeat(" ", indent2 * indentSize));
    }

    public static void writeCommentLineBreak(XMLWriter writer2) {
        XmlWriterUtil.writeCommentLineBreak(writer2, 80);
    }

    public static void writeCommentLineBreak(XMLWriter writer2, int columnSize) {
        if (columnSize < 10) {
            columnSize = 80;
        }
        writer2.writeMarkup("<!-- " + StringUtils.repeat("=", columnSize - 10) + " -->" + LS);
    }

    public static void writeComment(XMLWriter writer2, String comment2) {
        XmlWriterUtil.writeComment(writer2, comment2, 0, 2);
    }

    public static void writeComment(XMLWriter writer2, String comment2, int indent2) {
        XmlWriterUtil.writeComment(writer2, comment2, indent2, 2);
    }

    public static void writeComment(XMLWriter writer2, String comment2, int indent2, int indentSize) {
        XmlWriterUtil.writeComment(writer2, comment2, indent2, indentSize, 80);
    }

    public static void writeComment(XMLWriter writer2, String comment2, int indent2, int indentSize, int columnSize) {
        if (comment2 == null) {
            comment2 = "null";
        }
        while (comment2.contains("<!--")) {
            comment2 = comment2.replace("<!--", "");
        }
        while (comment2.contains("-->")) {
            comment2 = comment2.replace("-->", "");
        }
        if (indent2 < 0) {
            indent2 = 0;
        }
        if (indentSize < 0) {
            indentSize = 0;
        }
        if (columnSize < 0) {
            columnSize = 80;
        }
        String indentation = StringUtils.repeat(" ", indent2 * indentSize);
        int magicNumber = indentation.length() + columnSize - "-->".length() - 1;
        String[] sentences = StringUtils.split(comment2, LS);
        StringBuffer line = new StringBuffer(indentation + "<!-- ");
        for (String sentence : sentences) {
            String[] words;
            for (String word : words = StringUtils.split(sentence, " ")) {
                StringBuilder sentenceTmp = new StringBuilder(line.toString());
                sentenceTmp.append(word).append(' ');
                if (sentenceTmp.length() > magicNumber) {
                    if (line.length() != indentation.length() + "<!-- ".length()) {
                        if (magicNumber - line.length() > 0) {
                            line.append(StringUtils.repeat(" ", magicNumber - line.length()));
                        }
                        line.append("-->").append(LS);
                        writer2.writeMarkup(line.toString());
                    }
                    line = new StringBuffer(indentation + "<!-- ");
                    line.append(word).append(' ');
                    continue;
                }
                line.append(word).append(' ');
            }
            if (magicNumber - line.length() <= 0) continue;
            line.append(StringUtils.repeat(" ", magicNumber - line.length()));
        }
        if (line.length() <= magicNumber) {
            line.append(StringUtils.repeat(" ", magicNumber - line.length()));
        }
        line.append("-->").append(LS);
        writer2.writeMarkup(line.toString());
    }

    public static void writeCommentText(XMLWriter writer2, String comment2) {
        XmlWriterUtil.writeCommentText(writer2, comment2, 0, 2);
    }

    public static void writeCommentText(XMLWriter writer2, String comment2, int indent2) {
        XmlWriterUtil.writeCommentText(writer2, comment2, indent2, 2);
    }

    public static void writeCommentText(XMLWriter writer2, String comment2, int indent2, int indentSize) {
        XmlWriterUtil.writeCommentText(writer2, comment2, indent2, indentSize, 80);
    }

    public static void writeCommentText(XMLWriter writer2, String comment2, int indent2, int indentSize, int columnSize) {
        if (indent2 < 0) {
            indent2 = 0;
        }
        if (indentSize < 0) {
            indentSize = 0;
        }
        if (columnSize < 0) {
            columnSize = 80;
        }
        XmlWriterUtil.writeLineBreak(writer2, 1);
        writer2.writeMarkup(StringUtils.repeat(" ", indent2 * indentSize));
        XmlWriterUtil.writeCommentLineBreak(writer2, columnSize);
        XmlWriterUtil.writeComment(writer2, comment2, indent2, indentSize, columnSize);
        writer2.writeMarkup(StringUtils.repeat(" ", indent2 * indentSize));
        XmlWriterUtil.writeCommentLineBreak(writer2, columnSize);
        XmlWriterUtil.writeLineBreak(writer2, 1, indent2, indentSize);
    }
}

