/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RegionDescription;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribeRegions
extends BaseCmd {
    public DescribeRegions(String[] args) {
        super("ec2dre", "ec2-describe-regions");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options o = new Options();
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FILTER");
        OptionBuilder.withDescription((String)"Add a filter criterion for the result-set.");
        o.addOption(OptionBuilder.create((String)"F"));
        return o;
    }

    @Override
    protected String getOptionString() {
        return "[REGION [REGION [...]]]";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     List the regions you have access to.");
        System.out.println("     The REGION parameter specifies the region(s) to be described.");
        System.out.println("     If unspecified, all your regions will be returned.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("filter");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String[] zones = this.getNonOptions();
        RequestResultPair rsp = jec2.describeRegions(zones, this.getFilters(true));
        for (RegionDescription d : (List)rsp.getResponse()) {
            out.output(System.out, d);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new DescribeRegions(args).invoke();
    }
}

