/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.awt.event.ActionEvent;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.MapboardAction;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Tile;

public class MoveAction
extends MapboardAction {
    public static final String id = "moveAction.";
    private final Direction direction;

    public MoveAction(FreeColClient freeColClient, Direction direction) {
        super(freeColClient, id + direction);
        this.direction = direction;
    }

    public MoveAction(FreeColClient freeColClient, Direction direction, boolean secondary) {
        super(freeColClient, id + direction + ".secondary");
        this.direction = direction;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        GUI gui = this.getGUI();
        switch (gui.getViewMode()) {
            case MOVE_UNITS: {
                this.igc().moveUnit(gui.getActiveUnit(), this.direction);
                break;
            }
            case TERRAIN: {
                Tile newTile;
                Tile tile = gui.getSelectedTile();
                if (tile == null || (newTile = tile.getNeighbourOrNull(this.direction)) == null) break;
                gui.changeView(newTile);
                break;
            }
        }
    }
}

