/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.specs.Spec;
import org.gradle.cache.internal.FileContentCache;
import org.gradle.cache.internal.FileContentCacheFactory;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value=Scopes.UserHome.class)
public class JavaModuleDetector {
    private final Spec<? super File> classpathFilter = this::isNotModule;
    private final Spec<? super File> modulePathFilter = this::isModule;
    private static final String MODULE_INFO_SOURCE_FILE = "module-info.java";
    private static final String MODULE_INFO_CLASS_FILE = "module-info.class";
    private static final String AUTOMATIC_MODULE_NAME_ATTRIBUTE = "Automatic-Module-Name";
    private static final String MULTI_RELEASE_ATTRIBUTE = "Multi-Release";
    private static final Pattern MODULE_INFO_CLASS_MRJAR_PATH = Pattern.compile("META-INF/versions/\\d+/module-info.class");
    private final FileContentCache<Boolean> cache;
    private final FileCollectionFactory fileCollectionFactory;

    public JavaModuleDetector(FileContentCacheFactory cacheFactory, FileCollectionFactory fileCollectionFactory) {
        this.cache = cacheFactory.newCache("java-modules", 20000, (FileContentCacheFactory.Calculator)new ModuleInfoLocator(), new BaseSerializerFactory().getSerializerFor(Boolean.class));
        this.fileCollectionFactory = fileCollectionFactory;
    }

    public FileCollection inferClasspath(boolean inferModulePath, Collection<File> classpath) {
        return this.inferClasspath(inferModulePath, (FileCollection)this.fileCollectionFactory.fixed(classpath));
    }

    public FileCollection inferClasspath(boolean inferModulePath, FileCollection classpath) {
        if (classpath == null) {
            return FileCollectionFactory.empty();
        }
        if (!inferModulePath) {
            return classpath;
        }
        return classpath.filter(this.classpathFilter);
    }

    public FileCollection inferModulePath(boolean inferModulePath, Collection<File> classpath) {
        return this.inferModulePath(inferModulePath, (FileCollection)this.fileCollectionFactory.fixed(classpath));
    }

    public FileCollection inferModulePath(boolean inferModulePath, FileCollection classpath) {
        if (classpath == null) {
            return FileCollectionFactory.empty();
        }
        if (!inferModulePath) {
            return FileCollectionFactory.empty();
        }
        return classpath.filter(this.modulePathFilter);
    }

    public boolean isModule(boolean inferModulePath, FileCollection files) {
        if (!inferModulePath) {
            return false;
        }
        for (File file : files.getFiles()) {
            if (!this.isModule(file)) continue;
            return true;
        }
        return false;
    }

    public boolean isModule(boolean inferModulePath, File file) {
        if (!inferModulePath) {
            return false;
        }
        return this.isModule(file);
    }

    private boolean isModule(File file) {
        if (!file.exists()) {
            return false;
        }
        return (Boolean)this.cache.get(file);
    }

    private boolean isNotModule(File file) {
        if (!file.exists()) {
            return false;
        }
        return !this.isModule(file);
    }

    public static boolean isModuleSource(boolean inferModulePath, Iterable<File> sourcesRoots) {
        if (!inferModulePath) {
            return false;
        }
        for (File srcFolder : sourcesRoots) {
            if (!JavaModuleDetector.isModuleSourceFolder(srcFolder)) continue;
            return true;
        }
        return false;
    }

    private static boolean isModuleSourceFolder(File folder) {
        return new File(folder, MODULE_INFO_SOURCE_FILE).exists();
    }

    private static class ModuleInfoLocator
    implements FileContentCacheFactory.Calculator<Boolean> {
        private ModuleInfoLocator() {
        }

        public Boolean calculate(File file, boolean isRegularFile) {
            if (isRegularFile) {
                return this.isJarFile(file) && this.isModuleJar(file);
            }
            return this.isModuleFolder(file);
        }

        private boolean isJarFile(File file) {
            return file.getName().endsWith(".jar");
        }

        private boolean isModuleFolder(File folder) {
            return new File(folder, JavaModuleDetector.MODULE_INFO_CLASS_FILE).exists();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean isModuleJar(File jarFile) {
            try (JarInputStream jarStream = new JarInputStream(new FileInputStream(jarFile));){
                if (this.containsAutomaticModuleName(jarStream)) {
                    boolean bl = true;
                    return bl;
                }
                boolean isMultiReleaseJar = this.containsMultiReleaseJarEntry(jarStream);
                ZipEntry next = jarStream.getNextEntry();
                while (next != null) {
                    if (JavaModuleDetector.MODULE_INFO_CLASS_FILE.equals(next.getName())) {
                        boolean bl = true;
                        return bl;
                    }
                    if (isMultiReleaseJar && MODULE_INFO_CLASS_MRJAR_PATH.matcher(next.getName()).matches()) {
                        boolean bl = true;
                        return bl;
                    }
                    next = jarStream.getNextEntry();
                }
                return false;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private boolean containsMultiReleaseJarEntry(JarInputStream jarStream) {
            Manifest manifest = jarStream.getManifest();
            return manifest != null && Boolean.parseBoolean(manifest.getMainAttributes().getValue(JavaModuleDetector.MULTI_RELEASE_ATTRIBUTE));
        }

        private boolean containsAutomaticModuleName(JarInputStream jarStream) {
            return this.getAutomaticModuleName(jarStream.getManifest()) != null;
        }

        private String getAutomaticModuleName(Manifest manifest) {
            if (manifest == null) {
                return null;
            }
            return manifest.getMainAttributes().getValue(JavaModuleDetector.AUTOMATIC_MODULE_NAME_ATTRIBUTE);
        }
    }
}

