/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.history.user;

import java.util.Collections;
import java.util.Map;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.history.HistoryAuthenticationProvider;
import org.apache.guacamole.history.connection.HistoryConnection;
import org.apache.guacamole.history.connection.RecordedConnectionActivityRecordSet;
import org.apache.guacamole.net.auth.ActivityRecordSet;
import org.apache.guacamole.net.auth.Connection;
import org.apache.guacamole.net.auth.ConnectionGroup;
import org.apache.guacamole.net.auth.ConnectionRecord;
import org.apache.guacamole.net.auth.DecoratingDirectory;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.TokenInjectingUserContext;
import org.apache.guacamole.net.auth.User;
import org.apache.guacamole.net.auth.UserContext;

public class HistoryUserContext
extends TokenInjectingUserContext {
    private static final String HISTORY_PATH_TOKEN_NAME = "HISTORY_PATH";
    private final User currentUser;

    public HistoryUserContext(User currentUser, UserContext context) {
        super(context);
        this.currentUser = currentUser;
    }

    private Map<String, String> getTokens() throws GuacamoleException {
        return Collections.singletonMap(HISTORY_PATH_TOKEN_NAME, HistoryAuthenticationProvider.getRecordingSearchPath().getAbsolutePath());
    }

    protected Map<String, String> getTokens(ConnectionGroup connectionGroup) throws GuacamoleException {
        return this.getTokens();
    }

    protected Map<String, String> getTokens(Connection connection) throws GuacamoleException {
        return this.getTokens();
    }

    public Directory<Connection> getConnectionDirectory() throws GuacamoleException {
        return new DecoratingDirectory<Connection>(super.getConnectionDirectory()){

            protected Connection decorate(Connection object) {
                return new HistoryConnection(HistoryUserContext.this.currentUser, object);
            }

            protected Connection undecorate(Connection object) throws GuacamoleException {
                return ((HistoryConnection)object).getWrappedConnection();
            }
        };
    }

    public ActivityRecordSet<ConnectionRecord> getConnectionHistory() throws GuacamoleException {
        return new RecordedConnectionActivityRecordSet(this.currentUser, (ActivityRecordSet<ConnectionRecord>)super.getConnectionHistory());
    }
}

