/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Vector;
import javax.print.DocFlavor;
import javax.print.MultiDocPrintService;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterName;
import javax.print.attribute.standard.PrinterURI;
import sun.print.BackgroundLookupListener;
import sun.print.BackgroundServiceLookup;
import sun.print.CUPSPrinter;
import sun.print.IPPPrintService;
import sun.print.UnixPrintService;
import sun.security.action.GetPropertyAction;

public class PrintServiceLookupProvider
extends PrintServiceLookup
implements BackgroundServiceLookup,
Runnable {
    private String defaultPrinter;
    private PrintService defaultPrintService;
    private PrintService[] printServices;
    private Vector lookupListeners = null;
    private static String debugPrefix;
    private static boolean pollServices;
    private static final int DEFAULT_MINREFRESH = 120;
    private static int minRefreshTime;
    static String osname;
    String[] lpNameComAix = new String[]{"/usr/bin/lsallq", "/usr/bin/lpstat -W -p|/usr/bin/expand|/usr/bin/cut -f1 -d' '", "/usr/bin/lpstat -W -d|/usr/bin/expand|/usr/bin/cut -f1 -d' '", "/usr/bin/lpstat -W -v"};
    private static final int aix_lsallq = 0;
    private static final int aix_lpstat_p = 1;
    private static final int aix_lpstat_d = 2;
    private static final int aix_lpstat_v = 3;
    private static int aix_defaultPrinterEnumeration;
    static final int UNINITIALIZED = -1;
    static final int BSD_LPD = 0;
    static final int BSD_LPD_NG = 1;
    static int cmdIndex;
    String[] lpcFirstCom = new String[]{"/usr/sbin/lpc status all | grep ':$' | sed -ne '1,1 s/://p'", "/usr/sbin/lpc status | grep -E '^[ 0-9a-zA-Z_-]*@' | awk -F'@' '{print $1}'"};
    String[] lpcAllCom = new String[]{"/usr/sbin/lpc status all | grep ':$' | sed -e 's/://'", "/usr/sbin/lpc status all | grep -E '^[ 0-9a-zA-Z_-]*@' | awk -F'@' '{print $1}' | sort"};
    String[] lpcNameCom = new String[]{"| grep : | sed -ne 's/://p'", "| grep -E '^[ 0-9a-zA-Z_-]*@' | awk -F'@' '{print $1}'"};

    static boolean isMac() {
        return osname.startsWith("Mac");
    }

    static boolean isSysV() {
        return osname.equals("SunOS");
    }

    static boolean isLinux() {
        return osname.equals("Linux");
    }

    static boolean isBSD() {
        return osname.equals("Linux") || osname.endsWith("BSD") || osname.contains("OS X");
    }

    static boolean isAIX() {
        return osname.equals("AIX");
    }

    static int getBSDCommandIndex() {
        String string = "/usr/sbin/lpc status all";
        String[] stringArray = PrintServiceLookupProvider.execCmd(string);
        if (stringArray == null || stringArray.length == 0) {
            return 1;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf(64) == -1) continue;
            return 1;
        }
        return 0;
    }

    public PrintServiceLookupProvider() {
        if (pollServices) {
            PrinterChangeListener printerChangeListener = new PrinterChangeListener();
            printerChangeListener.setDaemon(true);
            printerChangeListener.start();
            IPPPrintService.debug_println(debugPrefix + "polling turned on");
        }
    }

    @Override
    public synchronized PrintService[] getPrintServices() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        if (this.printServices == null || !pollServices) {
            this.refreshServices();
        }
        if (this.printServices == null) {
            return new PrintService[0];
        }
        return (PrintService[])this.printServices.clone();
    }

    private int addPrintServiceToList(ArrayList arrayList, PrintService printService) {
        int n = arrayList.indexOf(printService);
        if (CUPSPrinter.isCupsRunning() && n != -1) {
            PrinterURI printerURI = printService.getAttribute(PrinterURI.class);
            if (printerURI.getURI().getHost().equals("localhost")) {
                IPPPrintService.debug_println(debugPrefix + "duplicate PrintService, ignoring the new local printer: " + printService);
                return n;
            }
            PrintService printService2 = (PrintService)arrayList.get(n);
            printerURI = printService2.getAttribute(PrinterURI.class);
            if (printerURI.getURI().getHost().equals("localhost")) {
                IPPPrintService.debug_println(debugPrefix + "duplicate PrintService, removing existing local printer: " + printService2);
                arrayList.remove(printService2);
            } else {
                return n;
            }
        }
        arrayList.add(printService);
        return arrayList.size() - 1;
    }

    public synchronized void refreshServices() {
        int n;
        int n2;
        String[] stringArray = null;
        String[] stringArray2 = null;
        try {
            this.getDefaultPrintService();
        }
        catch (Throwable throwable) {
            IPPPrintService.debug_println(debugPrefix + "Exception getting default printer : " + throwable);
        }
        if (CUPSPrinter.isCupsRunning()) {
            try {
                stringArray2 = CUPSPrinter.getAllPrinters();
                IPPPrintService.debug_println("CUPS URIs = " + stringArray2);
                if (stringArray2 != null) {
                    for (int i = 0; i < stringArray2.length; ++i) {
                        IPPPrintService.debug_println("URI=" + stringArray2[i]);
                    }
                }
            }
            catch (Throwable throwable) {
                IPPPrintService.debug_println(debugPrefix + "Exception getting all CUPS printers : " + throwable);
            }
            if (stringArray2 != null && stringArray2.length > 0) {
                stringArray = new String[stringArray2.length];
                for (int i = 0; i < stringArray2.length; ++i) {
                    n2 = stringArray2[i].lastIndexOf("/");
                    stringArray[i] = stringArray2[i].substring(n2 + 1);
                }
            }
        } else {
            stringArray = PrintServiceLookupProvider.isMac() || PrintServiceLookupProvider.isSysV() ? this.getAllPrinterNamesSysV() : (PrintServiceLookupProvider.isAIX() ? this.getAllPrinterNamesAIX() : this.getAllPrinterNamesBSD());
        }
        if (stringArray == null) {
            if (this.defaultPrintService != null) {
                this.printServices = new PrintService[1];
                this.printServices[0] = this.defaultPrintService;
            } else {
                this.printServices = null;
            }
            return;
        }
        ArrayList<PrintService> arrayList = new ArrayList<PrintService>();
        n2 = -1;
        for (n = 0; n < stringArray.length; ++n) {
            int n3;
            if (stringArray[n] == null) continue;
            if (this.defaultPrintService != null && stringArray[n].equals(this.getPrinterDestName(this.defaultPrintService))) {
                n2 = this.addPrintServiceToList(arrayList, this.defaultPrintService);
                continue;
            }
            if (this.printServices == null) {
                IPPPrintService.debug_println(debugPrefix + "total# of printers = " + stringArray.length);
                if (CUPSPrinter.isCupsRunning()) {
                    try {
                        this.addPrintServiceToList(arrayList, new IPPPrintService(stringArray[n], stringArray2[n], true));
                    }
                    catch (Exception exception) {
                        IPPPrintService.debug_println(debugPrefix + " getAllPrinters Exception " + exception);
                    }
                    continue;
                }
                arrayList.add(new UnixPrintService(stringArray[n]));
                continue;
            }
            for (n3 = 0; n3 < this.printServices.length; ++n3) {
                if (this.printServices[n3] == null || !stringArray[n].equals(this.getPrinterDestName(this.printServices[n3]))) continue;
                arrayList.add(this.printServices[n3]);
                this.printServices[n3] = null;
                break;
            }
            if (n3 != this.printServices.length) continue;
            if (CUPSPrinter.isCupsRunning()) {
                try {
                    this.addPrintServiceToList(arrayList, new IPPPrintService(stringArray[n], stringArray2[n], true));
                }
                catch (Exception exception) {
                    IPPPrintService.debug_println(debugPrefix + " getAllPrinters Exception " + exception);
                }
                continue;
            }
            arrayList.add(new UnixPrintService(stringArray[n]));
        }
        if (this.printServices != null) {
            for (n = 0; n < this.printServices.length; ++n) {
                if (!(this.printServices[n] instanceof UnixPrintService) || this.printServices[n].equals(this.defaultPrintService)) continue;
                ((UnixPrintService)this.printServices[n]).invalidateService();
            }
        }
        if (n2 == -1 && this.defaultPrintService != null) {
            n2 = this.addPrintServiceToList(arrayList, this.defaultPrintService);
        }
        this.printServices = arrayList.toArray(new PrintService[0]);
        if (n2 > 0) {
            PrintService printService = this.printServices[0];
            this.printServices[0] = this.printServices[n2];
            this.printServices[n2] = printService;
        }
    }

    private boolean matchesAttributes(PrintService printService, PrintServiceAttributeSet printServiceAttributeSet) {
        Attribute[] attributeArray = printServiceAttributeSet.toArray();
        for (int i = 0; i < attributeArray.length; ++i) {
            Attribute attribute = printService.getAttribute(attributeArray[i].getCategory());
            if (attribute != null && attribute.equals(attributeArray[i])) continue;
            return false;
        }
        return true;
    }

    private boolean checkPrinterName(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '-' || c == '_' || c == '.' || c == '/') continue;
            return false;
        }
        return true;
    }

    private String getPrinterDestName(PrintService printService) {
        if (PrintServiceLookupProvider.isMac()) {
            return ((IPPPrintService)printService).getDest();
        }
        return printService.getName();
    }

    /*
     * WARNING - void declaration
     */
    private PrintService getServiceByName(PrinterName printerName) {
        void var3_10;
        String string = printerName.getValue();
        if (string == null || string.equals("") || !this.checkPrinterName(string)) {
            return null;
        }
        if (this.printServices != null) {
            for (PrintService printService : this.printServices) {
                PrinterName printerName2 = printService.getAttribute(PrinterName.class);
                if (!printerName2.getValue().equals(string)) continue;
                return printService;
            }
        }
        if (CUPSPrinter.isCupsRunning()) {
            try {
                return new IPPPrintService(string, new URL("http://" + CUPSPrinter.getServer() + ":" + CUPSPrinter.getPort() + "/" + string));
            }
            catch (Exception exception) {
                IPPPrintService.debug_println(debugPrefix + " getServiceByName Exception " + exception);
            }
        }
        Object var3_6 = null;
        if (PrintServiceLookupProvider.isMac() || PrintServiceLookupProvider.isSysV()) {
            PrintService printService = this.getNamedPrinterNameSysV(string);
        } else if (PrintServiceLookupProvider.isAIX()) {
            PrintService printService = this.getNamedPrinterNameAIX(string);
        } else {
            PrintService printService = this.getNamedPrinterNameBSD(string);
        }
        return var3_10;
    }

    private PrintService[] getPrintServices(PrintServiceAttributeSet printServiceAttributeSet) {
        int n;
        PrintService printService;
        if (printServiceAttributeSet == null || printServiceAttributeSet.isEmpty()) {
            return this.getPrintServices();
        }
        PrinterName printerName = (PrinterName)printServiceAttributeSet.get(PrinterName.class);
        if (printerName != null && (printService = this.getDefaultPrintService()) != null) {
            PrinterName printerName2 = printService.getAttribute(PrinterName.class);
            if (printerName2 != null && printerName.equals(printerName2)) {
                if (this.matchesAttributes(printService, printServiceAttributeSet)) {
                    PrintService[] printServiceArray = new PrintService[]{printService};
                    return printServiceArray;
                }
                return new PrintService[0];
            }
            PrintService printService2 = this.getServiceByName(printerName);
            if (printService2 != null && this.matchesAttributes(printService2, printServiceAttributeSet)) {
                PrintService[] printServiceArray = new PrintService[]{printService2};
                return printServiceArray;
            }
            return new PrintService[0];
        }
        Vector<PrintService> vector = new Vector<PrintService>();
        PrintService[] printServiceArray = this.getPrintServices();
        for (n = 0; n < printServiceArray.length; ++n) {
            if (!this.matchesAttributes(printServiceArray[n], printServiceAttributeSet)) continue;
            vector.add(printServiceArray[n]);
        }
        printServiceArray = new PrintService[vector.size()];
        for (n = 0; n < printServiceArray.length; ++n) {
            printServiceArray[n] = (PrintService)vector.elementAt(n);
        }
        return printServiceArray;
    }

    @Override
    public PrintService[] getPrintServices(DocFlavor docFlavor, AttributeSet attributeSet) {
        Object[] objectArray;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = null;
        HashPrintServiceAttributeSet hashPrintServiceAttributeSet = null;
        if (attributeSet != null && !attributeSet.isEmpty()) {
            hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
            hashPrintServiceAttributeSet = new HashPrintServiceAttributeSet();
            objectArray = attributeSet.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] instanceof PrintRequestAttribute) {
                    hashPrintRequestAttributeSet.add((Attribute)objectArray[i]);
                    continue;
                }
                if (!(objectArray[i] instanceof PrintServiceAttribute)) continue;
                hashPrintServiceAttributeSet.add((Attribute)objectArray[i]);
            }
        }
        if ((objectArray = this.getPrintServices(hashPrintServiceAttributeSet)).length == 0) {
            return objectArray;
        }
        if (CUPSPrinter.isCupsRunning()) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < objectArray.length; ++i) {
                try {
                    if (objectArray[i].getUnsupportedAttributes(docFlavor, hashPrintRequestAttributeSet) != null) continue;
                    arrayList.add(objectArray[i]);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            objectArray = new PrintService[arrayList.size()];
            return (PrintService[])arrayList.toArray(objectArray);
        }
        PrintService printService = objectArray[0];
        if ((docFlavor == null || printService.isDocFlavorSupported(docFlavor)) && printService.getUnsupportedAttributes(docFlavor, hashPrintRequestAttributeSet) == null) {
            return objectArray;
        }
        return new PrintService[0];
    }

    @Override
    public MultiDocPrintService[] getMultiDocPrintServices(DocFlavor[] docFlavorArray, AttributeSet attributeSet) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return new MultiDocPrintService[0];
    }

    @Override
    public synchronized PrintService getDefaultPrintService() {
        Object object;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        this.defaultPrintService = null;
        String string = null;
        IPPPrintService.debug_println("isRunning ? " + CUPSPrinter.isCupsRunning());
        if (CUPSPrinter.isCupsRunning()) {
            object = CUPSPrinter.getDefaultPrinter();
            if (object != null && ((String[])object).length >= 2) {
                this.defaultPrinter = object[0];
                string = object[1];
            }
        } else {
            this.defaultPrinter = PrintServiceLookupProvider.isMac() || PrintServiceLookupProvider.isSysV() ? PrintServiceLookupProvider.getDefaultPrinterNameSysV() : (PrintServiceLookupProvider.isAIX() ? this.getDefaultPrinterNameAIX() : this.getDefaultPrinterNameBSD());
        }
        if (this.defaultPrinter == null) {
            return null;
        }
        this.defaultPrintService = null;
        if (this.printServices != null) {
            for (int i = 0; i < this.printServices.length; ++i) {
                if (!this.defaultPrinter.equals(this.getPrinterDestName(this.printServices[i]))) continue;
                this.defaultPrintService = this.printServices[i];
                break;
            }
        }
        if (this.defaultPrintService == null) {
            if (CUPSPrinter.isCupsRunning()) {
                try {
                    object = string != null && !string.startsWith("file") ? new IPPPrintService(this.defaultPrinter, string, true) : new IPPPrintService(this.defaultPrinter, new URL("http://" + CUPSPrinter.getServer() + ":" + CUPSPrinter.getPort() + "/" + this.defaultPrinter));
                    this.defaultPrintService = object;
                }
                catch (Exception exception) {}
            } else {
                this.defaultPrintService = new UnixPrintService(this.defaultPrinter);
            }
        }
        return this.defaultPrintService;
    }

    @Override
    public synchronized void getServicesInbackground(BackgroundLookupListener backgroundLookupListener) {
        if (this.printServices != null) {
            backgroundLookupListener.notifyServices(this.printServices);
        } else if (this.lookupListeners == null) {
            this.lookupListeners = new Vector();
            this.lookupListeners.add(backgroundLookupListener);
            Thread thread = new Thread(this);
            thread.start();
        } else {
            this.lookupListeners.add(backgroundLookupListener);
        }
    }

    private PrintService[] copyOf(PrintService[] printServiceArray) {
        if (printServiceArray == null || printServiceArray.length == 0) {
            return printServiceArray;
        }
        PrintService[] printServiceArray2 = new PrintService[printServiceArray.length];
        System.arraycopy(printServiceArray, 0, printServiceArray2, 0, printServiceArray.length);
        return printServiceArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        PrintService[] printServiceArray = this.getPrintServices();
        PrintServiceLookupProvider printServiceLookupProvider = this;
        synchronized (printServiceLookupProvider) {
            for (int i = 0; i < this.lookupListeners.size(); ++i) {
                BackgroundLookupListener backgroundLookupListener = (BackgroundLookupListener)this.lookupListeners.elementAt(i);
                backgroundLookupListener.notifyServices(this.copyOf(printServiceArray));
            }
            this.lookupListeners = null;
        }
    }

    private String getDefaultPrinterNameBSD() {
        String[] stringArray;
        if (cmdIndex == -1) {
            cmdIndex = PrintServiceLookupProvider.getBSDCommandIndex();
        }
        if ((stringArray = PrintServiceLookupProvider.execCmd(this.lpcFirstCom[cmdIndex])) == null || stringArray.length == 0) {
            return null;
        }
        if (cmdIndex == 1 && stringArray[0].startsWith("missingprinter")) {
            return null;
        }
        return stringArray[0];
    }

    private PrintService getNamedPrinterNameBSD(String string) {
        String string2;
        String[] stringArray;
        if (cmdIndex == -1) {
            cmdIndex = PrintServiceLookupProvider.getBSDCommandIndex();
        }
        if ((stringArray = PrintServiceLookupProvider.execCmd(string2 = "/usr/sbin/lpc status " + string + this.lpcNameCom[cmdIndex])) == null || !stringArray[0].equals(string)) {
            return null;
        }
        return new UnixPrintService(string);
    }

    private String[] getAllPrinterNamesBSD() {
        String[] stringArray;
        if (cmdIndex == -1) {
            cmdIndex = PrintServiceLookupProvider.getBSDCommandIndex();
        }
        if ((stringArray = PrintServiceLookupProvider.execCmd(this.lpcAllCom[cmdIndex])) == null || stringArray.length == 0) {
            return null;
        }
        return stringArray;
    }

    static String getDefaultPrinterNameSysV() {
        String string = "lp";
        String string2 = "/usr/bin/lpstat -d";
        String[] stringArray = PrintServiceLookupProvider.execCmd(string2);
        if (stringArray == null || stringArray.length == 0) {
            return string;
        }
        int n = stringArray[0].indexOf(":");
        if (n == -1 || stringArray[0].length() <= n + 1) {
            return null;
        }
        String string3 = stringArray[0].substring(n + 1).trim();
        if (string3.length() == 0) {
            return null;
        }
        return string3;
    }

    private PrintService getNamedPrinterNameSysV(String string) {
        String string2 = "/usr/bin/lpstat -v " + string;
        String[] stringArray = PrintServiceLookupProvider.execCmd(string2);
        if (stringArray == null || stringArray[0].indexOf("unknown printer") > 0) {
            return null;
        }
        return new UnixPrintService(string);
    }

    private String[] getAllPrinterNamesSysV() {
        String string = "lp";
        String string2 = "/usr/bin/lpstat -v|/usr/bin/expand|/usr/bin/cut -f3 -d' ' |/usr/bin/cut -f1 -d':' | /usr/bin/sort";
        String[] stringArray = PrintServiceLookupProvider.execCmd(string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("_default") || stringArray[i].equals(string) || stringArray[i].equals("")) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String getDefaultPrinterNameAIX() {
        String[] stringArray = PrintServiceLookupProvider.execCmd(this.lpNameComAix[2]);
        if ((stringArray = UnixPrintService.filterPrinterNamesAIX(stringArray)) == null || stringArray.length != 1) {
            return null;
        }
        return stringArray[0];
    }

    private PrintService getNamedPrinterNameAIX(String string) {
        String[] stringArray = PrintServiceLookupProvider.execCmd(this.lpNameComAix[3] + string);
        if ((stringArray = UnixPrintService.filterPrinterNamesAIX(stringArray)) == null || stringArray.length != 1) {
            return null;
        }
        return new UnixPrintService(string);
    }

    private String[] getAllPrinterNamesAIX() {
        String[] stringArray = PrintServiceLookupProvider.execCmd(this.lpNameComAix[aix_defaultPrinterEnumeration]);
        stringArray = UnixPrintService.filterPrinterNamesAIX(stringArray);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static String[] execCmd(String string) {
        ArrayList arrayList = null;
        try {
            final String[] stringArray = new String[3];
            if (PrintServiceLookupProvider.isSysV() || PrintServiceLookupProvider.isAIX()) {
                stringArray[0] = "/usr/bin/sh";
                stringArray[1] = "-c";
                stringArray[2] = "env LC_ALL=C " + string;
            } else {
                stringArray[0] = "/bin/sh";
                stringArray[1] = "-c";
                stringArray[2] = "LC_ALL=C " + string;
            }
            arrayList = (ArrayList)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws IOException {
                    BufferedReader bufferedReader = null;
                    File file = Files.createTempFile("prn", "xc", new FileAttribute[0]).toFile();
                    stringArray[2] = stringArray[2] + ">" + file.getAbsolutePath();
                    Process process = Runtime.getRuntime().exec(stringArray);
                    try {
                        boolean bl = false;
                        while (!bl) {
                            try {
                                process.waitFor();
                                bl = true;
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (process.exitValue() == 0) {
                            String string;
                            FileReader fileReader = new FileReader(file);
                            bufferedReader = new BufferedReader(fileReader);
                            ArrayList<String> arrayList = new ArrayList<String>();
                            while ((string = bufferedReader.readLine()) != null) {
                                arrayList.add(string);
                            }
                            ArrayList<String> arrayList2 = arrayList;
                            return arrayList2;
                        }
                    }
                    finally {
                        file.delete();
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        process.getInputStream().close();
                        process.getErrorStream().close();
                        process.getOutputStream().close();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        if (arrayList == null) {
            return new String[0];
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static {
        String string;
        String string2;
        debugPrefix = "PrintServiceLookupProvider>> ";
        pollServices = true;
        minRefreshTime = 120;
        aix_defaultPrinterEnumeration = 0;
        String string3 = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.print.polling"));
        if (string3 != null) {
            if (string3.equalsIgnoreCase("true")) {
                pollServices = true;
            } else if (string3.equalsIgnoreCase("false")) {
                pollServices = false;
            }
        }
        if ((string2 = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.print.minRefreshTime"))) != null) {
            try {
                minRefreshTime = new Integer(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (minRefreshTime < 120) {
                minRefreshTime = 120;
            }
        }
        osname = AccessController.doPrivileged(new GetPropertyAction("os.name"));
        if (PrintServiceLookupProvider.isAIX() && (string = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.print.aix.lpstat"))) != null) {
            if (string.equalsIgnoreCase("lpstat")) {
                aix_defaultPrinterEnumeration = 1;
            } else if (string.equalsIgnoreCase("lsallq")) {
                aix_defaultPrinterEnumeration = 0;
            }
        }
        cmdIndex = -1;
    }

    private class PrinterChangeListener
    extends Thread {
        private PrinterChangeListener() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    PrintServiceLookupProvider.this.refreshServices();
                }
                catch (Exception exception) {
                    IPPPrintService.debug_println(debugPrefix + "Exception in refresh thread.");
                    break;
                }
                int n = PrintServiceLookupProvider.this.printServices != null && PrintServiceLookupProvider.this.printServices.length > minRefreshTime ? PrintServiceLookupProvider.this.printServices.length : minRefreshTime;
                try {
                    PrinterChangeListener.sleep(n * 1000);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
    }
}

