/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime;

import io.quarkus.runtime.ApplicationLifecycleManager;
import io.quarkus.runtime.Quarkus;
import io.quarkus.runtime.QuarkusApplication;
import io.quarkus.runtime.annotations.QuarkusMain;
import jakarta.enterprise.context.ApplicationScoped;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import org.jboss.logging.Logger;
import org.keycloak.common.Version;
import org.keycloak.common.profile.ProfileException;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.Messages;
import org.keycloak.quarkus.runtime.cli.ExecutionExceptionHandler;
import org.keycloak.quarkus.runtime.cli.Picocli;
import org.keycloak.quarkus.runtime.cli.PropertyException;
import org.keycloak.quarkus.runtime.cli.command.AbstractStartCommand;
import org.keycloak.quarkus.runtime.cli.command.Start;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;

@QuarkusMain(name="keycloak")
@ApplicationScoped
public class KeycloakMain
implements QuarkusApplication {
    public static void main(String[] args) {
        KeycloakMain.ensureForkJoinPoolThreadFactoryHasBeenSetToQuarkus();
        System.setProperty("kc.version", Version.VERSION);
        List<String> cliArgs = null;
        try {
            cliArgs = Picocli.parseArgs(args);
        }
        catch (PropertyException e) {
            KeycloakMain.handleUsageError(e.getMessage());
            return;
        }
        if (cliArgs.isEmpty()) {
            cliArgs = new ArrayList<String>(cliArgs);
            cliArgs.add("-h");
        } else if (KeycloakMain.isFastStart(cliArgs)) {
            if (!AbstractStartCommand.wasBuildEverRun()) {
                KeycloakMain.handleUsageError(Messages.optimizedUsedForFirstStartup());
                return;
            }
            if (Start.isDevProfileNotAllowed()) {
                KeycloakMain.handleUsageError(Messages.devProfileNotAllowedError("start"));
                return;
            }
            Environment.setParsedCommand(new Start());
            try {
                PropertyMappers.sanitizeDisabledMappers();
                Picocli.validateConfig(cliArgs, new Start());
            }
            catch (ProfileException | PropertyException e) {
                KeycloakMain.handleUsageError(e.getMessage(), e.getCause());
                return;
            }
            ExecutionExceptionHandler errorHandler = new ExecutionExceptionHandler();
            PrintWriter errStream = new PrintWriter(System.err, true);
            KeycloakMain.start(errorHandler, errStream, args);
            return;
        }
        new Picocli().parseAndRun(cliArgs);
    }

    private static void ensureForkJoinPoolThreadFactoryHasBeenSetToQuarkus() {
        String FORK_JOIN_POOL_COMMON_THREAD_FACTORY = "java.util.concurrent.ForkJoinPool.common.threadFactory";
        String sf = System.getProperty("java.util.concurrent.ForkJoinPool.common.threadFactory");
        if (!ForkJoinPool.commonPool().getFactory().getClass().getName().equals(sf)) {
            Logger.getLogger(KeycloakMain.class).errorf("The ForkJoinPool has been initialized with the wrong thread factory. The property '%s' should be set on the Java CLI to ensure Java's ForkJoinPool will always be initialized with '%s' even if there are Java agents which might initialize logging or other capabilities earlier than the main method.", (Object)"java.util.concurrent.ForkJoinPool.common.threadFactory", (Object)sf);
            throw new RuntimeException("The ForkJoinPool has been initialized with the wrong thread factory");
        }
    }

    private static void handleUsageError(String message) {
        KeycloakMain.handleUsageError(message, null);
    }

    private static void handleUsageError(String message, Throwable cause) {
        ExecutionExceptionHandler errorHandler = new ExecutionExceptionHandler();
        PrintWriter errStream = new PrintWriter(System.err, true);
        errorHandler.error(errStream, message, cause);
        System.exit(2);
    }

    private static boolean isFastStart(List<String> cliArgs) {
        return cliArgs.size() == 2 && cliArgs.get(0).equals("start") && cliArgs.stream().anyMatch("--optimized"::equals);
    }

    public static void start(ExecutionExceptionHandler errorHandler, PrintWriter errStream, String[] args) {
        try {
            Quarkus.run(KeycloakMain.class, (exitCode, cause) -> {
                if (cause != null) {
                    errorHandler.error(errStream, String.format("Failed to start server in (%s) mode", Environment.getKeycloakModeFromProfile(Environment.getProfileOrDefault("prod"))), cause.getCause());
                }
                if (Environment.isDistribution()) {
                    System.exit(exitCode);
                }
            }, (String[])args);
        }
        catch (Throwable cause2) {
            errorHandler.error(errStream, String.format("Unexpected error when starting the server in (%s) mode", Environment.getKeycloakModeFromProfile(Environment.getProfileOrDefault("prod"))), cause2.getCause());
            System.exit(1);
        }
    }

    public int run(String ... args) throws Exception {
        if (Environment.isDevProfile()) {
            Logger.getLogger(KeycloakMain.class).warnf("Running the server in development mode. DO NOT use this configuration in production.", new Object[0]);
        }
        int exitCode = ApplicationLifecycleManager.getExitCode();
        if (Environment.isTestLaunchMode() || Environment.isNonServerMode()) {
            Quarkus.asyncExit((int)exitCode);
        } else {
            Quarkus.waitForExit();
        }
        return exitCode;
    }
}

