/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration;

import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.common.utils.StringUtil;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;

public class KcEnvConfigSource
extends PropertiesConfigSource {
    public static final String NAME = "KcEnvVarConfigSource";

    public KcEnvConfigSource() {
        super(KcEnvConfigSource.buildProperties(), NAME, 500);
    }

    private static Map<String, String> buildProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        String kcPrefix = StringUtil.replaceNonAlphanumericByUnderscores((String)"kc.".toUpperCase());
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!key.startsWith(kcPrefix)) continue;
            PropertyMapper<?> mapper = PropertyMappers.getMapper(key);
            if (mapper != null) {
                String to = mapper.getTo();
                if (to != null) {
                    properties.put(to, value);
                }
                properties.put(mapper.getFrom(), value);
                continue;
            }
            String transformedKey = "kc." + key.substring(kcPrefix.length()).toLowerCase().replace("_", "-");
            properties.put(transformedKey, value);
        }
        return properties;
    }

    public String getName() {
        return NAME;
    }
}

