/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.organization.authentication.authenticators.browser;

import java.util.List;
import org.keycloak.Config;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.authenticators.browser.IdentityProviderAuthenticatorFactory;
import org.keycloak.common.Profile;
import org.keycloak.models.KeycloakSession;
import org.keycloak.organization.authentication.authenticators.browser.OrganizationAuthenticator;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;

public class OrganizationAuthenticatorFactory
extends IdentityProviderAuthenticatorFactory
implements EnvironmentDependentProviderFactory {
    public static final String ID = "organization";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getDisplayType() {
        return "Organization Identity-First Login";
    }

    @Override
    public String getHelpText() {
        return "If organizations are enabled, automatically redirects users to the corresponding identity provider.";
    }

    @Override
    public Authenticator create(KeycloakSession session) {
        return new OrganizationAuthenticator(session);
    }

    public boolean isSupported(Config.Scope config) {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ORGANIZATION);
    }

    @Override
    public List<ProviderConfigProperty> getConfigProperties() {
        return List.of();
    }
}

