/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collections;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.UserProfileMetadata;
import org.keycloak.representations.userprofile.config.UPConfig;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.userprofile.UserProfileUtil;

@Extension(name="x-smallrye-profile-admin", value="")
public class UserProfileResource {
    protected final KeycloakSession session;
    protected final AdminEventBuilder adminEvent;
    protected final RealmModel realm;
    private final AdminPermissionEvaluator auth;

    public UserProfileResource(KeycloakSession session, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.auth = auth;
        this.adminEvent = adminEvent.resource(ResourceType.USER_PROFILE);
    }

    @GET
    @Produces(value={"application/json"})
    @Tag(name="Users")
    @Operation(description="Get the configuration for the user profile")
    public UPConfig getConfiguration() {
        this.auth.requireAnyAdminRole();
        return ((UserProfileProvider)this.session.getProvider(UserProfileProvider.class)).getConfiguration();
    }

    @GET
    @Path(value="/metadata")
    @Produces(value={"application/json"})
    @Tag(name="Users")
    @Operation(description="Get the UserProfileMetadata from the configuration")
    public UserProfileMetadata getMetadata() {
        this.auth.requireAnyAdminRole();
        UserProfile profile = ((UserProfileProvider)this.session.getProvider(UserProfileProvider.class)).create(UserProfileContext.USER_API, Collections.emptyMap());
        return UserProfileUtil.createUserProfileMetadata((KeycloakSession)this.session, (UserProfile)profile);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Tag(name="Users")
    @Operation(description="Set the configuration for the user profile")
    @APIResponse(responseCode="200", content={@Content(schema=@Schema(implementation=UPConfig.class))})
    public Response update(UPConfig config) {
        this.auth.realm().requireManageRealm();
        UserProfileProvider t = (UserProfileProvider)this.session.getProvider(UserProfileProvider.class);
        try {
            t.setConfiguration(config);
        }
        catch (ComponentValidationException e) {
            throw ErrorResponse.error(e.getMessage(), Response.Status.BAD_REQUEST);
        }
        this.adminEvent.operation(OperationType.UPDATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(config).success();
        return Response.ok((Object)t.getConfiguration()).type("application/json").build();
    }
}

