/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.batch.internal;

import java.util.Collections;
import java.util.function.Supplier;
import org.hibernate.Internal;
import org.hibernate.engine.jdbc.batch.JdbcBatchLogging;
import org.hibernate.engine.jdbc.batch.internal.BatchImpl;
import org.hibernate.engine.jdbc.batch.spi.Batch;
import org.hibernate.engine.jdbc.batch.spi.BatchBuilder;
import org.hibernate.engine.jdbc.batch.spi.BatchKey;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementGroup;
import org.hibernate.engine.jdbc.mutation.internal.PreparedStatementGroupSingleTable;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.jdbc.Expectations;
import org.hibernate.metamodel.mapping.TableDetails;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.jdbc.JdbcInsertMutation;

public class BatchBuilderImpl
implements BatchBuilder {
    private final int globalBatchSize;

    public BatchBuilderImpl(int globalBatchSize) {
        if (JdbcBatchLogging.BATCH_LOGGER.isTraceEnabled()) {
            JdbcBatchLogging.BATCH_LOGGER.tracef("Using standard BatchBuilder (%s)", globalBatchSize);
        }
        this.globalBatchSize = globalBatchSize;
    }

    public int getJdbcBatchSize() {
        return this.globalBatchSize;
    }

    @Override
    public Batch buildBatch(BatchKey key, Integer explicitBatchSize, Supplier<PreparedStatementGroup> statementGroupSupplier, JdbcCoordinator jdbcCoordinator) {
        int batchSize;
        int n = batchSize = explicitBatchSize == null ? this.globalBatchSize : explicitBatchSize;
        assert (batchSize > 1);
        return new BatchImpl(key, statementGroupSupplier.get(), batchSize, jdbcCoordinator);
    }

    @Internal
    public BatchImpl buildBatch(BatchKey batchKey, Integer sizeOverride, final String table, SessionImplementor session, String sql) {
        JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
        int batchSize = sizeOverride == null ? this.globalBatchSize : sizeOverride;
        return new BatchImpl(batchKey, new PreparedStatementGroupSingleTable(new JdbcInsertMutation(new TableMapping(){

            @Override
            public String getTableName() {
                return table;
            }

            @Override
            public int getRelativePosition() {
                return 0;
            }

            @Override
            public TableDetails.KeyDetails getKeyDetails() {
                return null;
            }

            @Override
            public boolean isOptional() {
                return false;
            }

            @Override
            public boolean isInverse() {
                return false;
            }

            @Override
            public boolean isIdentifierTable() {
                return true;
            }

            @Override
            public TableMapping.MutationDetails getInsertDetails() {
                return null;
            }

            @Override
            public TableMapping.MutationDetails getUpdateDetails() {
                return null;
            }

            @Override
            public boolean isCascadeDeleteEnabled() {
                return false;
            }

            @Override
            public TableMapping.MutationDetails getDeleteDetails() {
                return null;
            }
        }, null, sql, false, Expectations.NONE, Collections.emptyList()), session), batchSize, jdbcCoordinator);
    }
}

