/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.hibernate.AssertionFailure;
import org.hibernate.Internal;
import org.hibernate.MappingException;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.TruthValue;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.loader.internal.AliasConstantsHelper;
import org.hibernate.mapping.CheckConstraint;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.sql.Template;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.type.BasicType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.JdbcTypeNameMapper;
import org.hibernate.type.descriptor.java.JavaTypeHelper;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class Column
implements Selectable,
Serializable,
Cloneable,
ColumnTypeInformation {
    private Long length;
    private Integer precision;
    private Integer scale;
    private Integer temporalPrecision;
    private Integer arrayLength;
    private Value value;
    private int typeIndex;
    private String name;
    private boolean nullable = true;
    private boolean unique;
    private String uniqueKeyName;
    private String sqlTypeName;
    private Integer sqlTypeCode;
    private Boolean sqlTypeLob;
    private boolean quoted;
    private boolean explicit;
    int uniqueInteger;
    private boolean identity;
    private String comment;
    private String defaultValue;
    private String generatedAs;
    private String assignmentExpression;
    private String customWrite;
    private String customRead;
    private Size columnSize;
    private String collation;
    private List<CheckConstraint> checkConstraints = new ArrayList<CheckConstraint>();

    public Column() {
    }

    public Column(String columnName) {
        this.setName(columnName);
    }

    public Long getLength() {
        return this.length;
    }

    public void setLength(Long length) {
        this.length = length;
    }

    public void setLength(Integer length) {
        this.length = length.longValue();
    }

    public Integer getArrayLength() {
        return this.arrayLength;
    }

    public void setArrayLength(Integer arrayLength) {
        this.arrayLength = arrayLength;
    }

    public Value getValue() {
        return this.value;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (Column.isQuoted(name)) {
            this.quoted = true;
            this.name = name.substring(1, name.length() - 1);
        } else {
            this.name = name;
        }
    }

    @Internal
    public Identifier getNameIdentifier(MetadataBuildingContext buildingContext) {
        return buildingContext.getMetadataCollector().getDatabase().toIdentifier(this.getQuotedName());
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public void setExplicit(boolean explicit) {
        this.explicit = explicit;
    }

    public boolean isIdentity() {
        return this.identity;
    }

    public void setIdentity(boolean identity) {
        this.identity = identity;
    }

    private static boolean isQuoted(String name) {
        return name != null && name.length() >= 2 && Column.isOpenQuote(name.charAt(0)) && Column.isCloseQuote(name.charAt(name.length() - 1));
    }

    private static boolean isOpenQuote(char ch) {
        return "`\"[".indexOf(ch) > -1;
    }

    private static boolean isCloseQuote(char ch) {
        return "`\"]".indexOf(ch) > -1;
    }

    public String getQuotedName() {
        return StringHelper.safeInterning((String)(this.quoted ? "`" + this.name + "`" : this.name));
    }

    public String getQuotedName(Dialect dialect) {
        return StringHelper.safeInterning((String)(this.quoted ? dialect.openQuote() + this.name + dialect.closeQuote() : this.name));
    }

    @Override
    public String getAlias(Dialect dialect) {
        boolean useRawName;
        int lastLetter = StringHelper.lastIndexOfLetter(this.name);
        String suffix = AliasConstantsHelper.get(this.uniqueInteger);
        String alias = this.name.toLowerCase(Locale.ROOT);
        if (lastLetter == -1) {
            alias = "column";
        } else if (alias.length() > lastLetter + 1) {
            alias = alias.substring(0, lastLetter + 1);
        }
        boolean bl = useRawName = this.name.length() + suffix.length() <= dialect.getMaxAliasLength() && !this.quoted && !this.name.equalsIgnoreCase(dialect.rowId(null));
        if (!useRawName) {
            if (suffix.length() >= dialect.getMaxAliasLength()) {
                throw new MappingException(String.format("Unique suffix [%s] length must be less than maximum [%d]", suffix, dialect.getMaxAliasLength()));
            }
            if (alias.length() + suffix.length() > dialect.getMaxAliasLength()) {
                alias = alias.substring(0, dialect.getMaxAliasLength() - suffix.length());
            }
        }
        return alias + suffix;
    }

    @Override
    public String getAlias(Dialect dialect, Table table) {
        return StringHelper.safeInterning(this.getAlias(dialect) + AliasConstantsHelper.get(table.getUniqueInteger()));
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public void setTypeIndex(int typeIndex) {
        this.typeIndex = typeIndex;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public int hashCode() {
        return this.isQuoted() ? this.name.hashCode() : this.name.toLowerCase(Locale.ROOT).hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof Column && this.equals((Column)object);
    }

    public boolean equals(Column column) {
        return column != null && (this == column || this.isQuoted() ? this.name.equals(column.name) : this.name.equalsIgnoreCase(column.name));
    }

    public int getSqlTypeCode(Mapping mapping) throws MappingException {
        if (this.sqlTypeCode == null) {
            int[] sqlTypeCodes;
            Type type = this.getValue().getType();
            try {
                sqlTypeCodes = type.getSqlTypeCodes(mapping);
            }
            catch (Exception cause) {
                throw new MappingException(String.format(Locale.ROOT, "Unable to resolve JDBC type code for column '%s' of table '%s'", this.getName(), this.getValue().getTable().getName()), cause);
            }
            int index = this.getTypeIndex();
            if (index >= sqlTypeCodes.length) {
                throw new MappingException(String.format(Locale.ROOT, "Unable to resolve JDBC type code for column '%s' of table '%s'", this.getName(), this.getValue().getTable().getName()));
            }
            this.sqlTypeCode = sqlTypeCodes[index];
        }
        return this.sqlTypeCode;
    }

    private String getSqlTypeName(DdlTypeRegistry ddlTypeRegistry, Dialect dialect, Mapping mapping) {
        if (this.sqlTypeName == null) {
            int typeCode = this.getSqlTypeCode(mapping);
            DdlType descriptor = ddlTypeRegistry.getDescriptor(typeCode);
            if (descriptor == null) {
                throw new MappingException(String.format(Locale.ROOT, "Unable to determine SQL type name for column '%s' of table '%s' because there is no type mapping for org.hibernate.type.SqlTypes code: %s (%s)", this.getName(), this.getValue().getTable().getName(), typeCode, JdbcTypeNameMapper.getTypeName(typeCode)));
            }
            try {
                Size size = this.getColumnSize(dialect, mapping);
                this.sqlTypeName = descriptor.getTypeName(size, Column.getUnderlyingType(mapping, this.getValue().getType(), this.typeIndex), ddlTypeRegistry);
                this.sqlTypeLob = descriptor.isLob(size);
            }
            catch (Exception cause) {
                throw new MappingException(String.format(Locale.ROOT, "Unable to determine SQL type name for column '%s' of table '%s': %s", this.getName(), this.getValue().getTable().getName(), cause.getMessage()), cause);
            }
        }
        return this.sqlTypeName;
    }

    private static Type getUnderlyingType(Mapping mapping, Type type, int typeIndex) {
        if (type.isComponentType()) {
            ComponentType componentType = (ComponentType)type;
            int cols = 0;
            for (Type subtype : componentType.getSubtypes()) {
                int columnSpan = subtype.getColumnSpan(mapping);
                if (cols + columnSpan > typeIndex) {
                    return Column.getUnderlyingType(mapping, subtype, typeIndex - cols);
                }
                cols += columnSpan;
            }
            throw new IndexOutOfBoundsException();
        }
        if (type.isEntityType()) {
            EntityType entityType = (EntityType)type;
            Type idType = entityType.getIdentifierOrUniqueKeyType(mapping);
            return Column.getUnderlyingType(mapping, idType, typeIndex);
        }
        return type;
    }

    public Integer getSqlTypeCode() {
        return this.sqlTypeCode;
    }

    public void setSqlTypeCode(Integer typeCode) {
        if (this.sqlTypeCode != null && !Objects.equals(this.sqlTypeCode, typeCode)) {
            throw new AssertionFailure("conflicting type codes");
        }
        this.sqlTypeCode = typeCode;
    }

    public String getSqlType(Metadata mapping) {
        Database database = mapping.getDatabase();
        return this.getSqlTypeName(database.getTypeConfiguration().getDdlTypeRegistry(), database.getDialect(), mapping);
    }

    @Deprecated(since="6.2")
    public String getSqlType(TypeConfiguration typeConfiguration, Dialect dialect, Mapping mapping) {
        return this.getSqlTypeName(typeConfiguration.getDdlTypeRegistry(), dialect, mapping);
    }

    @Override
    public String getTypeName() {
        return this.sqlTypeName;
    }

    @Override
    public TruthValue getNullable() {
        return this.nullable ? TruthValue.TRUE : TruthValue.FALSE;
    }

    @Override
    public int getTypeCode() {
        return this.sqlTypeCode == null ? 1111 : this.sqlTypeCode;
    }

    @Override
    public int getColumnSize() {
        if (this.length == null) {
            return this.precision == null ? 0 : this.precision;
        }
        return this.length.intValue();
    }

    @Override
    public int getDecimalDigits() {
        return this.scale == null ? 0 : this.scale;
    }

    public Size getColumnSize(Dialect dialect, Mapping mapping) {
        if (this.columnSize == null) {
            this.columnSize = this.calculateColumnSize(dialect, mapping);
        }
        return this.columnSize;
    }

    Size calculateColumnSize(Dialect dialect, Mapping mapping) {
        BasicType basicType;
        Type type = this.getValue().getType();
        Long lengthToUse = this.getLength();
        Integer precisionToUse = this.getPrecision();
        Integer scaleToUse = this.getScale();
        if (type instanceof EntityType) {
            type = this.getTypeForEntityValue(mapping, type, this.getTypeIndex());
        }
        if (type instanceof ComponentType) {
            type = this.getTypeForComponentValue(mapping, type, this.getTypeIndex());
        }
        if (type instanceof BasicType && JavaTypeHelper.isTemporal((basicType = (BasicType)type).getExpressibleJavaType())) {
            precisionToUse = this.getTemporalPrecision();
            lengthToUse = null;
            scaleToUse = null;
        }
        if (type == null) {
            throw new AssertionFailure("no typing information available to determine column size");
        }
        JdbcMapping jdbcMapping = (JdbcMapping)((Object)type);
        Size size = dialect.getSizeStrategy().resolveSize(jdbcMapping.getJdbcType(), jdbcMapping.getJdbcJavaType(), precisionToUse, scaleToUse, lengthToUse);
        size.setArrayLength(this.arrayLength);
        return size;
    }

    private Type getTypeForComponentValue(Mapping mapping, Type type, int typeIndex) {
        Type[] subtypes = ((ComponentType)type).getSubtypes();
        int typeStartIndex = 0;
        for (Type subtype : subtypes) {
            int columnSpan = subtype.getColumnSpan(mapping);
            if (typeStartIndex + columnSpan > typeIndex) {
                int subtypeIndex = typeIndex - typeStartIndex;
                if (subtype instanceof EntityType) {
                    return this.getTypeForEntityValue(mapping, subtype, subtypeIndex);
                }
                if (subtype instanceof ComponentType) {
                    return this.getTypeForComponentValue(mapping, subtype, subtypeIndex);
                }
                if (subtypeIndex != 0) break;
                return subtype;
            }
            typeStartIndex += columnSpan;
        }
        throw new MappingException(String.format(Locale.ROOT, "Unable to resolve Hibernate type for column '%s' of table '%s'", this.getName(), this.getValue().getTable().getName()));
    }

    private Type getTypeForEntityValue(Mapping mapping, Type type, int typeIndex) {
        int index = 0;
        if (type instanceof EntityType) {
            EntityType entityType = (EntityType)type;
            return this.getTypeForEntityValue(mapping, entityType.getIdentifierOrUniqueKeyType(mapping), typeIndex);
        }
        if (type instanceof ComponentType) {
            for (Type subtype : ((ComponentType)type).getSubtypes()) {
                Type result = this.getTypeForEntityValue(mapping, subtype, typeIndex - index);
                if (result != null) {
                    return result;
                }
                index += subtype.getColumnSpan(mapping);
            }
            return null;
        }
        if (typeIndex == 0) {
            return type;
        }
        return null;
    }

    public String getSqlType() {
        return this.sqlTypeName;
    }

    public void setSqlType(String typeName) {
        if (this.sqlTypeName != null && !Objects.equals(this.sqlTypeName, typeName)) {
            throw new AssertionFailure("conflicting type names");
        }
        this.sqlTypeName = typeName;
    }

    public boolean isSqlTypeLob() {
        return this.sqlTypeLob != null && this.sqlTypeLob != false;
    }

    public boolean isSqlTypeLob(Metadata mapping) {
        Database database = mapping.getDatabase();
        DdlTypeRegistry ddlTypeRegistry = database.getTypeConfiguration().getDdlTypeRegistry();
        Dialect dialect = database.getDialect();
        if (this.sqlTypeLob == null) {
            try {
                int typeCode = this.getSqlTypeCode(mapping);
                DdlType descriptor = ddlTypeRegistry.getDescriptor(typeCode);
                if (descriptor == null) {
                    this.sqlTypeLob = JdbcType.isLob(typeCode);
                } else {
                    Size size = this.getColumnSize(dialect, mapping);
                    this.sqlTypeLob = descriptor.isLob(size);
                }
            }
            catch (MappingException cause) {
                throw cause;
            }
            catch (Exception cause) {
                throw new MappingException(String.format(Locale.ROOT, "Unable to determine SQL type name for column '%s' of table '%s'", this.getName(), this.getValue().getTable().getName()), cause);
            }
        }
        return this.sqlTypeLob;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public String getUniqueKeyName() {
        return this.uniqueKeyName;
    }

    public void setUniqueKeyName(String keyName) {
        this.uniqueKeyName = keyName;
    }

    public boolean isQuoted() {
        return this.quoted;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getName() + ")";
    }

    public void addCheckConstraint(CheckConstraint checkConstraint) {
        if (!this.checkConstraints.contains(checkConstraint)) {
            this.checkConstraints.add(checkConstraint);
        }
    }

    public List<CheckConstraint> getCheckConstraints() {
        return Collections.unmodifiableList(this.checkConstraints);
    }

    @Deprecated(since="6.2")
    public String getCheckConstraint() {
        if (this.checkConstraints.isEmpty()) {
            return null;
        }
        if (this.checkConstraints.size() > 1) {
            throw new IllegalStateException("column has multiple check constraints");
        }
        return this.checkConstraints.get(0).getConstraint();
    }

    @Deprecated(since="6.2")
    public void setCheckConstraint(String constraint) {
        if (constraint != null) {
            if (!this.checkConstraints.isEmpty()) {
                throw new IllegalStateException("column already has a check constraint");
            }
            this.checkConstraints.add(new CheckConstraint(constraint));
        }
    }

    public boolean hasCheckConstraint() {
        return !this.checkConstraints.isEmpty();
    }

    @Deprecated(since="6.2")
    public String checkConstraint() {
        if (this.checkConstraints.isEmpty()) {
            return null;
        }
        if (this.checkConstraints.size() > 1) {
            throw new IllegalStateException("column has multiple check constraints");
        }
        return this.checkConstraints.get(0).constraintString();
    }

    @Override
    public String getTemplate(Dialect dialect, TypeConfiguration typeConfiguration, SqmFunctionRegistry registry) {
        return StringHelper.safeInterning((String)(this.hasCustomRead() ? Template.renderTransformerReadFragment(this.customRead, this.getQuotedName(dialect)) : "$PlaceHolder$." + this.getQuotedName(dialect)));
    }

    public boolean hasCustomRead() {
        return this.customRead != null;
    }

    public String getReadExpr(Dialect dialect) {
        return this.hasCustomRead() ? this.customRead : this.getQuotedName(dialect);
    }

    @Override
    public String getWriteExpr() {
        return this.customWrite != null && this.customWrite.length() > 0 ? this.customWrite : "?";
    }

    @Override
    public boolean isFormula() {
        return false;
    }

    @Override
    public String getText(Dialect dialect) {
        return this.assignmentExpression != null ? this.assignmentExpression : this.getQuotedName(dialect);
    }

    @Override
    public String getText() {
        return this.assignmentExpression != null ? this.assignmentExpression : this.getName();
    }

    @Override
    public String getCustomReadExpression() {
        return this.customRead;
    }

    @Override
    public String getCustomWriteExpression() {
        return this.customWrite;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    public Integer getScale() {
        return this.scale;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public Integer getTemporalPrecision() {
        return this.temporalPrecision;
    }

    public void setTemporalPrecision(Integer temporalPrecision) {
        this.temporalPrecision = temporalPrecision;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getCollation() {
        return this.collation;
    }

    public void setCollation(String collation) {
        this.collation = collation;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getGeneratedAs() {
        return this.generatedAs;
    }

    public void setGeneratedAs(String generatedAs) {
        this.generatedAs = generatedAs;
    }

    public String getAssignmentExpression() {
        return this.assignmentExpression;
    }

    public void setAssignmentExpression(String assignmentExpression) {
        this.assignmentExpression = assignmentExpression;
    }

    public String getCustomWrite() {
        return this.customWrite;
    }

    public void setCustomWrite(String customWrite) {
        this.customWrite = StringHelper.safeInterning(customWrite);
    }

    public String getCustomRead() {
        return this.customRead;
    }

    public void setResolvedCustomRead(String customRead) {
        assert (customRead == null || !StringHelper.isEmpty(customRead.trim()));
        this.customRead = StringHelper.safeInterning(customRead);
    }

    public void setCustomRead(String customRead) {
        this.customRead = StringHelper.safeInterning(StringHelper.nullIfEmpty(customRead));
    }

    public String getCanonicalName() {
        return this.quoted ? this.name : this.name.toLowerCase(Locale.ROOT);
    }

    public Column clone() {
        Column copy = new Column();
        copy.length = this.length;
        copy.precision = this.precision;
        copy.scale = this.scale;
        copy.arrayLength = this.arrayLength;
        copy.value = this.value;
        copy.typeIndex = this.typeIndex;
        copy.name = this.name;
        copy.quoted = this.quoted;
        copy.nullable = this.nullable;
        copy.unique = this.unique;
        copy.uniqueKeyName = this.uniqueKeyName;
        copy.sqlTypeName = this.sqlTypeName;
        copy.sqlTypeCode = this.sqlTypeCode;
        copy.uniqueInteger = this.uniqueInteger;
        copy.checkConstraints = this.checkConstraints;
        copy.comment = this.comment;
        copy.defaultValue = this.defaultValue;
        copy.generatedAs = this.generatedAs;
        copy.assignmentExpression = this.assignmentExpression;
        copy.customRead = this.customRead;
        copy.customWrite = this.customWrite;
        copy.columnSize = this.columnSize;
        return copy;
    }
}

