/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import jakarta.persistence.TupleElement;
import jakarta.persistence.criteria.CompoundSelection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.spi.AppliedGraph;
import org.hibernate.query.IllegalSelectQueryException;
import org.hibernate.query.KeyedPage;
import org.hibernate.query.KeyedResultList;
import org.hibernate.query.Order;
import org.hibernate.query.Page;
import org.hibernate.query.QueryLogging;
import org.hibernate.query.SelectionQuery;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.criteria.ValueHandlingMode;
import org.hibernate.query.hql.internal.NamedHqlQueryMementoImpl;
import org.hibernate.query.hql.internal.QuerySplitter;
import org.hibernate.query.named.NamedQueryMemento;
import org.hibernate.query.spi.AbstractSelectionQuery;
import org.hibernate.query.spi.HqlInterpretation;
import org.hibernate.query.spi.MutableQueryOptions;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.SelectQueryPlan;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.internal.AggregatedSelectQueryPlanImpl;
import org.hibernate.query.sqm.internal.ConcreteSqmSelectQueryPlan;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.KeyBasedPagination;
import org.hibernate.query.sqm.internal.KeyedResult;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.spi.NamedSqmQueryMemento;
import org.hibernate.query.sqm.tree.AbstractSqmNode;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.select.SqmQueryGroup;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectQuery;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.sql.results.internal.TupleMetadata;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;

abstract class AbstractSqmSelectionQuery<R>
extends AbstractSelectionQuery<R> {
    AbstractSqmSelectionQuery(SharedSessionContractImplementor session) {
        super(session);
    }

    protected int max(boolean hasLimit, SqmSelectStatement<?> sqmStatement, List<R> list) {
        return !hasLimit || this.getQueryOptions().getLimit().getMaxRows() == null ? this.getMaxRows(sqmStatement, list.size()) : this.getQueryOptions().getLimit().getMaxRows().intValue();
    }

    protected int first(boolean hasLimit, SqmSelectStatement<?> sqmStatement) {
        return !hasLimit || this.getQueryOptions().getLimit().getFirstRow() == null ? this.getIntegerLiteral(sqmStatement.getOffset(), 0) : this.getQueryOptions().getLimit().getFirstRow().intValue();
    }

    protected static boolean hasLimit(SqmSelectStatement<?> sqm, MutableQueryOptions queryOptions) {
        return queryOptions.hasLimit() || sqm.getFetch() != null || sqm.getOffset() != null;
    }

    protected boolean needsDistinct(boolean containsCollectionFetches, boolean hasLimit, SqmSelectStatement<?> sqmStatement) {
        return containsCollectionFetches && (hasLimit || sqmStatement.usesDistinct() || AbstractSqmSelectionQuery.hasAppliedGraph((MutableQueryOptions)this.getQueryOptions()));
    }

    protected static boolean hasAppliedGraph(MutableQueryOptions queryOptions) {
        AppliedGraph appliedGraph = queryOptions.getAppliedGraph();
        return appliedGraph != null && appliedGraph.getSemantic() != null;
    }

    protected void errorOrLogForPaginationWithCollectionFetch() {
        if (this.getSessionFactory().getSessionFactoryOptions().isFailOnPaginationOverCollectionFetchEnabled()) {
            throw new HibernateException("setFirstResult() or setMaxResults() specified with collection fetch join (in-memory pagination was about to be applied, but 'hibernate.query.fail_on_pagination_over_collection_fetch' is enabled)");
        }
        QueryLogging.QUERY_MESSAGE_LOGGER.firstOrMaxResultsSpecifiedWithCollectionFetch();
    }

    public abstract SqmStatement<R> getSqmStatement();

    protected abstract void setSqmStatement(SqmSelectStatement<R> var1);

    public abstract DomainParameterXref getDomainParameterXref();

    public abstract TupleMetadata getTupleMetadata();

    private SqmSelectStatement<R> getSqmSelectStatement() {
        SqmStatement<R> sqmStatement = this.getSqmStatement();
        if (sqmStatement instanceof SqmSelectStatement) {
            return (SqmSelectStatement)sqmStatement;
        }
        throw new IllegalSelectQueryException("Not a select query");
    }

    @Override
    public SelectionQuery<R> setOrder(List<Order<? super R>> orderList) {
        SqmSelectQuery<Object> sqm = this.getSqmSelectStatement();
        SqmSelectQuery<Object> select = sqm = ((SqmSelectStatement)sqm).copy(SqmCopyContext.noParamCopyContext());
        ((SqmSelectStatement)sqm).orderBy(orderList.stream().map(order -> SqmUtil.sortSpecification(select, order)).collect(Collectors.toList()));
        this.getQueryOptions().setQueryPlanCachingEnabled(false);
        this.setSqmStatement((SqmSelectStatement<R>)sqm);
        return this;
    }

    @Override
    public SelectionQuery<R> setOrder(Order<? super R> order) {
        SqmSelectQuery<Object> sqm = this.getSqmSelectStatement();
        sqm = ((SqmSelectStatement)sqm).copy(SqmCopyContext.noParamCopyContext());
        ((SqmSelectStatement)sqm).orderBy(new jakarta.persistence.criteria.Order[]{SqmUtil.sortSpecification(sqm, order)});
        this.getQueryOptions().setQueryPlanCachingEnabled(false);
        this.setSqmStatement((SqmSelectStatement<R>)sqm);
        return this;
    }

    @Override
    public SelectionQuery<R> setPage(Page page) {
        this.setMaxResults(page.getMaxResults());
        this.setFirstResult(page.getFirstResult());
        return this;
    }

    private SqmSelectStatement<KeyedResult<R>> paginateQuery(List<Order<? super R>> keyDefinition, List<Comparable<?>> keyValues) {
        SqmSelectQuery sqm = this.getSqmSelectStatement().copy(SqmCopyContext.noParamCopyContext());
        NodeBuilder builder = ((AbstractSqmNode)((Object)sqm)).nodeBuilder();
        builder.setCriteriaValueHandlingMode(ValueHandlingMode.INLINE);
        return KeyBasedPagination.paginate(keyDefinition, keyValues, sqm, builder);
    }

    @Override
    public KeyedResultList<R> getKeyedResultList(KeyedPage<R> keyedPage) {
        if (keyedPage == null) {
            throw new IllegalArgumentException("KeyedPage was null");
        }
        Page page = keyedPage.getPage();
        List<Comparable<?>> key = keyedPage.getKey();
        List<Order<? super R>> keyDefinition = keyedPage.getKeyDefinition();
        List<Order<? super R>> appliedKeyDefinition = keyedPage.getKeyInterpretation() == KeyedPage.KeyInterpretation.KEY_OF_FIRST_ON_NEXT_PAGE ? Order.reverse(keyDefinition) : keyDefinition;
        this.setMaxResults(page.getMaxResults() + 1);
        if (key == null) {
            this.setFirstResult(page.getFirstResult());
        }
        List results = this.buildConcreteQueryPlan(this.paginateQuery(appliedKeyDefinition, key), this.getQueryOptions()).performList(this);
        return new KeyedResultList(KeyedResult.collectResults(results, page.getSize(), keyedPage.getKeyInterpretation()), KeyedResult.collectKeys(results, page.getSize()), keyedPage, AbstractSqmSelectionQuery.nextPage(keyedPage, results), AbstractSqmSelectionQuery.previousPage(keyedPage, results));
    }

    private static <R> KeyedPage<R> nextPage(KeyedPage<R> keyedPage, List<KeyedResult<R>> results) {
        if (keyedPage.getKeyInterpretation() == KeyedPage.KeyInterpretation.KEY_OF_FIRST_ON_NEXT_PAGE) {
            return !results.isEmpty() ? keyedPage.nextPage(results.get(0).getKey()) : null;
        }
        int pageSize = keyedPage.getPage().getSize();
        return results.size() == pageSize + 1 ? keyedPage.nextPage(results.get(pageSize - 1).getKey()) : null;
    }

    private static <R> KeyedPage<R> previousPage(KeyedPage<R> keyedPage, List<KeyedResult<R>> results) {
        if (keyedPage.getKeyInterpretation() == KeyedPage.KeyInterpretation.KEY_OF_FIRST_ON_NEXT_PAGE) {
            int pageSize = keyedPage.getPage().getSize();
            return results.size() == pageSize + 1 ? keyedPage.previousPage(results.get(pageSize - 1).getKey()) : null;
        }
        return !results.isEmpty() ? keyedPage.previousPage(results.get(0).getKey()) : null;
    }

    public abstract Class<R> getExpectedResultType();

    protected SelectQueryPlan<R> buildSelectQueryPlan() {
        SqmSelectStatement statement = (SqmSelectStatement)this.getSqmStatement();
        SqmSelectStatement<R>[] concreteSqmStatements = QuerySplitter.split(statement);
        return concreteSqmStatements.length > 1 ? this.buildAggregatedQueryPlan(concreteSqmStatements) : this.buildConcreteQueryPlan(concreteSqmStatements[0]);
    }

    private SelectQueryPlan<R> buildAggregatedQueryPlan(SqmSelectStatement<R>[] concreteSqmStatements) {
        SelectQueryPlan[] aggregatedQueryPlans = new SelectQueryPlan[concreteSqmStatements.length];
        int length = concreteSqmStatements.length;
        for (int i = 0; i < length; ++i) {
            aggregatedQueryPlans[i] = this.buildConcreteQueryPlan(concreteSqmStatements[i]);
        }
        return new AggregatedSelectQueryPlanImpl(aggregatedQueryPlans);
    }

    protected SelectQueryPlan<R> buildConcreteQueryPlan(SqmSelectStatement<R> concreteSqmStatement) {
        return this.buildConcreteQueryPlan(concreteSqmStatement, this.getExpectedResultType(), this.getTupleMetadata(), this.getQueryOptions());
    }

    protected <T> ConcreteSqmSelectQueryPlan<T> buildConcreteQueryPlan(SqmSelectStatement<T> concreteSqmStatement, Class<T> expectedResultType, TupleMetadata tupleMetadata, QueryOptions queryOptions) {
        return new ConcreteSqmSelectQueryPlan<T>(concreteSqmStatement, this.getQueryString(), this.getDomainParameterXref(), expectedResultType, tupleMetadata, queryOptions);
    }

    private <T> SelectQueryPlan<T> buildConcreteQueryPlan(SqmSelectStatement<T> sqmStatement, QueryOptions options) {
        return this.buildConcreteQueryPlan(sqmStatement, null, null, options);
    }

    protected void applyOptions(NamedSqmQueryMemento memento) {
        this.applyOptions((NamedQueryMemento)memento);
        if (memento.getFirstResult() != null) {
            this.setFirstResult(memento.getFirstResult());
        }
        if (memento.getMaxResults() != null) {
            this.setMaxResults(memento.getMaxResults());
        }
        if (memento.getParameterTypes() != null) {
            BasicTypeRegistry basicTypeRegistry = this.getSessionFactory().getTypeConfiguration().getBasicTypeRegistry();
            for (Map.Entry<String, String> entry : memento.getParameterTypes().entrySet()) {
                BasicType type = basicTypeRegistry.getRegisteredType(entry.getValue());
                this.getParameterMetadata().getQueryParameter(entry.getKey()).applyAnticipatedType(type);
            }
        }
    }

    protected TupleMetadata buildTupleMetadata(SqmStatement<?> statement, Class<R> resultType) {
        if (statement instanceof SqmSelectStatement) {
            SqmSelectStatement select = (SqmSelectStatement)statement;
            SqmSelectClause selectClause = ((SqmQueryPart)select.getQueryPart()).getFirstQuerySpec().getSelectClause();
            List<SqmSelection<?>> selections = selectClause.getSelections();
            return AbstractSqmSelectionQuery.isTupleMetadataRequired(resultType, selections.get(0)) ? this.getTupleMetadata(selections) : null;
        }
        return null;
    }

    private static <R> boolean isTupleMetadataRequired(Class<R> resultType, SqmSelection<?> selection) {
        return SqmUtil.isHqlTuple(selection) || !AbstractSqmSelectionQuery.isInstantiableWithoutMetadata(resultType) && !SqmUtil.isSelectionAssignableToResultType(selection, resultType);
    }

    private static boolean isInstantiableWithoutMetadata(Class<?> resultType) {
        return resultType == null || resultType.isArray() || Object.class == resultType || List.class == resultType;
    }

    private TupleMetadata getTupleMetadata(List<SqmSelection<?>> selections) {
        if (this.getQueryOptions().getTupleTransformer() == null) {
            return new TupleMetadata(AbstractSqmSelectionQuery.buildTupleElementArray(selections), AbstractSqmSelectionQuery.buildTupleAliasArray(selections));
        }
        throw new IllegalArgumentException("Illegal combination of Tuple resultType and (non-JpaTupleBuilder) TupleTransformer: " + this.getQueryOptions().getTupleTransformer());
    }

    private static TupleElement<?>[] buildTupleElementArray(List<SqmSelection<?>> selections) {
        if (selections.size() == 1) {
            SqmSelectableNode<?> selectableNode = selections.get(0).getSelectableNode();
            if (selectableNode instanceof CompoundSelection) {
                List<JpaSelection<?>> selectionItems = selectableNode.getSelectionItems();
                TupleElement[] elements = new TupleElement[selectionItems.size()];
                for (int i = 0; i < selectionItems.size(); ++i) {
                    elements[i] = selectionItems.get(i);
                }
                return elements;
            }
            return new TupleElement[]{selectableNode};
        }
        TupleElement[] elements = new TupleElement[selections.size()];
        for (int i = 0; i < selections.size(); ++i) {
            elements[i] = selections.get(i).getSelectableNode();
        }
        return elements;
    }

    private static String[] buildTupleAliasArray(List<SqmSelection<?>> selections) {
        if (selections.size() == 1) {
            SqmSelectableNode<?> selectableNode = selections.get(0).getSelectableNode();
            if (selectableNode instanceof CompoundSelection) {
                List<JpaSelection<?>> selectionItems = selectableNode.getSelectionItems();
                String[] elements = new String[selectionItems.size()];
                for (int i = 0; i < selectionItems.size(); ++i) {
                    elements[i] = selectionItems.get(i).getAlias();
                }
                return elements;
            }
            return new String[]{selectableNode.getAlias()};
        }
        String[] elements = new String[selections.size()];
        for (int i = 0; i < selections.size(); ++i) {
            elements[i] = selections.get(i).getAlias();
        }
        return elements;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void validateCriteriaQuery(SqmQueryPart<?> queryPart) {
        if (queryPart instanceof SqmQuerySpec) {
            SqmQuerySpec sqmQuerySpec = (SqmQuerySpec)queryPart;
            List<SqmSelection<?>> selections = sqmQuerySpec.getSelectClause().getSelections();
            if (!selections.isEmpty()) return;
            List<SqmRoot<?>> sqmRoots = sqmQuerySpec.getFromClause().getRoots();
            if (sqmRoots == null || sqmRoots.isEmpty()) {
                throw new IllegalArgumentException("Criteria did not define any query roots");
            }
            if (sqmRoots.size() != 1) throw new IllegalArgumentException("Criteria has multiple query roots");
            sqmQuerySpec.getSelectClause().add(sqmRoots.get(0), (String)null);
            return;
        } else {
            SqmQueryGroup queryGroup = (SqmQueryGroup)queryPart;
            for (SqmQueryPart part : queryGroup.getQueryParts()) {
                AbstractSqmSelectionQuery.validateCriteriaQuery(part);
            }
        }
    }

    protected static <T> HqlInterpretation<T> interpretation(NamedHqlQueryMementoImpl memento, Class<T> expectedResultType, SharedSessionContractImplementor session) {
        QueryEngine queryEngine = session.getFactory().getQueryEngine();
        QueryInterpretationCache interpretationCache = queryEngine.getInterpretationCache();
        HqlInterpretation<T> interpretation = interpretationCache.resolveHqlInterpretation(memento.getHqlString(), expectedResultType, queryEngine.getHqlTranslator());
        return interpretation;
    }
}

