/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.cli.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.keycloak.client.cli.util.Header;
import org.keycloak.client.cli.util.Headers;
import org.keycloak.client.cli.util.HeadersBody;
import org.keycloak.client.cli.util.HeadersBodyStatus;
import org.keycloak.client.cli.util.HttpDelete;
import org.keycloak.client.cli.util.HttpResponseException;
import org.keycloak.util.JsonSerialization;

public class HttpUtil {
    public static final String APPLICATION_XML = "application/xml";
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_FORM_URL_ENCODED = "application/x-www-form-urlencoded";
    public static final String UTF_8 = "utf-8";
    private static HttpClient httpClient;
    private static SSLConnectionSocketFactory sslsf;
    private static final AtomicBoolean tlsWarningEmitted;

    public static InputStream doGet(String url, String acceptType, String authorization) {
        try {
            HttpGet request = new HttpGet(url);
            request.setHeader("Accept", acceptType);
            return HttpUtil.doRequest(authorization, request);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to send request - " + e.getMessage(), e);
        }
    }

    public static InputStream doPost(String url, String contentType, String acceptType, String content, String authorization) {
        try {
            return HttpUtil.doPostOrPut(contentType, acceptType, content, authorization, new HttpPost(url));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to send request - " + e.getMessage(), e);
        }
    }

    public static InputStream doPut(String url, String contentType, String acceptType, String content, String authorization) {
        try {
            return HttpUtil.doPostOrPut(contentType, acceptType, content, authorization, new HttpPut(url));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to send request - " + e.getMessage(), e);
        }
    }

    public static void doDelete(String url, String authorization) {
        try {
            HttpDelete request = new HttpDelete(url);
            HttpUtil.doRequest(authorization, request);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to send request - " + e.getMessage(), e);
        }
    }

    public static HeadersBodyStatus doGet(String url, HeadersBody request) throws IOException {
        return HttpUtil.doRequest("get", url, request);
    }

    public static HeadersBodyStatus doPost(String url, HeadersBody request) throws IOException {
        return HttpUtil.doRequest("post", url, request);
    }

    public static HeadersBodyStatus doPut(String url, HeadersBody request) throws IOException {
        return HttpUtil.doRequest("put", url, request);
    }

    public static HeadersBodyStatus doDelete(String url, HeadersBody request) throws IOException {
        return HttpUtil.doRequest("delete", url, request);
    }

    public static HeadersBodyStatus doRequest(String type, String url, HeadersBody request) throws IOException {
        HttpRequestBase req = switch (type) {
            case "get" -> new HttpGet(url);
            case "post" -> new HttpPost(url);
            case "put" -> new HttpPut(url);
            case "delete" -> new HttpDelete(url);
            case "options" -> new HttpOptions(url);
            case "head" -> new HttpHead(url);
            default -> throw new RuntimeException("Method not supported: " + type);
        };
        HttpUtil.addHeaders(req, request.getHeaders());
        if (request.getBody() != null) {
            if (!(req instanceof HttpEntityEnclosingRequestBase)) {
                throw new RuntimeException("Request type does not support body: " + type);
            }
            ((HttpEntityEnclosingRequestBase)req).setEntity(new InputStreamEntity(request.getBody()));
        }
        HttpResponse res = HttpUtil.getHttpClient().execute(req);
        InputStream responseStream = null;
        responseStream = res.getEntity() != null ? res.getEntity().getContent() : new InputStream(){

            @Override
            public int read() throws IOException {
                return -1;
            }
        };
        Headers headers = new Headers();
        HeaderIterator it = res.headerIterator();
        while (it.hasNext()) {
            org.apache.http.Header header = it.nextHeader();
            headers.add(header.getName(), header.getValue());
        }
        return new HeadersBodyStatus(res.getStatusLine().toString(), headers, responseStream);
    }

    private static void addHeaders(HttpRequestBase request, Headers headers) {
        for (Header header : headers) {
            request.setHeader(header.getName(), header.getValue());
        }
    }

    private static InputStream doPostOrPut(String contentType, String acceptType, String content, String authorization, HttpEntityEnclosingRequestBase request) throws IOException {
        request.setHeader("Content-Type", contentType);
        request.setHeader("Accept", acceptType);
        if (content != null) {
            request.setEntity(new StringEntity(content));
        }
        return HttpUtil.doRequest(authorization, request);
    }

    private static InputStream doRequest(String authorization, HttpRequestBase request) throws IOException {
        int code;
        HttpUtil.addAuth(request, authorization);
        HttpResponse response = HttpUtil.getHttpClient().execute(request);
        InputStream responseStream = null;
        if (response.getEntity() != null) {
            responseStream = response.getEntity().getContent();
        }
        if ((code = response.getStatusLine().getStatusCode()) >= 200 && code < 300) {
            return responseStream;
        }
        Map error = null;
        try {
            org.apache.http.Header header = response.getEntity().getContentType();
            if (header != null && APPLICATION_JSON.equals(header.getValue())) {
                error = JsonSerialization.readValue(responseStream, Map.class);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read error response - " + e.getMessage(), e);
        }
        finally {
            responseStream.close();
        }
        String message = null;
        if (error != null) {
            message = (String)error.get("error_description") + " [" + (String)error.get("error") + "]";
        }
        throw new RuntimeException(message != null ? message : response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase());
    }

    private static void addAuth(HttpRequestBase request, String authorization) {
        if (authorization != null) {
            request.setHeader("Authorization", authorization);
        }
    }

    public static HttpClient getHttpClient() {
        if (httpClient == null) {
            httpClient = sslsf != null ? HttpClientBuilder.create().useSystemProperties().setSSLSocketFactory(sslsf).build() : HttpClientBuilder.create().useSystemProperties().build();
        }
        return httpClient;
    }

    public static String urlencode(String value) {
        try {
            return URLEncoder.encode(value, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Failed to urlencode", e);
        }
    }

    public static void setTruststore(File file, String password) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException {
        if (!file.isFile()) {
            throw new RuntimeException("Truststore file not found: " + file.getAbsolutePath());
        }
        SSLContext theContext = SSLContexts.custom().useProtocol("TLS").loadTrustMaterial(file, password == null ? null : password.toCharArray(), (TrustStrategy)TrustSelfSignedStrategy.INSTANCE).build();
        sslsf = new SSLConnectionSocketFactory(theContext);
    }

    public static void setSkipCertificateValidation() {
        if (!tlsWarningEmitted.getAndSet(true)) {
            System.err.println("The server is configured to use TLS but there is no truststore specified.");
            System.err.println("The tool will skip certificate validation. This is highly discouraged for production use cases");
        }
        SSLContextBuilder builder = new SSLContextBuilder();
        try {
            builder.loadTrustMaterial(null, new TrustSelfSignedStrategy());
            sslsf = new SSLConnectionSocketFactory(builder.build());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed setting up TLS", e);
        }
    }

    public static String extractIdFromLocation(String location) {
        int last = location.lastIndexOf("/");
        if (last != -1) {
            return location.substring(last + 1);
        }
        return null;
    }

    public static String addQueryParamsToUri(String uri, String ... queryParams) {
        if (queryParams == null) {
            return uri;
        }
        if (queryParams.length % 2 != 0) {
            throw new RuntimeException("Value missing for query parameter: " + queryParams[queryParams.length - 1]);
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        for (int i = 0; i < queryParams.length; i += 2) {
            params.put(queryParams[i], queryParams[i + 1]);
        }
        return HttpUtil.addQueryParamsToUri(uri, params);
    }

    public static String addQueryParamsToUri(String uri, Map<String, String> queryParams) {
        if (queryParams.size() == 0) {
            return uri;
        }
        StringBuilder query = new StringBuilder();
        for (Map.Entry<String, String> params : queryParams.entrySet()) {
            try {
                if (query.length() > 0) {
                    query.append("&");
                }
                query.append(params.getKey()).append("=").append(URLEncoder.encode(params.getValue(), UTF_8));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to encode query params: " + params.getKey() + "=" + params.getValue());
            }
        }
        return uri + (uri.indexOf("?") == -1 ? "?" : "&") + query;
    }

    public static String composeResourceUrl(String adminRoot, String realm, String uri) {
        if (!((String)uri).startsWith("http:") && !((String)uri).startsWith("https:")) {
            uri = "realms".equals(uri) || ((String)uri).startsWith("realms/") ? HttpUtil.normalize(adminRoot) + (String)uri : ("serverinfo".equals(uri) ? HttpUtil.normalize(adminRoot) + (String)uri : HttpUtil.normalize(adminRoot) + "realms/" + realm + "/" + (String)uri);
        }
        return uri;
    }

    public static String normalize(String value) {
        return value.endsWith("/") ? value : value + "/";
    }

    public static void checkSuccess(String url, HeadersBodyStatus response) {
        try {
            response.checkSuccess();
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                throw new RuntimeException("Resource not found for url: " + url, e);
            }
            throw e;
        }
    }

    public static <T> T doGetJSON(Class<T> type, String resourceUrl, String auth) {
        T result;
        HeadersBodyStatus response;
        Headers headers = new Headers();
        if (auth != null) {
            headers.add("Authorization", auth);
        }
        headers.add("Accept", APPLICATION_JSON);
        try {
            response = HttpUtil.doRequest("get", resourceUrl, new HeadersBody(headers));
        }
        catch (IOException e) {
            throw new RuntimeException("HTTP request failed: GET " + resourceUrl, e);
        }
        HttpUtil.checkSuccess(resourceUrl, response);
        try {
            result = JsonSerialization.readValue(response.getBody(), type);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read JSON response", e);
        }
        return result;
    }

    public static void doPostJSON(String resourceUrl, String auth, Object content) {
        HeadersBodyStatus response;
        byte[] body;
        Headers headers = new Headers();
        if (auth != null) {
            headers.add("Authorization", auth);
        }
        headers.add("Content-Type", APPLICATION_JSON);
        try {
            body = JsonSerialization.writeValueAsBytes(content);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize JSON", e);
        }
        try {
            response = HttpUtil.doRequest("post", resourceUrl, new HeadersBody(headers, new ByteArrayInputStream(body)));
        }
        catch (IOException e) {
            throw new RuntimeException("HTTP request failed: POST " + resourceUrl + "\n" + new String(body), e);
        }
        HttpUtil.checkSuccess(resourceUrl, response);
    }

    public static void doDeleteJSON(String resourceUrl, String auth, Object content) {
        HeadersBodyStatus response;
        byte[] body;
        Headers headers = new Headers();
        if (auth != null) {
            headers.add("Authorization", auth);
        }
        headers.add("Content-Type", APPLICATION_JSON);
        try {
            body = JsonSerialization.writeValueAsBytes(content);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize JSON", e);
        }
        try {
            response = HttpUtil.doRequest("delete", resourceUrl, new HeadersBody(headers, new ByteArrayInputStream(body)));
        }
        catch (IOException e) {
            throw new RuntimeException("HTTP request failed: DELETE " + resourceUrl + "\n" + new String(body), e);
        }
        HttpUtil.checkSuccess(resourceUrl, response);
    }

    public static String singularize(String value) {
        return value.substring(0, value.length() - 1);
    }

    static {
        tlsWarningEmitted = new AtomicBoolean();
    }
}

