/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.registration.cli;

import com.fasterxml.jackson.core.JsonParseException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.keycloak.client.cli.common.AttributeKey;
import org.keycloak.client.cli.common.AttributeOperation;
import org.keycloak.client.cli.util.AttributeException;
import org.keycloak.util.JsonSerialization;

public class ReflectionUtil {
    static Map<Class, Map<String, Field>> index = new HashMap<Class, Map<String, Field>>();

    static void populateAttributesIndex(Class type) {
        Field[] fields;
        HashMap<String, Field> map = new HashMap<String, Field>();
        for (Field f : fields = type.getDeclaredFields()) {
            f.setAccessible(true);
            map.put(f.getName(), f);
        }
        index.put(type, map);
    }

    public static Map<String, Field> getAttrFieldsForType(Type gtype) {
        Class type;
        if (gtype instanceof Class) {
            type = (Class)gtype;
        } else if (gtype instanceof ParameterizedType) {
            type = (Class)((ParameterizedType)gtype).getRawType();
        } else {
            throw new RuntimeException("Unexpected type: " + gtype);
        }
        if (ReflectionUtil.isListType(type) || ReflectionUtil.isMapType(type)) {
            return Collections.emptyMap();
        }
        Map<String, Field> map = index.get(type);
        if (map == null) {
            ReflectionUtil.populateAttributesIndex(type);
            map = index.get(type);
        }
        return map;
    }

    public static boolean isListType(Class type) {
        return List.class.isAssignableFrom(type) || type.isArray();
    }

    public static boolean isBasicType(Type type) {
        return type == String.class || type == Boolean.class || type == Boolean.TYPE || type == Integer.class || type == Integer.TYPE || type == Long.class || type == Long.TYPE || type == Float.class || type == Float.TYPE || type == Double.class || type == Double.TYPE;
    }

    public static boolean isMapType(Class type) {
        return Map.class.isAssignableFrom(type);
    }

    public static Object convertValueToType(Object value, Class<?> type) throws IOException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            if (type == String.class) {
                return value;
            }
            if (type == Boolean.class) {
                return Boolean.valueOf((String)value);
            }
            if (type == Integer.class) {
                return Integer.valueOf((String)value);
            }
            if (type == Long.class) {
                return Long.valueOf((String)value);
            }
            return JsonSerialization.readValue((String)value, type);
        }
        if (value instanceof Number) {
            if (type == Integer.class) {
                return ((Number)value).intValue();
            }
            if (type == Long.class) {
                return (long)((Long)value);
            }
            if (type == String.class) {
                return String.valueOf(value);
            }
        } else if (value instanceof Boolean) {
            if (type == Boolean.class) {
                return value;
            }
            if (type == String.class) {
                return String.valueOf(value);
            }
        }
        throw new RuntimeException("Unable to handle type [" + type + "]");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setAttributes(Object client, List<AttributeOperation> attrs) {
        for (AttributeOperation item : attrs) {
            AttributeKey attr = item.getKey();
            Object nested = client;
            List<AttributeKey.Component> cs = attr.getComponents();
            for (int i = 0; i < cs.size(); ++i) {
                Object value;
                AttributeKey.Component c = cs.get(i);
                Class<?> type = nested.getClass();
                Field field = null;
                if (!ReflectionUtil.isMapType(type)) {
                    Map<String, Field> fields = ReflectionUtil.getAttrFieldsForType(type);
                    if (fields == null) {
                        throw new AttributeException(attr.toString(), "Unexpected condition - unknown type: " + type);
                    }
                    field = fields.get(c.getName());
                    Class<?> parent = type;
                    while (field == null) {
                        if ((parent = parent.getSuperclass()) == Object.class) {
                            throw new AttributeException(attr.toString(), "Unknown attribute '" + c.getName() + "' on " + client.getClass());
                        }
                        fields = ReflectionUtil.getAttrFieldsForType(parent);
                        field = fields.get(c.getName());
                    }
                }
                Class<?> clazz = type = field == null ? type : field.getType();
                if (ReflectionUtil.isBasicType(type)) {
                    if (i < cs.size() - 1) {
                        throw new AttributeException(attr.toString(), "Attribute is of primitive type, and can't be nested further: " + c);
                    }
                    try {
                        Object val = ReflectionUtil.convertValueToType(item.getValue(), type);
                        field.set(nested, val);
                        continue;
                    }
                    catch (Exception e) {
                        throw new AttributeException(attr.toString(), "Failed to set attribute " + attr, e);
                    }
                }
                if (ReflectionUtil.isListType(type)) {
                    if (i < cs.size() - 1) {
                        try {
                            nested = field.get(nested);
                        }
                        catch (Exception e) {
                            throw new AttributeException(attr.toString(), "Failed to get attribute \"" + c + "\" in " + attr, e);
                        }
                        if (c.getIndex() < 0) continue;
                        List l = (List)nested;
                        if (c.getIndex() >= l.size()) {
                            throw new AttributeException(attr.toString(), "Array index out of bounds for \"" + c + "\" in " + attr);
                        }
                        nested = l.get(c.getIndex());
                        continue;
                    }
                    Class<Object> itype = type;
                    Type gtype = field.getGenericType();
                    if (gtype instanceof ParameterizedType) {
                        Type[] typeArgs = ((ParameterizedType)gtype).getActualTypeArguments();
                        itype = typeArgs.length >= 1 && typeArgs[0] instanceof Class ? (Class<Object>)typeArgs[0] : String.class;
                    }
                    if (c.getIndex() >= 0 || attr.isAppend()) {
                        Object value2;
                        List target;
                        try {
                            target = (List)field.get(nested);
                        }
                        catch (Exception e) {
                            throw new AttributeException(attr.toString(), "Failed to get list attribute: " + attr, e);
                        }
                        if (target == null) {
                            target = ReflectionUtil.createNewList(type);
                            try {
                                field.set(nested, target);
                            }
                            catch (Exception e) {
                                throw new AttributeException(attr.toString(), "Failed to set list attribute " + attr, e);
                            }
                        }
                        if (c.getIndex() >= target.size()) {
                            throw new AttributeException(attr.toString(), "Array index out of bounds for \"" + c + "\" in " + attr);
                        }
                        if (attr.isAppend()) {
                            try {
                                value2 = ReflectionUtil.convertValueToType(item.getValue(), itype);
                                if (c.getIndex() >= 0) {
                                    target.add(c.getIndex(), value2);
                                    continue;
                                }
                                target.add(value2);
                                continue;
                            }
                            catch (Exception e) {
                                throw new AttributeException(attr.toString(), "Failed to set list attribute " + attr, e);
                            }
                        }
                        if (item.getType() == AttributeOperation.Type.SET) {
                            try {
                                value2 = ReflectionUtil.convertValueToType(item.getValue(), itype);
                                target.set(c.getIndex(), value2);
                                continue;
                            }
                            catch (Exception e) {
                                throw new AttributeException(attr.toString(), "Failed to set list attribute " + attr, e);
                            }
                        }
                        try {
                            target.remove(c.getIndex());
                            continue;
                        }
                        catch (Exception e) {
                            throw new AttributeException(attr.toString(), "Failed to remove list attribute " + attr, e);
                        }
                    }
                    List value3 = ReflectionUtil.createNewList(type);
                    if (item.getType() == AttributeOperation.Type.SET) {
                        List converted = ReflectionUtil.convertValueToList(item.getValue(), itype);
                        value3.addAll(converted);
                    }
                    try {
                        field.set(nested, value3);
                        continue;
                    }
                    catch (Exception e) {
                        throw new AttributeException(attr.toString(), "Failed to set list attribute " + attr, e);
                    }
                }
                if (i < cs.size() - 1) {
                    if (field == null) {
                        if (!ReflectionUtil.isMapType(nested.getClass())) throw new RuntimeException("Unexpected condition while processing: " + attr);
                        value = ((Map)nested).get(c.getName());
                    } else {
                        try {
                            value = field.get(nested);
                        }
                        catch (Exception e) {
                            throw new AttributeException(attr.toString(), "Failed to get attribute \"" + c + "\" in " + attr, e);
                        }
                    }
                    if (value == null) {
                        if (ReflectionUtil.isMapType(nested.getClass())) {
                            throw new RuntimeException("Creating nested object trees not supported");
                        }
                        try {
                            value = ReflectionUtil.createNewObject(type);
                            field.set(nested, value);
                        }
                        catch (Exception e) {
                            throw new AttributeException(attr.toString(), "Failed to set attribute " + attr, e);
                        }
                    }
                    nested = value;
                    continue;
                }
                if (ReflectionUtil.isMapType(nested.getClass())) {
                    try {
                        ((Map)nested).put(c.getName(), item.getValue());
                        continue;
                    }
                    catch (Exception e) {
                        throw new AttributeException(attr.toString(), "Failed to set map key " + attr, e);
                    }
                }
                try {
                    value = ReflectionUtil.convertValueToType(item.getValue(), type);
                    field.set(nested, value);
                    continue;
                }
                catch (Exception e) {
                    throw new AttributeException(attr.toString(), "Failed to set attribute " + attr, e);
                }
            }
        }
    }

    private static Object createNewObject(Class type) throws Exception {
        return type.newInstance();
    }

    public static List createNewList(Class type) {
        if (type == List.class) {
            return new ArrayList();
        }
        if (type.isInterface()) {
            throw new RuntimeException("Can't instantiate a list type: " + type);
        }
        try {
            return (List)type.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate a list type: " + type, e);
        }
    }

    public static List convertValueToList(String value, Class itemType) {
        try {
            LinkedList<Object> result = new LinkedList<Object>();
            if (!value.startsWith("[")) {
                throw new RuntimeException("List attribute value has to start with '[' - '" + value + "'");
            }
            List parsed = JsonSerialization.readValue(value, List.class);
            for (Object item : parsed) {
                if (itemType.isAssignableFrom(item.getClass())) {
                    result.add(item);
                    continue;
                }
                result.add(ReflectionUtil.convertValueToType(item, itemType));
            }
            return result;
        }
        catch (JsonParseException e) {
            throw new RuntimeException("Failed to parse list value: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse list value: " + value, e);
        }
    }

    public static <T> void merge(T source, T dest) {
        Map<String, Field> fieldMap = ReflectionUtil.getAttrFieldsForType(source.getClass());
        try {
            for (String attrName : fieldMap.keySet()) {
                Field field = fieldMap.get(attrName);
                Object localValue = field.get(source);
                if (localValue == null) continue;
                field.set(dest, localValue);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to merge changes", e);
        }
    }

    public static LinkedHashMap<String, String> getAttributeListWithJSonTypes(Class type, AttributeKey attr) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        attr = attr != null ? attr : new AttributeKey();
        Map<String, Field> fields = ReflectionUtil.getAttrFieldsForType(type);
        for (AttributeKey.Component component : attr.getComponents()) {
            Field f = fields.get(component.getName());
            if (f == null) {
                throw new AttributeException(attr.toString(), "No such attribute: " + attr);
            }
            type = f.getType();
            if (ReflectionUtil.isBasicType(type) || ReflectionUtil.isListType(type) || ReflectionUtil.isMapType(type)) {
                return result;
            }
            fields = ReflectionUtil.getAttrFieldsForType(type);
        }
        for (Map.Entry entry : fields.entrySet()) {
            String key = (String)entry.getKey();
            Class<?> clazz = ((Field)entry.getValue()).getType();
            String t = ReflectionUtil.getTypeString(clazz, (Field)entry.getValue());
            result.put(key, t);
        }
        return result;
    }

    public static Field resolveField(Class type, AttributeKey attr) {
        Field f = null;
        Type gtype = type;
        for (AttributeKey.Component c : attr.getComponents()) {
            Map<String, Field> fields;
            Type[] typeargs;
            if (f != null && (gtype = f.getGenericType()) instanceof ParameterizedType && (typeargs = ((ParameterizedType)gtype).getActualTypeArguments()).length > 0) {
                gtype = typeargs[typeargs.length - 1];
            }
            if ((f = (fields = ReflectionUtil.getAttrFieldsForType(gtype)).get(c.getName())) != null) continue;
            throw new AttributeException(attr.toString(), "No such attribute: " + attr);
        }
        return f;
    }

    public static String getTypeString(Type type, Field field) {
        Class clazz = null;
        if (type == null) {
            if (field == null) {
                throw new IllegalArgumentException("type == null and field == null");
            }
            type = field.getGenericType();
        }
        if (type instanceof Class) {
            clazz = (Class)type;
        } else if (type instanceof ParameterizedType) {
            StringBuilder sb = new StringBuilder();
            String rtype = ReflectionUtil.getTypeString(((ParameterizedType)type).getRawType(), null);
            sb.append(rtype);
            sb.append(" ").append("(");
            Type[] typeArgs = ((ParameterizedType)type).getActualTypeArguments();
            for (int i = 0; i < typeArgs.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(ReflectionUtil.getTypeString(typeArgs[i], null));
            }
            sb.append(")");
            return sb.toString();
        }
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return "string";
        }
        if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz)) {
            return "int";
        }
        if (Long.class.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz)) {
            return "long";
        }
        if (Float.class.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz)) {
            return "float";
        }
        if (Double.class.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz)) {
            return "double";
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return "number";
        }
        if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz)) {
            return "boolean";
        }
        if (ReflectionUtil.isListType(clazz)) {
            if (field != null) {
                Type gtype = field.getGenericType();
                if (gtype == clazz && clazz.isArray()) {
                    return "array (" + ReflectionUtil.getTypeString(clazz.getComponentType(), null) + ")";
                }
                return ReflectionUtil.getTypeString(gtype, null);
            }
            return "array";
        }
        if (ReflectionUtil.isMapType(clazz)) {
            if (field != null) {
                Type gtype = field.getGenericType();
                return ReflectionUtil.getTypeString(gtype, null);
            }
            return "object";
        }
        return "object";
    }
}

