/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.util.ColorEntry;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;

public class ColorMap {
    static ColorEntry[] defaultMap = new ColorEntry[]{new ColorEntry("None", new Color(16762782)), new ColorEntry("White", Color.white), new ColorEntry("Light Gray", Color.lightGray), new ColorEntry("Gray", Color.gray), new ColorEntry("Dark Gray", Color.darkGray), new ColorEntry("Black", Color.black), new ColorEntry("Blue", Color.blue), new ColorEntry("Cyan", Color.cyan), new ColorEntry("Green", Color.green), new ColorEntry("Magenta", Color.magenta), new ColorEntry("Orange", Color.orange), new ColorEntry("Pink", Color.pink), new ColorEntry("Red", Color.red), new ColorEntry("Yellow", Color.yellow)};
    static ColorMap colorMap = null;
    Vector fMap = new Vector();

    ColorMap() {
        for (int i = 0; i < defaultMap.length; ++i) {
            this.addColor(defaultMap[i]);
        }
    }

    public static void reset() {
        colorMap = null;
    }

    public static ColorMap getColorMap() {
        if (colorMap == null) {
            colorMap = new ColorMap();
        }
        return colorMap;
    }

    public int size() {
        return this.fMap.size();
    }

    private void addColor(ColorEntry colorEntry) {
        this.fMap.addElement(colorEntry);
    }

    public void addColor(String string, Color color) {
        this.addColor(new ColorEntry(string, color));
    }

    public Color color(int n) {
        if (n < this.size() && n >= 0) {
            return ((ColorEntry)this.fMap.elementAt((int)n)).fColor;
        }
        throw new ArrayIndexOutOfBoundsException("Color index: " + n);
    }

    public Color color(String string) {
        Enumeration enumeration = this.fMap.elements();
        while (enumeration.hasMoreElements()) {
            ColorEntry colorEntry = (ColorEntry)enumeration.nextElement();
            if (!colorEntry.fName.equals(string)) continue;
            return colorEntry.fColor;
        }
        return Color.black;
    }

    public String name(int n) {
        if (n < this.size() && n >= 0) {
            return ((ColorEntry)this.fMap.elementAt((int)n)).fName;
        }
        throw new ArrayIndexOutOfBoundsException("Color index: " + n);
    }

    public int colorIndex(Color color) {
        Enumeration enumeration = this.fMap.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            ColorEntry colorEntry = (ColorEntry)enumeration.nextElement();
            if (colorEntry.fColor.equals(color)) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    public boolean isTransparent(Color color) {
        return color.equals(this.color("None"));
    }
}

