/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;

public final class ChecksumUtils {
    private ChecksumUtils() {
    }

    public static long checksum(InputStream is) throws IOException {
        int l;
        CRC32 crc = new CRC32();
        byte[] buffer = new byte[8192];
        while ((l = is.read(buffer)) > 0) {
            crc.update(buffer, 0, l);
        }
        return crc.getValue();
    }

    public static class CRCInputStream
    extends FilterInputStream {
        private final CRC32 crc = new CRC32();

        public CRCInputStream(InputStream in) {
            super(in);
        }

        public long getCRC() {
            return this.crc.getValue();
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            int nb = this.read(b, 0, 1);
            return nb == 1 ? b[0] : -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int nb = super.read(b, off, len);
            if (nb > 0) {
                this.crc.update(b, off, nb);
            }
            return nb;
        }
    }
}

