/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.events;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.NamedThreadFactory;
import org.openhab.core.common.ThreadPoolManager;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventFactory;
import org.openhab.core.events.EventFilter;
import org.openhab.core.events.EventSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class EventHandler
implements AutoCloseable {
    private static final int EVENT_QUEUE_WARN_LIMIT = 5000;
    private static final long EVENTSUBSCRIBER_EVENTHANDLING_MAX_MS = TimeUnit.SECONDS.toMillis(5L);
    private final Logger logger = LoggerFactory.getLogger(EventHandler.class);
    private final Map<String, Set<EventSubscriber>> typedEventSubscribers;
    private final Map<String, EventFactory> typedEventFactories;
    private final Map<Class<? extends EventSubscriber>, ExecutorRecord> executors = new HashMap<Class<? extends EventSubscriber>, ExecutorRecord>();
    private final ScheduledExecutorService watcher;

    public EventHandler(Map<String, Set<EventSubscriber>> typedEventSubscribers, Map<String, EventFactory> typedEventFactories) {
        this.typedEventSubscribers = typedEventSubscribers;
        this.typedEventFactories = typedEventFactories;
        this.watcher = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("eventwatcher"));
    }

    private synchronized ExecutorRecord createExecutorRecord(Class<? extends EventSubscriber> subscriber) {
        return new ExecutorRecord(ThreadPoolManager.getPoolBasedSequentialScheduledExecutorService("events", "eventexecutor-" + this.executors.size()), new AtomicInteger());
    }

    @Override
    public void close() {
        this.executors.values().forEach(r -> r.executor.shutdownNow());
        this.watcher.shutdownNow();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void handleEvent(org.osgi.service.event.Event osgiEvent) {
        Object typeObj = osgiEvent.getProperty("type");
        Object payloadObj = osgiEvent.getProperty("payload");
        Object topicObj = osgiEvent.getProperty("topic");
        Object sourceObj = osgiEvent.getProperty("source");
        Object object = typeObj;
        if (object instanceof String) {
            String string = (String)object;
            String cfr_ignored_0 = (String)object;
            Object object2 = payloadObj;
            if (object2 instanceof String) {
                String string2 = (String)object2;
                String cfr_ignored_1 = (String)object2;
                Object object3 = topicObj;
                if (object3 instanceof String) {
                    void topicStr;
                    void payloadStr;
                    void typeStr;
                    String string3;
                    String string4 = (String)object3;
                    String cfr_ignored_2 = (String)object3;
                    Object object4 = sourceObj;
                    if (object4 instanceof String) {
                        void s;
                        String string5 = (String)object4;
                        String cfr_ignored_3 = (String)object4;
                        string3 = s;
                    } else {
                        string3 = null;
                    }
                    String sourceStr = string3;
                    if (typeStr.isEmpty()) return;
                    if (payloadStr.isEmpty()) return;
                    if (topicStr.isEmpty()) return;
                    this.handleEvent((String)typeStr, (String)payloadStr, (String)topicStr, sourceStr);
                    return;
                }
            }
        }
        this.logger.error("The handled OSGi event is invalid. Expect properties as string named 'type', 'payload' and 'topic'. Received event properties are: {}", (Object)Arrays.toString(osgiEvent.getPropertyNames()));
    }

    private void handleEvent(String type, String payload, String topic, @Nullable String source) {
        EventFactory eventFactory = this.typedEventFactories.get(type);
        if (eventFactory == null) {
            this.logger.debug("Could not find an Event Factory for the event type '{}'.", (Object)type);
            return;
        }
        Set<EventSubscriber> eventSubscribers = this.getEventSubscribers(type);
        if (eventSubscribers.isEmpty()) {
            return;
        }
        Event event = this.createEvent(eventFactory, type, payload, topic, source);
        if (event == null) {
            return;
        }
        this.dispatchEvent(eventSubscribers, event);
    }

    private Set<EventSubscriber> getEventSubscribers(String eventType) {
        Set<EventSubscriber> eventTypeSubscribers = this.typedEventSubscribers.get(eventType);
        Set<EventSubscriber> allEventTypeSubscribers = this.typedEventSubscribers.get("ALL");
        HashSet<EventSubscriber> subscribers = new HashSet<EventSubscriber>();
        if (eventTypeSubscribers != null) {
            subscribers.addAll(eventTypeSubscribers);
        }
        if (allEventTypeSubscribers != null) {
            subscribers.addAll(allEventTypeSubscribers);
        }
        return subscribers;
    }

    private @Nullable Event createEvent(EventFactory eventFactory, String type, String payload, String topic, @Nullable String source) {
        try {
            return eventFactory.createEvent(type, topic, payload, source);
        }
        catch (Exception ex) {
            this.logger.warn("Creation of event failed, because one of the registered event factories has thrown an exception: {}", (Object)ex.getMessage(), (Object)ex);
            return null;
        }
    }

    private synchronized void dispatchEvent(Set<EventSubscriber> eventSubscribers, Event event) {
        for (EventSubscriber eventSubscriber : eventSubscribers) {
            EventFilter filter = eventSubscriber.getEventFilter();
            if (filter == null || filter.apply(event)) {
                this.logger.trace("Delegate event to subscriber ({}).", eventSubscriber.getClass());
                ExecutorRecord executorRecord = Objects.requireNonNull(this.executors.computeIfAbsent(eventSubscriber.getClass(), this::createExecutorRecord));
                int queueSize = executorRecord.count.incrementAndGet();
                if (queueSize > 5000) {
                    this.logger.warn("The queue for a subscriber of type '{}' exceeds {} elements. System may be unstable.", eventSubscriber.getClass(), (Object)5000);
                }
                CompletableFuture.runAsync(() -> {
                    ScheduledFuture<?> logTimeout = this.watcher.schedule(() -> this.logger.warn("Dispatching event to subscriber '{}' takes more than {}ms.", (Object)eventSubscriber, (Object)EVENTSUBSCRIBER_EVENTHANDLING_MAX_MS), EVENTSUBSCRIBER_EVENTHANDLING_MAX_MS, TimeUnit.MILLISECONDS);
                    try {
                        eventSubscriber.receive(event);
                    }
                    catch (Exception ex) {
                        this.logger.warn("Dispatching/filtering event for subscriber '{}' failed: {}", new Object[]{EventSubscriber.class.getName(), ex.getMessage(), ex});
                    }
                    logTimeout.cancel(false);
                }, executorRecord.executor).thenRun(executorRecord.count::decrementAndGet);
                continue;
            }
            this.logger.trace("Skip event subscriber ({}) because of its filter.", eventSubscriber.getClass());
        }
    }

    private record ExecutorRecord(ExecutorService executor, AtomicInteger count) {
    }
}

