"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStylesForCell = exports.RowHeightUtils = void 0;

var _predicate = require("../../services/predicate");

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; } /*
                                                                                                                                                                                                                   * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                   *
                                                                                                                                                                                                                   * The OpenSearch Contributors require contributions made to
                                                                                                                                                                                                                   * this file be licensed under the Apache-2.0 license or a
                                                                                                                                                                                                                   * compatible open source license.
                                                                                                                                                                                                                   *
                                                                                                                                                                                                                   * Modifications Copyright OpenSearch Contributors. See
                                                                                                                                                                                                                   * GitHub history for details.
                                                                                                                                                                                                                   */ /*
                                                                                                                                                                                                                       * Licensed to Elasticsearch B.V. under one or more contributor
                                                                                                                                                                                                                       * license agreements. See the NOTICE file distributed with
                                                                                                                                                                                                                       * this work for additional information regarding copyright
                                                                                                                                                                                                                       * ownership. Elasticsearch B.V. licenses this file to you under
                                                                                                                                                                                                                       * the Apache License, Version 2.0 (the "License"); you may
                                                                                                                                                                                                                       * not use this file except in compliance with the License.
                                                                                                                                                                                                                       * You may obtain a copy of the License at
                                                                                                                                                                                                                       *
                                                                                                                                                                                                                       *    http://www.apache.org/licenses/LICENSE-2.0
                                                                                                                                                                                                                       *
                                                                                                                                                                                                                       * Unless required by applicable law or agreed to in writing,
                                                                                                                                                                                                                       * software distributed under the License is distributed on an
                                                                                                                                                                                                                       * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
                                                                                                                                                                                                                       * KIND, either express or implied.  See the License for the
                                                                                                                                                                                                                       * specific language governing permissions and limitations
                                                                                                                                                                                                                       * under the License.
                                                                                                                                                                                                                       */

var cellPaddingsToClassMap = {
  s: 'ouiDataGridRowCell--paddingSmall',
  m: '',
  l: 'ouiDataGridRowCell--paddingLarge'
};
var fontSizesToClassMap = {
  s: 'ouiDataGridRowCell--fontSizeSmall',
  m: '',
  l: 'ouiDataGridRowCell--fontSizeLarge'
};

function getNumberFromPx(style) {
  return style ? parseInt(style.replace('px', ''), 10) : 0;
} // So that we use lineCount options we should know exactly row height which allow to show defined line count.
// For this we should know paddings and line height. Because of this we should compute styles for cell with grid styles


var RowHeightUtils = /*#__PURE__*/function () {
  function RowHeightUtils() {
    _classCallCheck(this, RowHeightUtils);

    _defineProperty(this, "styles", {});

    _defineProperty(this, "fakeCell", document.createElement('div'));
  }

  _createClass(RowHeightUtils, [{
    key: "computeStylesForGridCell",
    value: function computeStylesForGridCell(gridStyles) {
      this.fakeCell.className = "\n      ouiDataGridRowCell\n      ".concat(cellPaddingsToClassMap[gridStyles.cellPadding], "\n      ").concat(fontSizesToClassMap[gridStyles.fontSize], "\n    ");
      document.body.appendChild(this.fakeCell);
      var allStyles = getComputedStyle(this.fakeCell);
      this.styles = {
        paddingTop: allStyles.paddingTop,
        paddingBottom: allStyles.paddingBottom,
        lineHeight: allStyles.lineHeight
      };
      document.body.removeChild(this.fakeCell);
    }
  }, {
    key: "calculateHeightForLineCount",
    value: function calculateHeightForLineCount(lineCount) {
      var paddingTop = getNumberFromPx(this.styles.paddingTop);
      var paddingBottom = getNumberFromPx(this.styles.paddingBottom);
      var lineHeight = getNumberFromPx(this.styles.lineHeight);
      return Math.ceil(lineCount * lineHeight + paddingTop + paddingBottom);
    }
  }, {
    key: "getCalculatedHeight",
    value: function getCalculatedHeight(heightOption, defaultHeight) {
      if ((0, _predicate.isObject)(heightOption)) {
        if (heightOption.lineCount) {
          return this.calculateHeightForLineCount(heightOption.lineCount);
        }

        if (heightOption.height) {
          return Math.max(heightOption.height, defaultHeight);
        }
      }

      if (heightOption && (0, _predicate.isNumber)(heightOption)) {
        return Math.max(heightOption, defaultHeight);
      }

      return defaultHeight;
    }
  }]);

  return RowHeightUtils;
}();

exports.RowHeightUtils = RowHeightUtils;

var getStylesForCell = function getStylesForCell(rowHeightsOptions, rowIndex) {
  var initialHeight = rowHeightsOptions.rowHeights && rowHeightsOptions.rowHeights[rowIndex];

  if (!initialHeight) {
    initialHeight = rowHeightsOptions.defaultHeight;
  }

  if ((0, _predicate.isObject)(initialHeight) && initialHeight.lineCount) {
    return {
      WebkitLineClamp: initialHeight.lineCount,
      display: '-webkit-box',
      WebkitBoxOrient: 'vertical',
      height: '100%',
      overflow: 'hidden',
      flexGrow: 1,
      wordBreak: 'break-all'
    };
  }

  return {
    height: '100%',
    overflow: 'hidden',
    flexGrow: 1,
    wordBreak: 'break-all'
  };
};

exports.getStylesForCell = getStylesForCell;