"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchAgent = exports.getAgentIdByConfigName = void 0;
var _constants = require("../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 *
 */
const getAgentIdByConfigName = async (configName, client) => {
  try {
    var _response$body$ml_con, _response$body$config, _response$body$ml_con2;
    const path = `${_constants.ML_COMMONS_BASE_API}/config/${configName}`;
    const response = await client.request({
      method: 'GET',
      path
    });
    if (!response || !((_response$body$ml_con = response.body.ml_configuration) !== null && _response$body$ml_con !== void 0 && _response$body$ml_con.agent_id || (_response$body$config = response.body.configuration) !== null && _response$body$config !== void 0 && _response$body$config.agent_id)) {
      throw new Error(`cannot get agent ${configName} by calling the api: ${path}`);
    }
    return ((_response$body$ml_con2 = response.body.ml_configuration) === null || _response$body$ml_con2 === void 0 ? void 0 : _response$body$ml_con2.agent_id) || response.body.configuration.agent_id;
  } catch (error) {
    var _error$meta;
    const errorMessage = JSON.stringify((_error$meta = error.meta) === null || _error$meta === void 0 ? void 0 : _error$meta.body) || error;
    throw new Error(`get agent ${configName} failed, reason: ${errorMessage}`);
  }
};
exports.getAgentIdByConfigName = getAgentIdByConfigName;
const searchAgent = async ({
  name
}, client) => {
  try {
    const requestParams = {
      query: {
        term: {
          'name.keyword': name
        }
      },
      _source: ['_id'],
      sort: {
        created_time: 'desc'
      },
      size: 1
    };
    const response = await client.request({
      method: 'GET',
      path: `${_constants.ML_COMMONS_BASE_API}/agents/_search`,
      body: requestParams
    });
    if (!response || response.body.hits.total.value === 0) {
      return undefined;
    }
    return response.body.hits.hits[0]._id;
  } catch (error) {
    var _error$meta2;
    const errorMessage = JSON.stringify((_error$meta2 = error.meta) === null || _error$meta2 === void 0 ? void 0 : _error$meta2.body) || error;
    throw new Error(`search ${name} agent failed, reason: ` + errorMessage);
  }
};
exports.searchAgent = searchAgent;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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