/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.transform.poi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.ConditionalFormatting;
import org.apache.poi.ss.usermodel.ConditionalFormattingRule;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetConditionalFormatting;
import org.apache.poi.ss.util.CellRangeAddress;
import org.jxls.common.RowData;
import org.jxls.common.SheetData;
import org.jxls.transform.Transformer;
import org.jxls.transform.poi.PoiCellData;
import org.jxls.transform.poi.PoiConditionalFormatting;
import org.jxls.transform.poi.PoiRowData;
import org.jxls.transform.poi.PoiTransformer;

public class PoiSheetData
extends SheetData {
    private final List<CellRangeAddress> mergedRegions = new ArrayList<CellRangeAddress>();
    private Sheet sheet;
    private final List<PoiConditionalFormatting> poiConditionalFormattings = new ArrayList<PoiConditionalFormatting>();

    public static PoiSheetData createSheetData(Sheet sheet, PoiTransformer transformer) {
        int i;
        PoiSheetData sheetData = new PoiSheetData();
        sheetData.setTransformer((Transformer)transformer);
        sheetData.sheet = sheet;
        sheetData.sheetName = sheet.getSheetName();
        int numberOfRows = sheet.getLastRowNum() + 1;
        int numberOfColumns = -1;
        for (i = 0; i < numberOfRows; ++i) {
            RowData rowData = PoiRowData.createRowData(sheetData, sheet.getRow(i), transformer);
            sheetData.rowDataList.add(rowData);
            if (rowData == null || rowData.getNumberOfCells() <= numberOfColumns) continue;
            numberOfColumns = rowData.getNumberOfCells();
        }
        for (i = 0; i < sheet.getNumMergedRegions(); ++i) {
            CellRangeAddress region = sheet.getMergedRegion(i);
            sheetData.mergedRegions.add(region);
        }
        if (numberOfColumns > 0) {
            sheetData.columnWidth = new int[numberOfColumns];
            for (i = 0; i < numberOfColumns; ++i) {
                sheetData.columnWidth[i] = sheet.getColumnWidth(i);
            }
        }
        SheetConditionalFormatting sheetConditionalFormatting = sheet.getSheetConditionalFormatting();
        for (int i2 = 0; i2 < sheetConditionalFormatting.getNumConditionalFormattings(); ++i2) {
            ConditionalFormatting conditionalFormatting = sheetConditionalFormatting.getConditionalFormattingAt(i2);
            PoiConditionalFormatting poiConditionalFormatting = new PoiConditionalFormatting(conditionalFormatting);
            sheetData.poiConditionalFormattings.add(poiConditionalFormatting);
        }
        return sheetData;
    }

    public List<CellRangeAddress> getMergedRegions() {
        return this.mergedRegions;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public void updateConditionalFormatting(PoiCellData srcCellData, Cell targetCell) {
        for (PoiConditionalFormatting conditionalFormatting : this.poiConditionalFormattings) {
            List<CellRangeAddress> ranges = conditionalFormatting.getRanges();
            for (CellRangeAddress range : ranges) {
                if (!range.isInRange(srcCellData.getRow(), srcCellData.getCol())) continue;
                CellRangeAddress newRange = new CellRangeAddress(targetCell.getRowIndex(), targetCell.getRowIndex(), targetCell.getColumnIndex(), targetCell.getColumnIndex());
                Sheet targetSheet = targetCell.getSheet();
                SheetConditionalFormatting targetSheetConditionalFormatting = targetSheet.getSheetConditionalFormatting();
                List<ConditionalFormattingRule> sortedRules = conditionalFormatting.getRules();
                Collections.sort(sortedRules, new Comparator<ConditionalFormattingRule>(){

                    @Override
                    public int compare(ConditionalFormattingRule o1, ConditionalFormattingRule o2) {
                        return o1.getPriority() - o2.getPriority();
                    }
                });
                for (ConditionalFormattingRule rule : conditionalFormatting.getRules()) {
                    targetSheetConditionalFormatting.addConditionalFormatting(new CellRangeAddress[]{newRange}, rule);
                }
            }
        }
    }
}

