/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jmx.impl;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.graalvm.visualvm.core.VisualVM;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.ui.DataSourceWindowManager;
import org.graalvm.visualvm.jmx.JmxApplicationsSupport;
import org.graalvm.visualvm.jmx.impl.JmxApplication;
import org.graalvm.visualvm.jmx.impl.JmxConnectionSupportImpl;
import org.graalvm.visualvm.jmx.impl.JmxPropertiesProvider;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.Option;
import org.netbeans.spi.sendopts.OptionProcessor;

public final class OpenJmxApplication
extends OptionProcessor {
    private Option openjmx = Option.shortDescription((Option)this.openjmx, (String)"org.graalvm.visualvm.jmx.impl.Bundle", (String)"MSG_OPENJMX");

    protected Set<Option> getOptions() {
        return Collections.singleton(this.openjmx);
    }

    protected void process(Env env, Map<Option, String[]> optionValues) throws CommandException {
        String[] connectionStrings = optionValues.get(this.openjmx);
        if (connectionStrings != null && connectionStrings.length > 0) {
            this.openJmxApplication(connectionStrings[0]);
        }
    }

    private void openJmxApplication(final String connectionString) {
        VisualVM.getInstance().runTask(new Runnable(){

            @Override
            public void run() {
                JmxApplication application = (JmxApplication)JmxApplicationsSupport.getInstance().createJmxApplicationInteractive(connectionString, null, null, null);
                if (application != null) {
                    JmxPropertiesProvider.setCustomizer(application, JmxConnectionSupportImpl.getDefaultCustomizer());
                    DataSourceWindowManager.sharedInstance().openDataSource((DataSource)application);
                }
            }
        });
    }
}

