/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.proxy;

import java.util.logging.Level;
import java.util.logging.Logger;

public final class NetworkProxySettings {
    private static final Logger LOGGER = Logger.getLogger(NetworkProxySettings.class.getName());
    private static final String COLON = ":";
    private static final String SLASH = "/";
    private static final String EMPTY_STRING = "";
    private final boolean resolved;
    private final ProxyMode proxyMode;
    private final String httpProxyHost;
    private final String httpProxyPort;
    private final String httpsProxyHost;
    private final String httpsProxyPort;
    private final String socksProxyHost;
    private final String socksProxyPort;
    private final String pacFileUrl;
    private final String[] noProxyHosts;

    public NetworkProxySettings() {
        this.resolved = true;
        this.proxyMode = ProxyMode.DIRECT;
        this.pacFileUrl = null;
        this.httpProxyHost = null;
        this.httpProxyPort = null;
        this.httpsProxyHost = null;
        this.httpsProxyPort = null;
        this.socksProxyHost = null;
        this.socksProxyPort = null;
        this.noProxyHosts = new String[0];
    }

    public NetworkProxySettings(String string, String[] stringArray) {
        String string2 = this.getHost(string);
        String string3 = this.getPort(string);
        this.resolved = true;
        this.proxyMode = ProxyMode.MANUAL;
        this.pacFileUrl = null;
        this.httpProxyHost = string2;
        this.httpProxyPort = string3;
        this.httpsProxyHost = string2;
        this.httpsProxyPort = string3;
        this.socksProxyHost = string2;
        this.socksProxyPort = string3;
        this.noProxyHosts = this.checkArray(stringArray);
    }

    public NetworkProxySettings(String string, String string2, String string3, String[] stringArray) {
        this.resolved = true;
        this.proxyMode = ProxyMode.MANUAL;
        this.pacFileUrl = null;
        this.httpProxyHost = this.getHost(string);
        this.httpProxyPort = this.getPort(string);
        this.httpsProxyHost = this.getHost(string2);
        this.httpsProxyPort = this.getPort(string2);
        this.socksProxyHost = this.getHost(string3);
        this.socksProxyPort = this.getPort(string3);
        this.noProxyHosts = this.checkArray(stringArray);
    }

    public NetworkProxySettings(String string, String string2, String[] stringArray) {
        String string3 = this.checkNull(string);
        String string4 = this.checkNumber(string2);
        this.resolved = true;
        this.proxyMode = ProxyMode.MANUAL;
        this.pacFileUrl = null;
        this.httpProxyHost = string3;
        this.httpProxyPort = string4;
        this.httpsProxyHost = string3;
        this.httpsProxyPort = string4;
        this.socksProxyHost = string3;
        this.socksProxyPort = string4;
        this.noProxyHosts = this.checkArray(stringArray);
    }

    public NetworkProxySettings(String string, String string2, String string3, String string4, String string5, String string6, String[] stringArray) {
        this.resolved = true;
        this.proxyMode = ProxyMode.MANUAL;
        this.pacFileUrl = null;
        this.httpProxyHost = this.checkNull(string);
        this.httpProxyPort = this.checkNumber(string2);
        this.httpsProxyHost = this.checkNull(string3);
        this.httpsProxyPort = this.checkNumber(string4);
        this.socksProxyHost = this.checkNull(string5);
        this.socksProxyPort = this.checkNumber(string6);
        this.noProxyHosts = this.checkArray(stringArray);
    }

    public NetworkProxySettings(String string) {
        this.resolved = true;
        this.proxyMode = ProxyMode.AUTO;
        this.pacFileUrl = this.checkNull(string);
        this.httpProxyHost = null;
        this.httpProxyPort = null;
        this.httpsProxyHost = null;
        this.httpsProxyPort = null;
        this.socksProxyHost = null;
        this.socksProxyPort = null;
        this.noProxyHosts = new String[0];
    }

    public NetworkProxySettings(boolean bl) {
        this.resolved = bl;
        this.proxyMode = ProxyMode.DIRECT;
        this.pacFileUrl = null;
        this.httpProxyHost = null;
        this.httpProxyPort = null;
        this.httpsProxyHost = null;
        this.httpsProxyPort = null;
        this.socksProxyHost = null;
        this.socksProxyPort = null;
        this.noProxyHosts = new String[0];
    }

    private String getHost(String string) {
        if (string == null) {
            return EMPTY_STRING;
        }
        if (string.contains("://")) {
            string = string.substring(string.indexOf("://") + 3);
        }
        if (string.contains(COLON)) {
            return string.substring(0, string.lastIndexOf(COLON));
        }
        return string;
    }

    private String getPort(String string) {
        if (string == null) {
            return EMPTY_STRING;
        }
        if (string.endsWith(SLASH)) {
            string = string.substring(string.length() - 1);
        }
        if (string.contains(COLON)) {
            return string.substring(string.lastIndexOf(COLON) + 1);
        }
        return EMPTY_STRING;
    }

    private String checkNull(String string) {
        return string == null ? EMPTY_STRING : string;
    }

    private String checkNumber(String string) {
        if (string != null) {
            try {
                Integer.parseInt(string);
                return string;
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.log(Level.SEVERE, "Cannot parse number {0}", string);
            }
        }
        return EMPTY_STRING;
    }

    private String[] checkArray(String[] stringArray) {
        return stringArray == null ? new String[]{} : stringArray;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public ProxyMode getProxyMode() {
        return this.proxyMode;
    }

    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public String getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public String getHttpsProxyHost() {
        return this.httpsProxyHost;
    }

    public String getHttpsProxyPort() {
        return this.httpsProxyPort;
    }

    public String getSocksProxyHost() {
        return this.socksProxyHost;
    }

    public String getSocksProxyPort() {
        return this.socksProxyPort;
    }

    public String getPacFileUrl() {
        return this.pacFileUrl;
    }

    public String[] getNoProxyHosts() {
        return this.noProxyHosts;
    }

    public static enum ProxyMode {
        DIRECT,
        AUTO,
        MANUAL;

    }
}

