/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.BinaryNode;
import jalview.DrawableSequence;
import jalview.FileParse;
import jalview.FileProperties;
import jalview.Format;
import jalview.MailProperties;
import jalview.OutputGenerator;
import jalview.PostscriptProperties;
import jalview.Sequence;
import jalview.SequenceNode;
import jalview.TreeCanvas;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;

public class TreeFile
extends FileParse
implements OutputGenerator {
    Font f;
    int fontSize = 8;
    SequenceNode top;
    int line;
    int ch;
    float ycount;
    float maxheight;
    SequenceNode maxdist;
    boolean showDistances = true;
    MailProperties mp;
    FileProperties fp;
    PostscriptProperties pp;
    int offx = 20;
    int offy = 20;
    Object found;
    Vector selected;
    Vector groups = new Vector();
    BufferedWriter bw;
    PrintStream ps;
    boolean makeString = false;
    StringBuffer out;

    public TreeFile(SequenceNode sequenceNode, Vector vector) {
        this(sequenceNode);
        this.selected = vector;
    }

    public TreeFile(SequenceNode sequenceNode) {
        this.top = sequenceNode;
        this.propertiesInit();
    }

    public TreeFile(String string) {
        this.readLines(string);
        this.parse();
        this.propertiesInit();
    }

    public TreeFile(String string, String string2) throws IOException {
        super(string, string2);
        System.out.print("Reading file....");
        long l = System.currentTimeMillis();
        this.readLines();
        long l2 = System.currentTimeMillis();
        System.out.println("done");
        System.out.println("Total time taken = " + (l2 - l) + "ms");
        System.out.println("Parsing file....");
        this.parse();
        System.out.println("Parsing file....");
    }

    public void propertiesInit() {
        this.mp = new MailProperties();
        this.mp.server = "circinus.ebi.ac.uk";
        this.pp = new PostscriptProperties();
        this.fp = new FileProperties();
    }

    public void parse() {
        if (!((String)this.lineArray.elementAt(0)).equals("(")) {
            System.out.println("Invalid tree file: must start with (");
            this.top = null;
            return;
        }
        SequenceNode sequenceNode = this.top = new SequenceNode();
        this.createTree(sequenceNode, this.getChar());
        System.out.println("Done creating tree " + this.top);
    }

    public void setFontSize(int n) {
        this.fontSize = n;
        if (this.f != null) {
            this.f = new Font(this.f.getName(), this.f.getStyle(), n);
            return;
        }
        this.f = new Font("Helvetica", 0, n);
    }

    public void setFont(Font font) {
        this.f = font;
    }

    public String getChar() {
        if (this.ch >= ((String)this.lineArray.elementAt(this.line)).length()) {
            ++this.line;
            this.ch = 0;
        }
        String string = ((String)this.lineArray.elementAt(this.line)).substring(this.ch, this.ch + 1);
        ++this.ch;
        return string;
    }

    /*
     * Unable to fully structure code
     */
    public String createTree(BinaryNode var1_1, String var2_2) {
        block10: {
            var3_3 = "";
            var4_4 = "";
            if (!var2_2.equals("(")) ** GOTO lbl36
            System.out.println("New left node on " + var1_1);
            var5_5 = new SequenceNode();
            var5_5.parent = var1_1;
            var1_1.left = var5_5;
            var2_2 = this.createTree(var5_5, this.getChar());
            if (!var2_2.equals(",")) break block10;
            System.out.println("New right node on " + var1_1);
            var6_6 = new SequenceNode();
            var6_6.parent = var1_1;
            var1_1.right = var6_6;
            var2_2 = this.createTree(var6_6, this.getChar());
            if (var2_2.equals(",")) {
                System.out.println("Here " + var1_1.parent);
                System.out.println(String.valueOf(((SequenceNode)var1_1).dist) + " " + ((SequenceNode)var1_1.right).dist);
                System.out.println(var6_6.dist);
                this.top = var7_7 = new SequenceNode();
                var7_7.left = var1_1;
                var1_1.parent = var7_7;
                ((SequenceNode)var1_1).dist = 0.001f;
                var8_8 = new SequenceNode();
                var8_8.parent = var7_7;
                var7_7.right = var8_8;
                this.createTree(var8_8, this.getChar());
            }
            var7_7 = (SequenceNode)var1_1.left;
            var8_8 = (SequenceNode)var1_1.right;
            ((SequenceNode)var1_1).count = var7_7.count + var8_8.count;
            ((SequenceNode)var1_1).ycount = (var7_7.ycount + var8_8.ycount) / 2.0f;
            var2_2 = this.getChar();
            break block10;
lbl-1000:
            // 1 sources

            {
                var3_3 = String.valueOf(var3_3) + var2_2;
                var2_2 = this.getChar();
lbl36:
                // 2 sources

                ** while (!var2_2.equals((Object)":") && !var2_2.equals((Object)",") && !var2_2.equals((Object)")"))
            }
lbl37:
            // 1 sources

            var1_1.setElement(new Sequence(var3_3, "", 0, 0));
            ((SequenceNode)var1_1).count = 1;
            v0 = this.ycount;
            this.ycount = v0 + 1.0f;
            ((SequenceNode)var1_1).ycount = v0;
        }
        if (!var2_2.equals(";")) {
            while (!var2_2.equals(":")) {
                var2_2 = this.getChar();
            }
            var2_2 = this.getChar();
            while (!(var2_2.equals(":") || var2_2.equals(",") || var2_2.equals(")"))) {
                var4_4 = String.valueOf(var4_4) + var2_2;
                var2_2 = this.getChar();
            }
            if (var1_1 instanceof SequenceNode) {
                ((SequenceNode)var1_1).dist = Float.valueOf(var4_4).floatValue();
                System.out.println("Distance = " + ((SequenceNode)var1_1).dist);
                if (this.maxdist == null || Float.valueOf(var4_4).floatValue() > this.maxdist.dist) {
                    this.maxdist = (SequenceNode)var1_1;
                }
            }
        }
        return var2_2;
    }

    public float max(float f, float f2) {
        if (f > f2) {
            return f;
        }
        return f2;
    }

    public void printNode(SequenceNode sequenceNode) {
        if (sequenceNode == null) {
            return;
        }
        if (sequenceNode.left == null && sequenceNode.right == null) {
            System.out.println("Leaf = " + ((Sequence)sequenceNode.element()).name);
            System.out.println("Dist " + sequenceNode.dist);
            return;
        }
        System.out.println("Dist " + sequenceNode.dist);
        this.printNode((SequenceNode)sequenceNode.left);
        this.printNode((SequenceNode)sequenceNode.right);
    }

    public void groupNodes(SequenceNode sequenceNode, float f) {
        if (sequenceNode == null) {
            return;
        }
        if (sequenceNode.height / this.maxheight > f) {
            this.groups.addElement(sequenceNode);
            return;
        }
        this.groupNodes((SequenceNode)sequenceNode.left, f);
        this.groupNodes((SequenceNode)sequenceNode.right, f);
    }

    public Object findElement(Canvas canvas, int n, int n2) {
        int n3 = (int)((float)(n2 - this.offy + 5) / (float)(canvas.size().height - 2 * this.offy) * (float)this.top.count);
        if ((double)n > (double)canvas.size().width * 0.8) {
            this.found = null;
            Object object = this.findLeaf(this.top, n3);
            return object;
        }
        return null;
    }

    public Vector findLeaves(SequenceNode sequenceNode, Vector vector) {
        if (sequenceNode == null) {
            return vector;
        }
        if (sequenceNode.left == null && sequenceNode.right == null) {
            vector.addElement(sequenceNode);
            return vector;
        }
        this.findLeaves((SequenceNode)sequenceNode.left, vector);
        this.findLeaves((SequenceNode)sequenceNode.right, vector);
        return vector;
    }

    public Object findLeaf(SequenceNode sequenceNode, int n) {
        if (sequenceNode == null) {
            return this.found;
        }
        if (sequenceNode.ycount == (float)n) {
            this.found = sequenceNode.element;
            return this.found;
        }
        this.findLeaf((SequenceNode)sequenceNode.left, n);
        this.findLeaf((SequenceNode)sequenceNode.right, n);
        return this.found;
    }

    public void setColor(SequenceNode sequenceNode, Color color) {
        if (sequenceNode == null) {
            return;
        }
        if (sequenceNode.left == null && sequenceNode.right == null) {
            sequenceNode.color = color;
            if (sequenceNode instanceof SequenceNode) {
                ((DrawableSequence)sequenceNode.element).setColor(color);
                return;
            }
        } else {
            sequenceNode.color = color;
            this.setColor((SequenceNode)sequenceNode.left, color);
            this.setColor((SequenceNode)sequenceNode.right, color);
        }
    }

    public float findHeight(SequenceNode sequenceNode) {
        if (sequenceNode == null) {
            return this.maxheight;
        }
        if (sequenceNode.left == null && sequenceNode.right == null) {
            sequenceNode.height = ((SequenceNode)sequenceNode.parent).height + sequenceNode.dist;
            if (sequenceNode.height > this.maxheight) {
                return sequenceNode.height;
            }
            return this.maxheight;
        }
        if (sequenceNode.parent != null) {
            sequenceNode.height = ((SequenceNode)sequenceNode.parent).height + sequenceNode.dist;
        } else {
            this.maxheight = 0.0f;
            sequenceNode.height = 0.0f;
        }
        this.maxheight = this.findHeight((SequenceNode)sequenceNode.left);
        this.maxheight = this.findHeight((SequenceNode)sequenceNode.right);
        return this.maxheight;
    }

    public void draw(Graphics graphics, int n, int n2) {
        if (this.f != null) {
            graphics.setFont(this.f);
        } else {
            graphics.setFont(new Font("Helvetica", 0, this.fontSize));
        }
        float f = (float)((double)n * 0.8 - (double)(this.offx * 2)) / this.maxheight;
        if (this.top.count == 0) {
            this.top.count = ((SequenceNode)this.top.left).count + ((SequenceNode)this.top.right).count;
        }
        float f2 = (float)(n2 - this.offy * 2) / (float)this.top.count;
        this.drawNode(graphics, this.top, f2, f, n, this.offx, this.offy);
    }

    public void drawPostscript(PostscriptProperties postscriptProperties) {
        try {
            int n = 0;
            int n2 = 0;
            this.printout("%!\n");
            this.printout("/" + postscriptProperties.font + " findfont\n");
            this.printout(String.valueOf(postscriptProperties.fsize) + " scalefont setfont\n");
            int n3 = postscriptProperties.xoffset;
            int n4 = postscriptProperties.yoffset;
            if (postscriptProperties.orientation == PostscriptProperties.PORTRAIT) {
                n = PostscriptProperties.SHORTSIDE;
                n2 = PostscriptProperties.LONGSIDE;
            } else {
                n2 = PostscriptProperties.SHORTSIDE;
                n = PostscriptProperties.LONGSIDE;
                this.printout(String.valueOf(n2) + " 0 translate\n90 rotate\n");
            }
            float f = (float)((double)n * 0.8 - (double)(n3 * 2)) / this.maxheight;
            if (this.top.count == 0) {
                this.top.count = ((SequenceNode)this.top.left).count + ((SequenceNode)this.top.right).count;
            }
            float f2 = (float)(n2 - n4 * 2) / (float)(this.top.count + 1);
            this.drawPostscriptNode(this.top, f2, f, n, n3, n4);
            this.printout("showpage\n");
            return;
        }
        catch (IOException iOException) {
            System.out.println("Exception " + iOException);
            return;
        }
    }

    public void changeDirection(SequenceNode sequenceNode, SequenceNode sequenceNode2) {
        if (sequenceNode == null) {
            return;
        }
        if (sequenceNode.parent != this.top) {
            this.changeDirection((SequenceNode)sequenceNode.parent, sequenceNode);
            SequenceNode sequenceNode3 = (SequenceNode)sequenceNode.parent;
            if (sequenceNode2 == sequenceNode.left) {
                sequenceNode.parent = sequenceNode2;
                sequenceNode.left = sequenceNode3;
                return;
            }
            if (sequenceNode2 == sequenceNode.right) {
                sequenceNode.parent = sequenceNode2;
                sequenceNode.right = sequenceNode3;
                return;
            }
        } else {
            if (sequenceNode2 == sequenceNode.left) {
                sequenceNode.parent = sequenceNode.left;
                if (this.top.left == sequenceNode) {
                    sequenceNode.right = this.top.right;
                    return;
                }
                sequenceNode.right = this.top.left;
                return;
            }
            sequenceNode.parent = sequenceNode.right;
            if (this.top.left == sequenceNode) {
                sequenceNode.left = this.top.right;
                return;
            }
            sequenceNode.left = this.top.left;
        }
    }

    public SequenceNode reRoot() {
        if (this.maxdist != null) {
            this.ycount = 0.0f;
            float f = this.maxdist.dist;
            SequenceNode sequenceNode = new SequenceNode();
            sequenceNode.parent = null;
            SequenceNode sequenceNode2 = (SequenceNode)this.maxdist.parent;
            this.changeDirection(sequenceNode2, this.maxdist);
            System.out.println("Printing reversed tree");
            TreeFile.printN(sequenceNode2);
            sequenceNode2.dist = f / 2.0f;
            this.maxdist.dist = f / 2.0f;
            sequenceNode2.parent = sequenceNode;
            this.maxdist.parent = sequenceNode;
            sequenceNode.right = sequenceNode2;
            sequenceNode.left = this.maxdist;
            this.top = sequenceNode;
            this.ycount = 0.0f;
            this.reCount(this.top);
            this.findHeight(this.top);
        }
        return this.top;
    }

    public void drawPostscriptNode(SequenceNode sequenceNode, float f, float f2, int n, int n2, int n3) throws IOException {
        if (sequenceNode == null) {
            return;
        }
        if (sequenceNode.left == null && sequenceNode.right == null) {
            float f3 = sequenceNode.height;
            float f4 = sequenceNode.dist;
            int n4 = (int)((f3 - f4) * f2) + n2;
            int n5 = (int)(f3 * f2) + n2;
            int n6 = (int)(sequenceNode.ycount * f) + n3;
            this.printout("\n" + new Format("%5.3f").form((double)sequenceNode.color.getRed() / 255.0) + " " + new Format("%5.3f").form((double)sequenceNode.color.getGreen() / 255.0) + " " + new Format("%5.3f").form((double)sequenceNode.color.getBlue() / 255.0) + " setrgbcolor\n");
            this.printout(String.valueOf(n4) + " " + n6 + " moveto " + n5 + " " + n6 + " lineto stroke \n");
            if (this.showDistances && sequenceNode.dist > 0.0f) {
                this.printout("(" + new Format("%5.2f").form(sequenceNode.dist) + ") " + n4 + " " + (n6 + 5) + " moveto show\n");
            }
            this.printout("(" + ((Sequence)sequenceNode.element()).name + ") " + (n5 + 20) + " " + n6 + " moveto show\n");
            return;
        }
        this.drawPostscriptNode((SequenceNode)sequenceNode.left, f, f2, n, n2, n3);
        this.drawPostscriptNode((SequenceNode)sequenceNode.right, f, f2, n, n2, n3);
        float f5 = sequenceNode.height;
        float f6 = sequenceNode.dist;
        int n7 = (int)((f5 - f6) * f2) + n2;
        int n8 = (int)(f5 * f2) + n2;
        int n9 = (int)(sequenceNode.ycount * f) + n3;
        this.printout("\n" + new Format("%5.3f").form((double)sequenceNode.color.getRed() / 255.0) + " " + new Format("%5.3f").form((double)sequenceNode.color.getGreen() / 255.0) + " " + new Format("%5.3f").form((double)sequenceNode.color.getBlue() / 255.0) + " setrgbcolor\n");
        this.printout(String.valueOf(n7) + " " + n9 + " moveto " + n8 + " " + n9 + " lineto stroke\n");
        int n10 = (int)(((SequenceNode)sequenceNode.left).ycount * f) + n3;
        int n11 = (int)(((SequenceNode)sequenceNode.right).ycount * f) + n3;
        this.printout(String.valueOf((int)(f5 * f2) + n2) + " " + n10 + " moveto " + ((int)(f5 * f2) + n2) + " " + n11 + " lineto stroke\n");
        if (this.showDistances && sequenceNode.dist > 0.0f) {
            this.printout("(" + new Format("%5.2f").form(sequenceNode.dist) + ") " + n7 + " " + (n9 + 5) + " moveto show\n");
        }
    }

    public void printout(String string) throws IOException {
        if (this.bw != null) {
            this.bw.write(string);
        }
        if (this.ps != null) {
            this.ps.print(string);
        }
        if (this.makeString) {
            this.out.append(string);
        }
    }

    public void drawNode(Graphics graphics, SequenceNode sequenceNode, float f, float f2, int n, int n2, int n3) {
        if (sequenceNode == null) {
            return;
        }
        if (sequenceNode.left == null && sequenceNode.right == null) {
            float f3 = sequenceNode.height;
            float f4 = sequenceNode.dist;
            int n4 = (int)((f3 - f4) * f2) + n2;
            int n5 = (int)(f3 * f2) + n2;
            int n6 = (int)(sequenceNode.ycount * f) + n3;
            graphics.setColor(sequenceNode.color);
            graphics.drawLine(n4, n6, n5, n6);
            if (this.showDistances && sequenceNode.dist > 0.0f) {
                graphics.drawString(new Format("%5.2f").form(sequenceNode.dist), n4, n6 - 5);
            }
            if (this.selected != null && this.selected.contains((Sequence)sequenceNode.element())) {
                graphics.setColor(Color.gray);
                FontMetrics fontMetrics = graphics.getFontMetrics(this.f);
                int n7 = fontMetrics.stringWidth(((Sequence)sequenceNode.element()).name) + 3;
                int n8 = fontMetrics.getHeight();
                graphics.fillRect(n5 + 20, n6 - n8 + 3, n7, n8);
                graphics.setColor(Color.white);
            }
            graphics.drawString(((Sequence)sequenceNode.element()).name, n5 + 20, n6);
            graphics.setColor(Color.black);
            return;
        }
        this.drawNode(graphics, (SequenceNode)sequenceNode.left, f, f2, n, n2, n3);
        this.drawNode(graphics, (SequenceNode)sequenceNode.right, f, f2, n, n2, n3);
        float f5 = sequenceNode.height;
        float f6 = sequenceNode.dist;
        int n9 = (int)((f5 - f6) * f2) + n2;
        int n10 = (int)(f5 * f2) + n2;
        int n11 = (int)(sequenceNode.ycount * f) + n3;
        graphics.setColor(sequenceNode.color);
        graphics.drawLine(n9, n11, n10, n11);
        int n12 = (int)(((SequenceNode)sequenceNode.left).ycount * f) + n3;
        int n13 = (int)(((SequenceNode)sequenceNode.right).ycount * f) + n3;
        graphics.drawLine((int)(f5 * f2) + n2, n12, (int)(f5 * f2) + n2, n13);
        if (this.showDistances && sequenceNode.dist > 0.0f) {
            graphics.drawString(new Format("%5.2f").form(sequenceNode.dist), n9, n11 - 5);
        }
    }

    public static void printN(SequenceNode sequenceNode) {
        if (sequenceNode == null) {
            return;
        }
        if (sequenceNode.left != null && sequenceNode.right != null) {
            TreeFile.printN((SequenceNode)sequenceNode.left);
            TreeFile.printN((SequenceNode)sequenceNode.right);
        } else {
            System.out.println(" name = " + ((Sequence)sequenceNode.element()).name);
        }
        System.out.println(" dist = " + sequenceNode.dist + " " + sequenceNode.count + " " + sequenceNode.height);
    }

    public void reCount(SequenceNode sequenceNode) {
        if (sequenceNode == null) {
            return;
        }
        if (sequenceNode.left != null && sequenceNode.right != null) {
            this.reCount((SequenceNode)sequenceNode.left);
            this.reCount((SequenceNode)sequenceNode.right);
            SequenceNode sequenceNode2 = (SequenceNode)sequenceNode.left;
            SequenceNode sequenceNode3 = (SequenceNode)sequenceNode.right;
            sequenceNode.count = sequenceNode2.count + sequenceNode3.count;
            sequenceNode.ycount = (sequenceNode2.ycount + sequenceNode3.ycount) / 2.0f;
            return;
        }
        sequenceNode.count = 1;
        float f = this.ycount;
        this.ycount = f + 1.0f;
        sequenceNode.ycount = f;
    }

    public static void main(String[] stringArray) {
        try {
            TreeFile treeFile = new TreeFile(stringArray[0], "File");
            treeFile.top.height = 0.0f;
            treeFile.maxheight = -1.0f;
            treeFile.findHeight(treeFile.top);
            System.out.println("*************Done***********");
            Frame frame = new Frame();
            frame.setLayout(new BorderLayout());
            Panel panel = new Panel();
            panel.setLayout(new BorderLayout());
            TreeCanvas treeCanvas = new TreeCanvas(treeFile);
            panel.add("Center", treeCanvas);
            frame.resize(600, 600);
            frame.add("Center", panel);
            frame.show();
            return;
        }
        catch (IOException iOException) {
            System.out.println("Exception " + iOException);
            return;
        }
    }

    public MailProperties getMailProperties() {
        return this.mp;
    }

    public PostscriptProperties getPostscriptProperties() {
        return this.pp;
    }

    public FileProperties getFileProperties() {
        return this.fp;
    }

    public void setMailProperties(MailProperties mailProperties) {
        this.mp = mailProperties;
    }

    public void setPostscriptProperties(PostscriptProperties postscriptProperties) {
        this.pp = postscriptProperties;
    }

    public void setFileProperties(FileProperties fileProperties) {
        this.fp = fileProperties;
    }

    public String getText(String string) {
        return null;
    }

    public void getPostscript(BufferedWriter bufferedWriter) {
        this.bw = bufferedWriter;
        this.drawPostscript(this.pp);
    }

    public void getPostscript(PrintStream printStream) {
        this.ps = printStream;
        this.drawPostscript(this.pp);
        printStream.flush();
    }

    public StringBuffer getPostscript() {
        this.makeString = true;
        this.out = new StringBuffer();
        this.drawPostscript(this.pp);
        return this.out;
    }
}

