/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.PositionedCursor;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.ServerFetchBuffer;

final class ForwardOnlyDynamicServerCursor
extends PositionedCursor {
    private SQLServerStatement stmt;
    private ServerFetchBuffer fetchBuffer;

    ForwardOnlyDynamicServerCursor(SQLServerResultSet sQLServerResultSet) {
        super(new ServerFetchBuffer(sQLServerResultSet));
        this.fetchBuffer = (ServerFetchBuffer)((PositionedCursor)this).fetchBuffer;
        this.stmt = sQLServerResultSet.stmt;
    }

    int getRowCount() throws SQLServerException {
        SQLServerResultSet.throwNotScrollable(this.stmt);
        return -1;
    }

    final boolean isResultSetEmpty() throws SQLServerException {
        SQLServerResultSet.throwNotScrollable(this.stmt);
        return false;
    }

    final void beforeFirst() throws SQLServerException {
        SQLServerResultSet.throwNotScrollable(this.stmt);
    }

    final boolean isBeforeFirst() throws SQLServerException {
        SQLServerResultSet.throwNotScrollable(this.stmt);
        return false;
    }

    final boolean first() throws SQLServerException {
        SQLServerResultSet.throwNotScrollable(this.stmt);
        return false;
    }

    final boolean isFirst() throws SQLServerException {
        SQLServerResultSet.throwNotScrollable(this.stmt);
        return false;
    }

    final void afterLast() throws SQLServerException {
        SQLServerResultSet.throwNotScrollable(this.stmt);
    }

    final boolean isAfterLast() throws SQLServerException {
        SQLServerResultSet.throwNotScrollable(this.stmt);
        return false;
    }

    final boolean last() throws SQLServerException {
        SQLServerResultSet.throwNotScrollable(this.stmt);
        return false;
    }

    final boolean isLast() throws SQLServerException {
        SQLServerResultSet.throwNotScrollable(this.stmt);
        return false;
    }

    final boolean next() throws SQLServerException {
        if (!super.next()) {
            return false;
        }
        if (0 != this.stmt.maxRows && this.currentRow > this.stmt.maxRows) {
            this.currentRow = -2;
            return false;
        }
        return true;
    }

    final boolean previous() throws SQLServerException {
        SQLServerResultSet.throwNotScrollable(this.stmt);
        return false;
    }

    final boolean relative(int n) throws SQLServerException {
        SQLServerResultSet.throwNotScrollable(this.stmt);
        return false;
    }

    final boolean absolute(int n) throws SQLServerException {
        SQLServerResultSet.throwNotScrollable(this.stmt);
        return false;
    }

    final void refreshRow() throws SQLServerException {
        SQLServerResultSet.throwNotScrollable(this.stmt);
    }

    final boolean rowDeleted() throws SQLServerException {
        return this.fetchBuffer.rowDeleted();
    }

    final void insertRow() throws SQLServerException {
        this.fetchBuffer.insertRow();
    }

    final void updateRow() throws SQLServerException {
        this.fetchBuffer.updateRow();
    }

    final void deleteRow() throws SQLServerException {
        this.fetchBuffer.deleteRow();
    }
}

