/*
 * Decompiled with CFR 0.152.
 */
package org.fife.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class UnicodeWriter
extends Writer {
    private OutputStreamWriter internalOut;
    private static final byte[] UTF8_BOM = new byte[]{-17, -69, -65};
    private static final byte[] UTF16LE_BOM = new byte[]{-1, -2};
    private static final byte[] UTF16BE_BOM = new byte[]{-2, -1};

    public UnicodeWriter(String string, String string2) throws UnsupportedEncodingException, IOException {
        this(new FileOutputStream(string), string2);
    }

    public UnicodeWriter(File file, String string) throws UnsupportedEncodingException, IOException {
        this(new FileOutputStream(file), string);
    }

    public UnicodeWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException, IOException {
        this.init(outputStream, string);
    }

    public void close() throws IOException {
        this.internalOut.close();
    }

    public void flush() throws IOException {
        this.internalOut.flush();
    }

    public String getEncoding() {
        return this.internalOut.getEncoding();
    }

    private void init(OutputStream outputStream, String string) throws UnsupportedEncodingException, IOException {
        this.internalOut = new OutputStreamWriter(outputStream, string);
        if (string.equals("UTF-8")) {
            outputStream.write(UTF8_BOM, 0, UTF8_BOM.length);
        } else if (string.equals("UTF-16LE")) {
            outputStream.write(UTF16LE_BOM, 0, UTF16LE_BOM.length);
        } else if (string.equals("UTF-16") || string.equals("UTF-16BE")) {
            outputStream.write(UTF16BE_BOM, 0, UTF16BE_BOM.length);
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        this.internalOut.write(cArray, n, n2);
    }

    public void write(int n) throws IOException {
        this.internalOut.write(n);
    }

    public void write(String string, int n, int n2) throws IOException {
        this.internalOut.write(string, n, n2);
    }
}

