/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.DefaultToken;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenFactory;

class DefaultTokenFactory
implements TokenFactory {
    private int size;
    private int increment;
    private Token[] tokenList;
    private int currentFreeToken;
    protected static final int DEFAULT_START_SIZE = 30;
    protected static final int DEFAULT_INCREMENT = 10;

    public DefaultTokenFactory() {
        this(30, 10);
    }

    public DefaultTokenFactory(int n, int n2) {
        this.size = n;
        this.increment = n2;
        this.currentFreeToken = 0;
        this.tokenList = new Token[n];
        for (int i = 0; i < n; ++i) {
            this.tokenList[i] = this.createInternalUseOnlyToken();
        }
    }

    private final void augmentTokenList() {
        Token[] tokenArray = new Token[this.size + this.increment];
        System.arraycopy(this.tokenList, 0, tokenArray, 0, this.size);
        this.size += this.increment;
        this.tokenList = tokenArray;
        for (int i = 0; i < this.increment; ++i) {
            this.tokenList[this.size - i - 1] = this.createInternalUseOnlyToken();
        }
    }

    protected Token createInternalUseOnlyToken() {
        return new DefaultToken();
    }

    public Token createToken() {
        Token token = this.tokenList[this.currentFreeToken];
        token.text = null;
        token.type = 0;
        token.offset = -1;
        token.setNextToken(null);
        ++this.currentFreeToken;
        if (this.currentFreeToken == this.size) {
            this.augmentTokenList();
        }
        return token;
    }

    public Token createToken(Segment segment, int n, int n2, int n3, int n4) {
        return this.createToken(segment.array, n, n2, n3, n4);
    }

    public Token createToken(char[] cArray, int n, int n2, int n3, int n4) {
        Token token = this.tokenList[this.currentFreeToken];
        token.set(cArray, n, n2, n3, n4);
        ++this.currentFreeToken;
        if (this.currentFreeToken == this.size) {
            this.augmentTokenList();
        }
        return token;
    }

    public void resetAllTokens() {
        this.currentFreeToken = 0;
    }
}

