/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.object;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CleanupExceptions {
    private final List<Exception> exceptions = new ArrayList<Exception>();
    private final List<String> errorMessages = new ArrayList<String>();

    public void add(Exception e) {
        this.exceptions.add(e);
    }

    public void add(String message) {
        this.errorMessages.add(message);
    }

    public void add(CleanupExceptions ex) {
        this.exceptions.addAll(ex.getExceptions());
        this.errorMessages.addAll(ex.getErrorMessages());
    }

    public boolean isCleanupSuccessful() {
        return this.exceptions.isEmpty() && this.errorMessages.isEmpty();
    }

    public List<Exception> getExceptions() {
        return Collections.unmodifiableList(this.exceptions);
    }

    public List<String> getErrorMessages() {
        return Collections.unmodifiableList(this.errorMessages);
    }
}

