/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.query;

import ca.sqlpower.graph.DepthFirstSearch;
import ca.sqlpower.graph.GraphModel;
import ca.sqlpower.query.ConstantConverter;
import ca.sqlpower.query.Container;
import ca.sqlpower.query.ContainerChildEvent;
import ca.sqlpower.query.ContainerChildListener;
import ca.sqlpower.query.Item;
import ca.sqlpower.query.ItemContainer;
import ca.sqlpower.query.Query;
import ca.sqlpower.query.QueryChangeEvent;
import ca.sqlpower.query.QueryChangeListener;
import ca.sqlpower.query.SQLGroupFunction;
import ca.sqlpower.query.SQLJoin;
import ca.sqlpower.query.SQLObjectItem;
import ca.sqlpower.query.StringItem;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLDatabaseMapping;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.util.TransactionEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.concurrent.GuardedBy;
import org.apache.log4j.Logger;

public class QueryImpl
implements Query {
    private static final Logger logger = Logger.getLogger(QueryImpl.class);
    public static final String ROW_LIMIT = "rowLimit";
    public static final String PROPERTY_QUERY = "query";
    public static final String GROUPING_ENABLED = "groupingEnabled";
    public static final String GLOBAL_WHERE_CLAUSE = "globalWhereClause";
    private boolean groupingEnabled = false;
    private final List<Container> fromTableList;
    private final Map<Container, List<SQLJoin>> joinMapping;
    private String globalWhereClause;
    private int zoomLevel;
    private int compoundEditLevel = 0;
    @GuardedBy(value="changeListeners")
    private final List<QueryChangeListener> changeListeners = new ArrayList<QueryChangeListener>();
    private PropertyChangeListener itemListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            QueryImpl.this.fireItemPropertyChangeEvent(e);
        }
    };
    private PropertyChangeListener joinChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            SQLJoin join = (SQLJoin)e.getSource();
            if (e.getPropertyName().equals("leftColumnOuterJoin")) {
                QueryImpl.this.updateJoinsOnInnerOuterChange(join, (Boolean)e.getNewValue(), true);
            } else if (e.getPropertyName().equals("rightColumnOuterJoin")) {
                QueryImpl.this.updateJoinsOnInnerOuterChange(join, (Boolean)e.getNewValue(), false);
            }
            QueryImpl.this.fireJoinPropertyChangeEvent(e);
        }
    };
    private final ContainerChildListener tableChildListener = new ContainerChildListener(){

        @Override
        public void containerChildRemoved(ContainerChildEvent e) {
            QueryImpl.this.removeItem(e.getChild());
        }

        @Override
        public void containerChildAdded(ContainerChildEvent e) {
            QueryImpl.this.addItem(e.getChild());
        }
    };
    private final Container constantsContainer;
    private SQLDatabase database;
    private String userModifiedQuery = null;
    private SQLDatabaseMapping dbMapping;
    private String name;
    private int streamingRowLimit = 1000;
    private int rowLimit = 1000;
    private boolean streaming = false;
    public static final String USER_MODIFIED_QUERY = "userModifiedQuery";
    public static final String PROPERTY_TABLE_REMOVED = "PROPERTY_TABLE_REMOVED";
    private String uuid;

    public QueryImpl(SQLDatabaseMapping dbMapping) {
        this(dbMapping, true);
    }

    public QueryImpl(SQLDatabaseMapping dbMapping, boolean prepopulateConstants) {
        this(dbMapping, prepopulateConstants, null);
    }

    public QueryImpl(SQLDatabaseMapping dbMapping, boolean prepopulateConstants, Container newConstantsContainer) {
        this(dbMapping, prepopulateConstants, newConstantsContainer, null);
    }

    public QueryImpl(SQLDatabaseMapping dbMapping, boolean prepopulateConstants, Container newConstantsContainer, JDBCDataSource dataSource) {
        this.dbMapping = dbMapping;
        this.fromTableList = new ArrayList<Container>();
        this.joinMapping = new LinkedHashMap<Container, List<SQLJoin>>();
        this.constantsContainer = newConstantsContainer != null ? newConstantsContainer : new ItemContainer("Constants");
        this.constantsContainer.addChildListener(this.tableChildListener);
        if (dataSource != null) {
            this.setDataSourceWithoutSideEffects(dataSource);
        }
        if (prepopulateConstants) {
            this.resetConstantsContainer();
        }
    }

    private void resetConstantsContainer() {
        this.constantsContainer.setPosition(new Point2D.Double(0.0, 0.0));
        for (int i = this.constantsContainer.getItems().size() - 1; i >= 0; --i) {
            this.constantsContainer.removeItem(i);
        }
        StringItem currentTime = new StringItem("current_time");
        this.constantsContainer.addItem(currentTime);
        StringItem currentDate = new StringItem("current_date");
        this.constantsContainer.addItem(currentDate);
        StringItem user = new StringItem("user");
        this.constantsContainer.addItem(user);
        StringItem countStar = new StringItem("count(*)");
        this.constantsContainer.addItem(countStar);
    }

    public QueryImpl(QueryImpl copy, boolean connectListeners) {
        this(copy, connectListeners, copy.getDatabase());
    }

    public QueryImpl(QueryImpl copy, boolean connectListeners, SQLDatabase database) {
        this.fromTableList = new ArrayList<Container>();
        this.joinMapping = new LinkedHashMap<Container, List<SQLJoin>>();
        this.dbMapping = copy.dbMapping;
        this.setName(copy.getName());
        HashMap<Container, Container> oldToNewContainers = new HashMap<Container, Container>();
        for (Container table : copy.getFromTableList()) {
            Container tableCopy = table.createCopy();
            oldToNewContainers.put(table, tableCopy);
            this.fromTableList.add(tableCopy);
        }
        this.constantsContainer = copy.getConstantsContainer().createCopy();
        oldToNewContainers.put(copy.getConstantsContainer(), this.constantsContainer);
        HashSet joinSet = new HashSet();
        for (Map.Entry<Container, List<SQLJoin>> entry : copy.getJoinMapping().entrySet()) {
            joinSet.addAll(entry.getValue());
        }
        HashSet<SQLJoin> newJoinSet = new HashSet<SQLJoin>();
        for (SQLJoin oldJoin : joinSet) {
            Container newLeftContainer = (Container)oldToNewContainers.get(oldJoin.getLeftColumn().getContainer());
            Item newLeftItem = newLeftContainer.getItem(oldJoin.getLeftColumn().getItem());
            Container newRightContainer = (Container)oldToNewContainers.get(oldJoin.getRightColumn().getContainer());
            Item newRightItem = newRightContainer.getItem(oldJoin.getRightColumn().getItem());
            SQLJoin newJoin = oldJoin.createCopy(newLeftItem, newRightItem);
            newJoinSet.add(newJoin);
            List<SQLJoin> newJoinList = this.joinMapping.get(newLeftContainer);
            if (newJoinList == null) {
                newJoinList = new ArrayList<SQLJoin>();
                this.joinMapping.put(newLeftContainer, newJoinList);
            }
            newJoinList.add(newJoin);
            newJoinList = this.joinMapping.get(newRightContainer);
            if (newJoinList == null) {
                newJoinList = new ArrayList<SQLJoin>();
                this.joinMapping.put(newRightContainer, newJoinList);
            }
            newJoinList.add(newJoin);
            newJoin.setParent(this);
        }
        this.globalWhereClause = copy.getGlobalWhereClause();
        this.groupingEnabled = copy.isGroupingEnabled();
        this.streaming = copy.isStreaming();
        this.database = database;
        this.userModifiedQuery = copy.getUserModifiedQuery();
        if (connectListeners) {
            for (Container table : this.fromTableList) {
                table.addChildListener(this.getTableChildListener());
                for (Item column : table.getItems()) {
                    column.addPropertyChangeListener(this.itemListener);
                }
            }
            this.constantsContainer.addChildListener(this.getTableChildListener());
            for (Item column : this.constantsContainer.getItems()) {
                column.addPropertyChangeListener(this.itemListener);
            }
            for (SQLJoin join : newJoinSet) {
                join.addJoinChangeListener(this.joinChangeListener);
            }
        }
    }

    @Override
    public SQLDatabaseMapping getDBMapping() {
        return this.dbMapping;
    }

    @Override
    public void setDBMapping(SQLDatabaseMapping dbMapping) {
        this.dbMapping = dbMapping;
    }

    @Override
    public SQLDatabase getDatabase() {
        return this.database;
    }

    @Override
    public void setGroupingEnabled(boolean enabled) {
        logger.debug((Object)("Setting grouping enabled to " + enabled));
        if (!this.groupingEnabled && enabled) {
            this.startCompoundEdit("Defining the grouping function of string items to be count.");
            for (Item item : this.getSelectedColumns()) {
                if (!(item instanceof StringItem)) continue;
                item.setGroupBy(SQLGroupFunction.COUNT);
            }
            this.endCompoundEdit();
        }
        boolean oldGrouping = this.groupingEnabled;
        this.groupingEnabled = enabled;
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, GROUPING_ENABLED, oldGrouping, enabled));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public String generateQuery() {
        String alias;
        JDBCDataSource dataSource = null;
        if (this.database != null) {
            dataSource = this.database.getDataSource();
        }
        logger.debug((Object)("Data source is " + dataSource + " while generating the query."));
        ConstantConverter converter = ConstantConverter.getConverter(dataSource);
        if (this.userModifiedQuery != null) {
            return this.userModifiedQuery;
        }
        String quoteString = "";
        Connection con = null;
        if (this.database != null) {
            try {
                con = this.database.getConnection();
                quoteString = con.getMetaData().getIdentifierQuoteString();
            }
            catch (SQLObjectException e) {
            }
            catch (SQLException e) {
            }
            finally {
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e) {
                        logger.error((Object)e);
                    }
                }
            }
        }
        if (this.getSelectedColumns().size() == 0) {
            return "";
        }
        StringBuffer query = new StringBuffer();
        query.append("SELECT");
        boolean isFirstSelect = true;
        for (Item col : this.getSelectedColumns()) {
            String alias2;
            if (isFirstSelect) {
                query.append(" ");
                isFirstSelect = false;
            } else {
                query.append(", ");
            }
            if (this.isColumnGrouped(col)) {
                query.append((Object)((Object)col.getGroupBy()) + "(");
            }
            if ((alias2 = col.getContainer().getAlias()) != null && alias2.length() > 0) {
                query.append(quoteString + alias2 + quoteString + ".");
            } else if (this.fromTableList.contains(col.getContainer())) {
                query.append(quoteString + col.getContainer().getName() + quoteString + ".");
            }
            query.append(this.getColumnName(col, quoteString, converter));
            if (this.isColumnGrouped(col)) {
                query.append(")");
            }
            if (col.getAlias() != null && col.getAlias().trim().length() > 0) {
                query.append(" AS " + quoteString + col.getAlias() + quoteString);
                continue;
            }
            if (!this.isGroupingEnabled() || col.getGroupBy() == null || col.getGroupBy() == SQLGroupFunction.GROUP_BY) continue;
            query.append(" AS " + quoteString + (Object)((Object)col.getGroupBy()) + "_" + col.getName() + quoteString);
        }
        if (!this.fromTableList.isEmpty()) {
            query.append(" \nFROM");
        }
        boolean isFirstFrom = true;
        DepthFirstSearch<Container, SQLJoin> dfs = new DepthFirstSearch<Container, SQLJoin>();
        dfs.performSearch(new TableJoinGraph());
        Container previousTable = null;
        for (Container table : dfs.getFinishOrder()) {
            void var13_28;
            String qualifiedName = table.getContainedObject() instanceof SQLTable ? ((SQLTable)table.getContainedObject()).toQualifiedName(quoteString) : table.getName();
            String string = table.getAlias();
            if (string == null || string.length() <= 0) {
                String string2 = table.getName();
            }
            String string3 = quoteString + (String)var13_28 + quoteString;
            if (isFirstFrom) {
                query.append(" " + qualifiedName + " " + string3);
                isFirstFrom = false;
            } else {
                boolean joinFound = false;
                if (previousTable != null && this.joinMapping.get(table) != null) {
                    for (SQLJoin join : this.joinMapping.get(table)) {
                        if (join.getLeftColumn().getContainer() != previousTable) continue;
                        joinFound = true;
                        if (join.isLeftColumnOuterJoin() && join.isRightColumnOuterJoin()) {
                            query.append(" \nFULL OUTER JOIN ");
                            break;
                        }
                        if (join.isLeftColumnOuterJoin() && !join.isRightColumnOuterJoin()) {
                            query.append(" \nLEFT OUTER JOIN ");
                            break;
                        }
                        if (!join.isLeftColumnOuterJoin() && join.isRightColumnOuterJoin()) {
                            query.append(" \nRIGHT OUTER JOIN ");
                            break;
                        }
                        query.append(" \nINNER JOIN ");
                        break;
                    }
                }
                if (!joinFound) {
                    query.append(" \nINNER JOIN ");
                }
                query.append(qualifiedName + " " + string3 + " \n  ON ");
                if (this.joinMapping.get(table) == null || this.joinMapping.get(table).isEmpty()) {
                    query.append("0 = 0");
                } else {
                    boolean isFirstJoin = true;
                    for (SQLJoin join : this.joinMapping.get(table)) {
                        Item otherColumn = join.getLeftColumn().getContainer() == table ? join.getRightColumn() : join.getLeftColumn();
                        for (int i = 0; i < dfs.getFinishOrder().indexOf(table); ++i) {
                            String rightAlias;
                            if (otherColumn.getContainer() != dfs.getFinishOrder().get(i)) continue;
                            if (isFirstJoin) {
                                isFirstJoin = false;
                            } else {
                                query.append(" \n    AND ");
                            }
                            String leftAlias = join.getLeftColumn().getContainer().getAlias();
                            if (leftAlias == null || leftAlias.length() <= 0) {
                                leftAlias = join.getLeftColumn().getContainer().getName();
                            }
                            if ((rightAlias = join.getRightColumn().getContainer().getAlias()) == null || rightAlias.length() <= 0) {
                                rightAlias = join.getRightColumn().getContainer().getName();
                            }
                            query.append(quoteString + leftAlias + quoteString + "." + this.getColumnName(join.getLeftColumn(), quoteString, converter) + " " + join.getComparator() + " " + quoteString + rightAlias + quoteString + "." + this.getColumnName(join.getRightColumn(), quoteString, converter));
                        }
                    }
                    if (isFirstJoin) {
                        query.append("0 = 0");
                    }
                }
            }
            previousTable = table;
        }
        query.append(" ");
        boolean isFirstWhere = true;
        HashMap<Item, String> whereMapping = new HashMap<Item, String>();
        for (Item item : this.constantsContainer.getItems()) {
            if (item.getWhere() == null || item.getWhere().trim().length() <= 0) continue;
            whereMapping.put(item, item.getWhere());
        }
        for (Container container : this.fromTableList) {
            for (Item item : container.getItems()) {
                if (item.getWhere() == null || item.getWhere().trim().length() <= 0) continue;
                whereMapping.put(item, item.getWhere());
            }
        }
        for (Map.Entry entry : whereMapping.entrySet()) {
            if (((String)entry.getValue()).length() <= 0) continue;
            if (isFirstWhere) {
                query.append(" \nWHERE ");
                isFirstWhere = false;
            } else {
                query.append(" AND ");
            }
            String alias4 = ((Item)entry.getKey()).getContainer().getAlias();
            if (alias4 != null && alias4.length() > 0) {
                query.append(quoteString + alias4 + quoteString + ".");
            } else if (this.fromTableList.contains(((Item)entry.getKey()).getContainer())) {
                query.append(quoteString + ((Item)entry.getKey()).getContainer().getName() + quoteString + ".");
            }
            query.append(this.getColumnName((Item)entry.getKey(), quoteString, converter) + " " + (String)entry.getValue());
        }
        if (this.globalWhereClause != null && this.globalWhereClause.length() > 0) {
            if (!isFirstWhere) {
                query.append(" AND");
            } else {
                query.append(" \nWHERE ");
            }
            query.append(" " + this.globalWhereClause);
        }
        if (this.groupingEnabled) {
            boolean isFirstGroupBy = true;
            for (Item col : this.getSelectedColumns()) {
                if (!col.getGroupBy().equals((Object)SQLGroupFunction.GROUP_BY) || this.isStringItemAggregated(col)) continue;
                if (isFirstGroupBy) {
                    query.append("\nGROUP BY ");
                    isFirstGroupBy = false;
                } else {
                    query.append(", ");
                }
                alias = col.getContainer().getAlias();
                if (alias != null && alias.length() > 0) {
                    query.append(quoteString + alias + quoteString + ".");
                } else if (this.fromTableList.contains(col.getContainer())) {
                    query.append(quoteString + col.getContainer().getName() + quoteString + ".");
                }
                query.append(this.getColumnName(col, quoteString, converter));
            }
            query.append(" ");
            boolean bl = true;
            for (Item column : this.getSelectedColumns()) {
                String alias5;
                boolean bl2;
                if (column.getHaving() == null || column.getHaving().trim().length() <= 0) continue;
                if (bl2) {
                    query.append("\nHAVING ");
                    bl2 = false;
                } else {
                    query.append(" AND ");
                }
                if (this.isColumnGrouped(column)) {
                    query.append((Object)((Object)column.getGroupBy()) + "(");
                }
                if ((alias5 = column.getContainer().getAlias()) != null && alias5.length() > 0) {
                    query.append(quoteString + alias5 + quoteString + ".");
                } else if (this.fromTableList.contains(column.getContainer())) {
                    query.append(quoteString + column.getContainer().getName() + quoteString + ".");
                }
                query.append(this.getColumnName(column, quoteString, converter));
                if (this.isColumnGrouped(column)) {
                    query.append(")");
                }
                query.append(" ");
                query.append(column.getHaving());
            }
            query.append(" ");
        }
        if (!this.getOrderByList().isEmpty()) {
            boolean isFirstOrder = true;
            for (Item col : this.getOrderByList()) {
                if (isFirstOrder) {
                    query.append("\nORDER BY ");
                    isFirstOrder = false;
                } else {
                    query.append(", ");
                }
                if (this.groupingEnabled && !col.getGroupBy().equals((Object)SQLGroupFunction.GROUP_BY)) {
                    query.append((Object)((Object)col.getGroupBy()) + "(");
                }
                if ((alias = col.getContainer().getAlias()) != null && alias.length() > 0) {
                    query.append(quoteString + alias + quoteString + ".");
                } else if (this.fromTableList.contains(col.getContainer())) {
                    query.append(quoteString + col.getContainer().getName() + quoteString + ".");
                }
                query.append(this.getColumnName(col, quoteString, converter));
                if (this.groupingEnabled && !col.getGroupBy().equals((Object)SQLGroupFunction.GROUP_BY)) {
                    query.append(")");
                }
                query.append(" ");
                if (col.getOrderBy().equals((Object)OrderByArgument.NONE)) continue;
                query.append(col.getOrderBy().toString() + " ");
            }
        }
        logger.debug((Object)(" Query is : " + query.toString()));
        return query.toString();
    }

    private boolean isColumnGrouped(Item col) {
        return this.groupingEnabled && !col.getGroupBy().equals((Object)SQLGroupFunction.GROUP_BY) && !this.isStringItemAggregated(col);
    }

    @Override
    public boolean containsCrossJoins() {
        DepthFirstSearch<Container, SQLJoin> dfs = new DepthFirstSearch<Container, SQLJoin>();
        TableJoinGraph graph = new TableJoinGraph();
        dfs.performSearch(graph);
        ArrayList<Object> previousContainers = new ArrayList<Object>();
        if (dfs.getFinishOrder().size() == 0) {
            return false;
        }
        previousContainers.add(dfs.getFinishOrder().get(0));
        for (int i = 1; i < dfs.getFinishOrder().size(); ++i) {
            Container container = (Container)dfs.getFinishOrder().get(i);
            boolean connected = false;
            List<SQLJoin> list = this.joinMapping.get(container);
            if (list == null) {
                return true;
            }
            for (SQLJoin join : list) {
                Container leftContainer = join.getLeftColumn().getParent();
                Container rightContainer = join.getRightColumn().getParent();
                if ((leftContainer != container || !previousContainers.contains(rightContainer)) && (rightContainer != container || !previousContainers.contains(leftContainer))) continue;
                connected = true;
                break;
            }
            if (!connected) {
                return true;
            }
            previousContainers.add(container);
        }
        return false;
    }

    private boolean isStringItemAggregated(Item col) {
        StringBuffer groupingRegex = new StringBuffer();
        for (SQLGroupFunction function : SQLGroupFunction.values()) {
            if (function == SQLGroupFunction.GROUP_BY) continue;
            if (groupingRegex.length() == 0) {
                groupingRegex.append("(");
            } else {
                groupingRegex.append("|");
            }
            groupingRegex.append(function.getGroupingName());
        }
        groupingRegex.append(").*");
        boolean isStringItemAndAggregated = col instanceof StringItem && ((String)col.getItem()).toUpperCase().matches(groupingRegex.toString().toUpperCase());
        return isStringItemAndAggregated;
    }

    private String getColumnName(Item item, String quote, ConstantConverter converter) {
        if (item instanceof StringItem) {
            return converter.getName(item);
        }
        if (item instanceof SQLObjectItem) {
            return quote + item.getName() + quote;
        }
        throw new IllegalArgumentException("Unknown item type " + item.getClass() + " when trying to define a name for the item " + item.getName());
    }

    @Override
    public List<Item> getSelectedColumns() {
        SortedMap<Integer, Item> sortedItems = this.getSelectedColumnsMap();
        ArrayList<Item> selectedColumns = new ArrayList<Item>();
        for (Map.Entry<Integer, Item> entry : sortedItems.entrySet()) {
            selectedColumns.add(entry.getValue());
        }
        return Collections.unmodifiableList(selectedColumns);
    }

    private SortedMap<Integer, Item> getSelectedColumnsMap() {
        TreeMap<Integer, Item> sortedItems = new TreeMap<Integer, Item>();
        ArrayList<Container> containers = new ArrayList<Container>(this.fromTableList);
        containers.add(this.constantsContainer);
        for (Container container : containers) {
            for (Item item : container.getItems()) {
                if (item.getSelected() == null) continue;
                if (sortedItems.get(item.getSelected()) != null) {
                    throw new IllegalStateException("The item " + item.getName() + " has selected order " + item.getSelected() + " but the item " + ((Item)sortedItems.get(item.getSelected())).getName() + " already exists " + "with the same sort order.");
                }
                sortedItems.put(item.getSelected(), item);
            }
        }
        logger.debug((Object)("Selected columns are " + sortedItems));
        return sortedItems;
    }

    @Override
    public List<Item> getOrderByList() {
        SortedMap<Integer, Item> sortedItems = this.getOrderByMap();
        ArrayList<Item> orderByColumns = new ArrayList<Item>();
        for (Map.Entry<Integer, Item> entry : sortedItems.entrySet()) {
            orderByColumns.add(entry.getValue());
        }
        return Collections.unmodifiableList(orderByColumns);
    }

    private SortedMap<Integer, Item> getOrderByMap() {
        TreeMap<Integer, Item> sortedItems = new TreeMap<Integer, Item>();
        ArrayList<Container> containers = new ArrayList<Container>(this.fromTableList);
        containers.add(this.constantsContainer);
        for (Container container : containers) {
            for (Item item : container.getItems()) {
                if (item.getSelected() == null || item.getOrderBy().equals((Object)OrderByArgument.NONE) || item.getOrderByOrdering() == null) continue;
                if (sortedItems.get(item.getOrderByOrdering()) != null) {
                    throw new IllegalStateException("The item " + item.getName() + " has order by order " + item.getSelected() + " but the item " + ((Item)sortedItems.get(item.getSelected())).getName() + " already exists " + "with the same order by order.");
                }
                sortedItems.put(item.getOrderByOrdering(), item);
            }
        }
        return sortedItems;
    }

    @Override
    public void moveOrderByItemToEnd(Item item) {
        Integer itemPosition = item.getOrderByOrdering();
        Integer maxPosition = -1;
        for (Map.Entry<Integer, Item> entry : this.getOrderByMap().entrySet()) {
            if (itemPosition != null && entry.getKey() > itemPosition) {
                entry.getValue().setOrderByOrdering(entry.getValue().getOrderByOrdering() - 1);
            }
            maxPosition = entry.getValue().getOrderByOrdering();
        }
        item.setOrderByOrdering(maxPosition + 1);
    }

    @Override
    public void orderColumn(Item item, OrderByArgument ordering) {
        if (ordering.equals((Object)OrderByArgument.NONE)) {
            Integer itemPosition = item.getOrderByOrdering();
            item.setOrderByOrdering(null);
            for (Map.Entry<Integer, Item> entry : this.getOrderByMap().entrySet()) {
                if (itemPosition == null || entry.getKey() <= itemPosition) continue;
                entry.getValue().setOrderByOrdering(entry.getValue().getOrderByOrdering() - 1);
            }
        } else {
            this.moveOrderByItemToEnd(item);
        }
        item.setOrderBy(ordering);
    }

    public int indexOfOrderByItem(Item item) {
        List<Item> orderByList = this.getOrderByList();
        for (int i = 0; i < orderByList.size(); ++i) {
            if (!orderByList.get(i).equals(item)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTable(Container table) {
        try {
            this.startCompoundEdit("Removing table " + table.getName() + ", its columns and its joins.");
            boolean removed = this.fromTableList.remove(table);
            if (!removed) {
                return;
            }
            table.removeChildListener(this.getTableChildListener());
            for (Item item : table.getItems()) {
                this.removeItem(item);
            }
            for (List list : this.joinMapping.values()) {
                for (int i = list.size() - 1; i >= 0; --i) {
                    SQLJoin join = (SQLJoin)list.get(i);
                    if (!join.getLeftColumn().getParent().equals(table) && !join.getRightColumn().getParent().equals(table)) continue;
                    this.removeJoin(join);
                }
            }
            this.fireContainerRemoved(table);
        }
        finally {
            this.endCompoundEdit();
        }
    }

    @Override
    public void addTable(Container container) {
        this.addTable(container, this.fromTableList.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTable(Container container, int index) {
        if (this.fromTableList.contains(container)) {
            throw new IllegalArgumentException("The container " + container.getName() + " already exists in the query " + this.getName());
        }
        try {
            this.startCompoundEdit("Add Table " + container.getName());
            this.fromTableList.add(index, container);
            container.addChildListener(this.getTableChildListener());
            for (Item col : container.getItems()) {
                this.addItem(col);
            }
            this.fireContainerAdded(container);
        }
        finally {
            this.endCompoundEdit();
        }
    }

    @Override
    public void setGlobalWhereClause(String whereClause) {
        String oldWhere = this.globalWhereClause;
        this.globalWhereClause = whereClause;
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, GLOBAL_WHERE_CLAUSE, oldWhere, whereClause));
    }

    @Override
    public void removeJoin(SQLJoin joinLine) {
        joinLine.removeJoinChangeListener(this.joinChangeListener);
        Item leftColumn = joinLine.getLeftColumn();
        Item rightColumn = joinLine.getRightColumn();
        List<SQLJoin> leftJoinList = this.joinMapping.get(leftColumn.getContainer());
        for (SQLJoin join : leftJoinList) {
            if (leftColumn != join.getLeftColumn() || rightColumn != join.getRightColumn()) continue;
            leftJoinList.remove(join);
            break;
        }
        List<SQLJoin> rightJoinList = this.joinMapping.get(rightColumn.getContainer());
        for (SQLJoin join : rightJoinList) {
            if (leftColumn != join.getLeftColumn() || rightColumn != join.getRightColumn()) continue;
            rightJoinList.remove(join);
            break;
        }
        this.fireJoinRemoved(joinLine);
    }

    @Override
    public void addJoin(SQLJoin join) {
        SQLJoin prevJoin;
        ArrayList<SQLJoin> joinList;
        if (this.getJoins().contains(join)) {
            throw new IllegalArgumentException("The join " + join.getName() + " already exists in the query " + this.getName());
        }
        join.addJoinChangeListener(this.joinChangeListener);
        Item leftColumn = join.getLeftColumn();
        Item rightColumn = join.getRightColumn();
        Container leftContainer = leftColumn.getContainer();
        Container rightContainer = rightColumn.getContainer();
        if (this.joinMapping.get(leftContainer) == null) {
            joinList = new ArrayList<SQLJoin>();
            joinList.add(join);
            this.joinMapping.put(leftContainer, joinList);
        } else {
            if (this.joinMapping.get(leftContainer).size() > 0) {
                prevJoin = this.joinMapping.get(leftContainer).get(0);
                if (prevJoin.getLeftColumn().getContainer() == leftContainer) {
                    join.setLeftColumnOuterJoin(prevJoin.isLeftColumnOuterJoin());
                } else if (prevJoin.getRightColumn().getContainer() == leftContainer) {
                    join.setLeftColumnOuterJoin(prevJoin.isRightColumnOuterJoin());
                }
            }
            this.joinMapping.get(leftContainer).add(join);
        }
        if (this.joinMapping.get(rightContainer) == null) {
            joinList = new ArrayList();
            joinList.add(join);
            this.joinMapping.put(rightContainer, joinList);
        } else {
            if (this.joinMapping.get(rightContainer).size() > 0) {
                prevJoin = this.joinMapping.get(rightContainer).get(0);
                if (prevJoin.getLeftColumn().getContainer() == rightContainer) {
                    join.setRightColumnOuterJoin(prevJoin.isLeftColumnOuterJoin());
                } else if (prevJoin.getRightColumn().getContainer() == rightContainer) {
                    join.setRightColumnOuterJoin(prevJoin.isRightColumnOuterJoin());
                } else {
                    throw new IllegalStateException("A table contains a join that is not connected to any of its columns in the table.");
                }
            }
            this.joinMapping.get(rightContainer).add(join);
        }
        join.setParent(this);
        this.fireJoinAdded(join);
    }

    @Override
    public void removeItem(Item col) {
        logger.debug((Object)("Item name is " + col.getName()));
        col.removePropertyChangeListener(this.itemListener);
        this.fireItemRemoved(col);
    }

    @Override
    public void addItem(Item col) {
        col.addPropertyChangeListener(this.itemListener);
        this.fireItemAdded(col);
    }

    @Override
    public void moveOrderBy(Item item, int index) {
        SortedMap<Integer, Item> orderByMap = this.getOrderByMap();
        for (Map.Entry<Integer, Item> entry : orderByMap.entrySet()) {
            if (entry.getKey() < index) continue;
            entry.getValue().setSelected(entry.getValue().getSelected() + 1);
        }
        item.setSelected(index);
    }

    @Override
    public void moveItem(Item movedColumn, int toIndex) {
        int oldIndex = movedColumn.getSelected();
        movedColumn.setSelected(null);
        SortedMap<Integer, Item> selectedColumnsMap = this.getSelectedColumnsMap();
        Set<Map.Entry<Integer, Item>> entrySet = selectedColumnsMap.entrySet();
        if (toIndex > oldIndex) {
            for (Map.Entry<Integer, Item> entry : entrySet) {
                if (entry.getKey() > toIndex || entry.getKey() <= oldIndex) continue;
                entry.getValue().setSelected(entry.getKey() - 1);
            }
        } else {
            ArrayList<Item> selectionsToShiftForward = new ArrayList<Item>();
            for (Map.Entry<Integer, Item> entry : entrySet) {
                if (entry.getKey() < toIndex || entry.getKey() >= oldIndex) continue;
                selectionsToShiftForward.add(entry.getValue());
            }
            for (int i = selectionsToShiftForward.size() - 1; i >= 0; --i) {
                Item item = (Item)selectionsToShiftForward.get(i);
                item.setSelected(item.getSelected() + 1);
            }
        }
        movedColumn.setSelected(toIndex);
    }

    @Override
    public void startCompoundEdit(String message) {
        int currentEditLevel;
        if ((currentEditLevel = this.compoundEditLevel++) == 0) {
            this.fireCompoundEditStarted(message);
        }
    }

    @Override
    public void endCompoundEdit() {
        --this.compoundEditLevel;
        if (this.compoundEditLevel == 0) {
            this.fireCompoundEditEnded();
        }
    }

    @Override
    public boolean isGroupingEnabled() {
        return this.groupingEnabled;
    }

    @Override
    public List<Container> getFromTableList() {
        return Collections.unmodifiableList(this.fromTableList);
    }

    protected Map<Container, List<SQLJoin>> getJoinMapping() {
        return Collections.unmodifiableMap(this.joinMapping);
    }

    @Override
    public Collection<SQLJoin> getJoins() {
        HashSet<SQLJoin> joinSet = new HashSet<SQLJoin>();
        for (List<SQLJoin> joins : this.joinMapping.values()) {
            for (SQLJoin join : joins) {
                joinSet.add(join);
            }
        }
        return joinSet;
    }

    @Override
    public String getGlobalWhereClause() {
        return this.globalWhereClause;
    }

    @Override
    public Container getConstantsContainer() {
        return this.constantsContainer;
    }

    @Override
    public void setDataSource(JDBCDataSource dataSource) {
        boolean dsSet = this.setDataSourceWithoutSideEffects(dataSource);
        if (dsSet) {
            this.reset();
        }
    }

    @Override
    public boolean setDataSourceWithoutSideEffects(JDBCDataSource dataSource) {
        SQLDatabase newDatabase = this.dbMapping.getDatabase(dataSource);
        SQLDatabase old = this.database;
        if (this.database != null && this.database == newDatabase) {
            return false;
        }
        this.database = newDatabase;
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, "database", old, newDatabase));
        return true;
    }

    @Override
    public JDBCDataSource getDataSource() {
        if (this.database == null) {
            return null;
        }
        return this.database.getDataSource();
    }

    @Override
    public void setUserModifiedQuery(String query) {
        String oldUserQuery = this.userModifiedQuery;
        this.userModifiedQuery = query;
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, USER_MODIFIED_QUERY, oldUserQuery, query));
    }

    @Override
    public boolean isScriptModified() {
        return this.userModifiedQuery != null;
    }

    @Override
    public void removeUserModifications() {
        logger.debug((Object)"Removing user modified query.");
        this.setUserModifiedQuery(null);
    }

    @Override
    public void setZoomLevel(int zoomLevel) {
        int oldZoom = this.zoomLevel;
        this.zoomLevel = zoomLevel;
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, "zoomLevel", oldZoom, zoomLevel));
    }

    @Override
    public int getZoomLevel() {
        return this.zoomLevel;
    }

    @Override
    public String getUserModifiedQuery() {
        return this.userModifiedQuery;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, "name", oldName, name));
    }

    @Override
    public void setRowLimit(int rowLimit) {
        int oldLimit = this.rowLimit;
        this.rowLimit = rowLimit;
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, ROW_LIMIT, oldLimit, rowLimit));
    }

    @Override
    public int getRowLimit() {
        return this.rowLimit;
    }

    @Override
    public void setStreamingRowLimit(int streamingRowLimit) {
        int oldLimit = this.streamingRowLimit;
        this.streamingRowLimit = streamingRowLimit;
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, "streamingRowLimit", oldLimit, streamingRowLimit));
    }

    @Override
    public int getStreamingRowLimit() {
        return this.streamingRowLimit;
    }

    @Override
    public void setStreaming(boolean streaming) {
        boolean oldStreaming = this.streaming;
        this.streaming = streaming;
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, "streaming", oldStreaming, streaming));
    }

    @Override
    public boolean isStreaming() {
        return this.streaming;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addQueryChangeListener(QueryChangeListener l) {
        List<QueryChangeListener> list = this.changeListeners;
        synchronized (list) {
            this.changeListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeQueryChangeListener(QueryChangeListener l) {
        List<QueryChangeListener> list = this.changeListeners;
        synchronized (list) {
            this.changeListeners.remove(l);
        }
    }

    ContainerChildListener getTableChildListener() {
        return this.tableChildListener;
    }

    PropertyChangeListener getItemListener() {
        return this.itemListener;
    }

    PropertyChangeListener getJoinChangeListener() {
        return this.joinChangeListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        try {
            this.startCompoundEdit("Resetting query");
            for (int i = this.getFromTableList().size() - 1; i >= 0; --i) {
                this.removeTable(this.getFromTableList().get(i));
            }
            this.resetConstantsContainer();
            this.setGlobalWhereClause(null);
            this.setGroupingEnabled(false);
            this.setUserModifiedQuery(null);
            this.setZoomLevel(0);
        }
        finally {
            this.endCompoundEdit();
        }
    }

    @Override
    public int indexOfSelectedItem(Item item) {
        List<Item> selectedColumns = this.getSelectedColumns();
        for (int i = 0; i < selectedColumns.size(); ++i) {
            if (!selectedColumns.get(i).equals(item)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void selectItem(Item item) {
        if (item.getSelected() != null) {
            return;
        }
        Integer max = -1;
        if (this.getSelectedColumnsMap().keySet().size() > 0) {
            max = Collections.max(this.getSelectedColumnsMap().keySet());
        }
        item.setSelected(max + 1);
    }

    @Override
    public void unselectItem(Item item) {
        if (item.getSelected() == null) {
            return;
        }
        Integer oldSelection = item.getSelected();
        item.setSelected(null);
        for (Map.Entry<Integer, Item> entry : this.getSelectedColumnsMap().entrySet()) {
            if (entry.getKey() <= oldSelection) continue;
            entry.getValue().setSelected(entry.getValue().getSelected() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireJoinAdded(SQLJoin joinAdded) {
        List<QueryChangeListener> list = this.changeListeners;
        synchronized (list) {
            for (int i = this.changeListeners.size() - 1; i >= 0; --i) {
                this.changeListeners.get(i).joinAdded(new QueryChangeEvent((Query)this, joinAdded));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireJoinRemoved(SQLJoin joinRemoved) {
        List<QueryChangeListener> list = this.changeListeners;
        synchronized (list) {
            for (int i = this.changeListeners.size() - 1; i >= 0; --i) {
                this.changeListeners.get(i).joinRemoved(new QueryChangeEvent((Query)this, joinRemoved));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireJoinPropertyChangeEvent(PropertyChangeEvent e) {
        List<QueryChangeListener> list = this.changeListeners;
        synchronized (list) {
            for (int i = this.changeListeners.size() - 1; i >= 0; --i) {
                this.changeListeners.get(i).joinPropertyChangeEvent(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireItemPropertyChangeEvent(PropertyChangeEvent e) {
        List<QueryChangeListener> list = this.changeListeners;
        synchronized (list) {
            for (int i = this.changeListeners.size() - 1; i >= 0; --i) {
                this.changeListeners.get(i).itemPropertyChangeEvent(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireItemAdded(Item itemAdded) {
        List<QueryChangeListener> list = this.changeListeners;
        synchronized (list) {
            for (int i = this.changeListeners.size() - 1; i >= 0; --i) {
                this.changeListeners.get(i).itemAdded(new QueryChangeEvent((Query)this, itemAdded));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireItemRemoved(Item itemRemoved) {
        List<QueryChangeListener> list = this.changeListeners;
        synchronized (list) {
            for (int i = this.changeListeners.size() - 1; i >= 0; --i) {
                this.changeListeners.get(i).itemRemoved(new QueryChangeEvent((Query)this, itemRemoved));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireContainerAdded(Container containerAdded) {
        List<QueryChangeListener> list = this.changeListeners;
        synchronized (list) {
            for (int i = this.changeListeners.size() - 1; i >= 0; --i) {
                this.changeListeners.get(i).containerAdded(new QueryChangeEvent((Query)this, containerAdded));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireContainerRemoved(Container containerRemoved) {
        List<QueryChangeListener> list = this.changeListeners;
        synchronized (list) {
            for (int i = this.changeListeners.size() - 1; i >= 0; --i) {
                this.changeListeners.get(i).containerRemoved(new QueryChangeEvent((Query)this, containerRemoved));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firePropertyChangeEvent(PropertyChangeEvent e) {
        List<QueryChangeListener> list = this.changeListeners;
        synchronized (list) {
            for (int i = this.changeListeners.size() - 1; i >= 0; --i) {
                this.changeListeners.get(i).propertyChangeEvent(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCompoundEditStarted(String message) {
        List<QueryChangeListener> list = this.changeListeners;
        synchronized (list) {
            for (int i = this.changeListeners.size() - 1; i >= 0; --i) {
                this.changeListeners.get(i).compoundEditStarted(TransactionEvent.createStartTransactionEvent(this, message));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCompoundEditEnded() {
        List<QueryChangeListener> list = this.changeListeners;
        synchronized (list) {
            for (int i = this.changeListeners.size() - 1; i >= 0; --i) {
                this.changeListeners.get(i).compoundEditEnded(TransactionEvent.createEndTransactionEvent(this));
            }
        }
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    private void updateJoinsOnInnerOuterChange(SQLJoin joinChanged, boolean isOuterJoin, boolean isLeftColumn) {
        if (isLeftColumn) {
            logger.debug((Object)"Got left join changed.");
            Container leftJoinContainer = joinChanged.getLeftColumn().getContainer();
            for (SQLJoin join : this.joinMapping.get(leftJoinContainer)) {
                if (join.getLeftColumn().getContainer() == leftJoinContainer) {
                    join.setLeftColumnOuterJoin(isOuterJoin);
                    continue;
                }
                join.setRightColumnOuterJoin(isOuterJoin);
            }
        } else {
            logger.debug((Object)"Got right join changed.");
            Container rightJoinContainer = joinChanged.getRightColumn().getContainer();
            logger.debug((Object)("There are " + this.joinMapping.get(rightJoinContainer) + " joins on the table with the changed join."));
            for (SQLJoin join : this.joinMapping.get(rightJoinContainer)) {
                if (join.getLeftColumn().getContainer() == rightJoinContainer) {
                    logger.debug((Object)"Changing left side");
                    join.setLeftColumnOuterJoin(isOuterJoin);
                    continue;
                }
                logger.debug((Object)"Changing right side");
                join.setRightColumnOuterJoin(isOuterJoin);
            }
        }
    }

    class TableJoinGraph
    implements GraphModel<Container, SQLJoin> {
        TableJoinGraph() {
        }

        @Override
        public Collection<Container> getAdjacentNodes(Container node) {
            ArrayList<Container> adjacencyNodes = new ArrayList<Container>();
            if (QueryImpl.this.joinMapping.get(node) != null) {
                for (SQLJoin join : (List)QueryImpl.this.joinMapping.get(node)) {
                    if (join.getLeftColumn().getContainer() == node) {
                        adjacencyNodes.add(join.getRightColumn().getContainer());
                        continue;
                    }
                    adjacencyNodes.add(join.getLeftColumn().getContainer());
                }
            }
            return adjacencyNodes;
        }

        @Override
        public Collection<SQLJoin> getEdges() {
            ArrayList<SQLJoin> edgesList = new ArrayList<SQLJoin>();
            for (List joinList : QueryImpl.this.joinMapping.values()) {
                for (SQLJoin join : joinList) {
                    edgesList.add(join);
                }
            }
            return edgesList;
        }

        @Override
        public Collection<SQLJoin> getInboundEdges(Container node) {
            ArrayList<SQLJoin> inboundEdges = new ArrayList<SQLJoin>();
            if (QueryImpl.this.joinMapping.get(node) != null) {
                for (SQLJoin join : (List)QueryImpl.this.joinMapping.get(node)) {
                    inboundEdges.add(join);
                }
            }
            return inboundEdges;
        }

        @Override
        public Collection<Container> getNodes() {
            return QueryImpl.this.fromTableList;
        }

        @Override
        public Collection<SQLJoin> getOutboundEdges(Container node) {
            ArrayList<SQLJoin> outboundEdges = new ArrayList<SQLJoin>();
            if (QueryImpl.this.joinMapping.get(node) != null) {
                for (SQLJoin join : (List)QueryImpl.this.joinMapping.get(node)) {
                    outboundEdges.add(join);
                }
            }
            return outboundEdges;
        }
    }

    public static enum OrderByArgument {
        ASC,
        DESC,
        NONE;

    }
}

