/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import ca.sqlpower.sql.ColumnNotDisplayableException;
import ca.sqlpower.sql.NoRowidException;
import ca.sqlpower.sql.WebResultFormatter;
import ca.sqlpower.sql.WebResultSet;
import ca.sqlpower.util.Web;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.List;
import java.util.ListIterator;

public class WebResultHTMLFormatter
extends WebResultFormatter {
    private boolean dropdownsInline = false;
    private boolean dropdownsAbove = true;
    private int dropdownsPerRow = 3;
    private boolean rowHighlightingOn = false;
    private String[] extraJavaScript = new String[21];
    private int repeatHeaderRow = 0;
    private static final String JS_HIGHLIGHT_CODE = "<script language=\"JavaScript\">\n// Derived from code found at javascript.faqts.com\nfunction highlightRow (boolean_element, h_color, n_color) {\n while (boolean_element.tagName.toUpperCase() != 'TR' && boolean_element != null)\n boolean_element = document.all?boolean_element.parentElement:boolean_element.parentNode;\n if (boolean_element) {\n  if(boolean_element.value) {\n   boolean_element.bgColor = h_color;\n  } else {\n   boolean_element.bgColor = n_color;\n  }\n }\n}\n</script>\n";

    public boolean isDropdownsInline() {
        return this.dropdownsInline;
    }

    public void setDropdownsInline(boolean v) {
        this.dropdownsInline = v;
    }

    public boolean isDropdownsAbove() {
        return this.dropdownsAbove;
    }

    public void setDropdownsAbove(boolean v) {
        this.dropdownsAbove = v;
    }

    public int getDropdownsPerRow() {
        return this.dropdownsPerRow;
    }

    public void setDropdownsPerRow(int v) {
        this.dropdownsPerRow = v;
    }

    public boolean isRowHighlightingOn() {
        return this.rowHighlightingOn;
    }

    public void setRowHighlightingOn(boolean v) {
        this.rowHighlightingOn = v;
    }

    public String getExtraJavaScript(int type) {
        return this.extraJavaScript[type];
    }

    public void setExtraJavaScript(int type, String js) {
        this.extraJavaScript[type] = js;
    }

    public int getRepeatHeaderRow() {
        return this.repeatHeaderRow;
    }

    public void setRepeatHeaderRow(int v) {
        this.repeatHeaderRow = v;
    }

    @Override
    public String format(WebResultSet wrs) throws SQLException, NoRowidException, IllegalStateException {
        StringWriter out = new StringWriter();
        PrintWriter pwout = new PrintWriter(out);
        this.formatToStream(wrs, pwout);
        return out.toString();
    }

    @Override
    public void formatToStream(WebResultSet wrs, PrintWriter out) throws SQLException, NoRowidException, IllegalStateException {
        int i;
        int numCols = wrs.getColumnCount();
        StringBuffer sb = new StringBuffer(256);
        int countdownToNextHeader = this.repeatHeaderRow;
        if (countdownToNextHeader == 0) {
            countdownToNextHeader = -1;
        }
        if (this.rowHighlightingOn) {
            out.print(JS_HIGHLIGHT_CODE);
        }
        if (this.dropdownsAbove) {
            List choices = null;
            int numRenderedCells = 0;
            out.println("<table>");
            out.println(" <tr>");
            for (int i2 = 1; i2 <= numCols; ++i2) {
                sb.setLength(0);
                try {
                    choices = wrs.getColumnChoicesList(i2);
                    if (choices != null) {
                        sb.append("\n  <td align=\"right\" class=\"searchForm\">");
                        sb.append(wrs.getColumnLabel(i2));
                        sb.append("</td>\n  <td align=\"left\" class=\"searchForm\">");
                        sb.append(Web.makeSelectionList(wrs.getColumnChoicesName(i2), choices, wrs.getColumnDefaultChoice(i2), wrs.getColumnHasAny(i2), wrs.getColumnHasAll(i2)));
                        sb.append("\n  </td>");
                        if (++numRenderedCells >= this.dropdownsPerRow) {
                            numRenderedCells = 0;
                            sb.append("\n </tr>\n <tr>");
                        }
                    }
                    out.println(sb);
                    continue;
                }
                catch (ColumnNotDisplayableException e) {
                    // empty catch block
                }
            }
            out.println(" </tr>");
            out.println("</table>");
        }
        out.println("<table class=\"resultTable\">");
        this.outputHeaderRow(wrs, out);
        if (this.dropdownsInline) {
            out.println(" <tr class=\"resultTableHeading\">");
            for (int i3 = 1; i3 <= numCols; ++i3) {
                sb.setLength(0);
                try {
                    List choices = wrs.getColumnChoicesList(i3);
                    sb.append("  <td>");
                    if (choices != null) {
                        sb.append(Web.makeSelectionList(wrs.getColumnChoicesName(i3), choices, wrs.getColumnDefaultChoice(i3), wrs.getColumnHasAny(i3), wrs.getColumnHasAll(i3)));
                    }
                    sb.append("\n  </td>");
                    out.println(sb);
                    continue;
                }
                catch (ColumnNotDisplayableException e) {
                    // empty catch block
                }
            }
            out.println(" </tr>");
        }
        StringBuffer align = new StringBuffer(10);
        StringBuffer contents = new StringBuffer(50);
        boolean mutexOnThisRow = false;
        int mutexRowNum = 0;
        while (wrs.next()) {
            out.println(" <tr class=\"resultTableData\">");
            for (i = 1; i <= numCols; ++i) {
                sb.setLength(0);
                if (wrs.getColumnType(i) == 13) {
                    try {
                        sb.append("<td align=\"center\">");
                        if (wrs.getString(i) != null) {
                            mutexOnThisRow = true;
                            sb.append("<input type=\"checkbox\" name=\"");
                            sb.append(wrs.getColumnLabel(i));
                            sb.append("\" value=\"");
                            sb.append(wrs.getRowid());
                            sb.append("\" onClick=\"");
                            sb.append(this.mutexBoxes(wrs.getColumnMutexList(i), mutexRowNum));
                            sb.append("\"");
                            if (wrs.getString(i).equals(this.checkboxYesValue)) {
                                sb.append(" checked");
                            }
                            sb.append(" />");
                        }
                        sb.append("</td>");
                        out.println(sb);
                        continue;
                    }
                    catch (ColumnNotDisplayableException e) {
                        throw new IllegalStateException("Unexpected ColumnNotDisplayableException caught on MUTEX_CHECKBOX");
                    }
                }
                try {
                    boolean valueIsDefault = true;
                    String colDefault = wrs.getColumnDefaultValue(i);
                    String rawContents = wrs.getString(i);
                    align.setLength(0);
                    contents.setLength(0);
                    this.getColumnFormatted(wrs, i, contents, align);
                    if (colDefault != null && rawContents != null) {
                        valueIsDefault = rawContents.equals(colDefault);
                    }
                    sb.append("  <td align=\"");
                    sb.append(align);
                    sb.append("\">");
                    if (!valueIsDefault) {
                        sb.append("<font color=\"red\">");
                    }
                    sb.append(contents);
                    if (!valueIsDefault) {
                        sb.append("</font>");
                    }
                    sb.append("</td>");
                    out.println(sb);
                    continue;
                }
                catch (ColumnNotDisplayableException e) {
                    // empty catch block
                }
            }
            out.println(" </tr>");
            if (--countdownToNextHeader == 0) {
                this.outputHeaderRow(wrs, out);
                countdownToNextHeader = this.repeatHeaderRow;
            }
            if (mutexOnThisRow) {
                ++mutexRowNum;
            }
            mutexOnThisRow = false;
        }
        out.println("</table>");
        if (mutexRowNum == 1) {
            for (i = 1; i < numCols; ++i) {
                try {
                    if (wrs.getColumnType(i) != 13) continue;
                    out.print("<input type=\"hidden\" name=\"");
                    out.print(wrs.getColumnLabel(i));
                    out.print("\" value=\"");
                    out.println("\" />");
                    continue;
                }
                catch (ColumnNotDisplayableException e) {
                    throw new IllegalStateException("Unexpected ColumnNotDisplayableException on MUTEX_CHECKBOX");
                }
            }
        }
        out.flush();
    }

    protected StringBuffer mutexBoxes(List mutexList, int mutexRowNum) {
        StringBuffer sb = new StringBuffer(40);
        ListIterator it = mutexList.listIterator();
        while (it.hasNext()) {
            String curVal = (String)it.next();
            sb.append("form.").append(curVal).append("[").append(mutexRowNum).append("].checked=false; ");
        }
        return sb;
    }

    @Override
    protected void getColumnFormatted(WebResultSet wrs, int i, StringBuffer contents, StringBuffer align) throws SQLException, NoRowidException, ColumnNotDisplayableException {
        int type = wrs.getColumnType(i);
        switch (type) {
            case 5: {
                if (wrs.getString(i) == null) break;
                align.append("center");
                contents.append("<input type=\"radio\" name=\"").append(wrs.getColumnLabel(i)).append("\" value=\"").append(wrs.getRowid()).append("\" onClick=\"");
                if (this.extraJavaScript[5] != null) {
                    contents.append(this.extraJavaScript[5]);
                }
                if (this.rowHighlightingOn) {
                    contents.append("; highlightRow(this, ").append("'00ff00',").append("'ff00ff'").append(")");
                }
                contents.append("; this.form.submit()\" />");
                break;
            }
            case 6: {
                align.append("center");
                if (wrs.getString(i) == null) break;
                contents.append("<input type=\"checkbox\" name=\"").append(wrs.getColumnLabel(i)).append("\" value=\"").append(wrs.getRowid()).append("\"");
                if (this.extraJavaScript[6] != null) {
                    contents.append(" onClick=\"").append(this.extraJavaScript[5]).append("\"");
                }
                if (wrs.getString(i).equals(this.checkboxYesValue)) {
                    contents.append(" checked");
                }
                contents.append(" />");
                break;
            }
            default: {
                super.getColumnFormatted(wrs, i, contents, align);
            }
        }
    }

    protected void outputHeaderRow(WebResultSet wrs, PrintWriter out) throws SQLException {
        StringBuffer sb = new StringBuffer();
        int numCols = wrs.getColumnCount();
        out.println(" <tr class=\"resultTableHeading\">");
        for (int i = 1; i <= numCols; ++i) {
            sb.setLength(0);
            int columnType = wrs.getColumnType(i);
            try {
                if (columnType == 12 || columnType == 10) continue;
                sb.append("  <th valign=\"bottom\">");
                sb.append(this.beautifyHeading(wrs.getColumnLabel(i)));
                sb.append("</th>");
                out.println(sb);
                continue;
            }
            catch (ColumnNotDisplayableException e) {
                // empty catch block
            }
        }
        out.println(" </tr>");
    }
}

