/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sqlobject;

import ca.sqlpower.object.SPVariableResolver;
import ca.sqlpower.sqlobject.SQLColumn;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class SQLCheckConstraintVariableResolver
implements SPVariableResolver {
    private final SQLColumn column;

    public SQLCheckConstraintVariableResolver(SQLColumn column) {
        this.column = column;
    }

    public SQLColumn getColumn() {
        return this.column;
    }

    @Override
    public void delete(String key) {
        throw new UnsupportedOperationException("The " + this.getClass().getName() + " does not support deleting variable values.");
    }

    @Override
    public String getNamespace() {
        return null;
    }

    @Override
    public String getUserFriendlyName() {
        return SQLColumn.class.getSimpleName() + " - " + this.column.getName();
    }

    @Override
    public Collection<String> keySet(String namespace) {
        if (namespace == null) {
            HashSet<String> variableNames = new HashSet<String>();
            for (SQLCheckConstraintVariable var : SQLCheckConstraintVariable.values()) {
                variableNames.add(var.getVariableName());
            }
            return variableNames;
        }
        return Collections.emptySet();
    }

    @Override
    public Collection<Object> matches(String key, String partialValue) {
        Object value = this.resolve(key);
        String stringValue = String.valueOf(value);
        if (stringValue != null && stringValue.startsWith(partialValue)) {
            return Collections.singleton(value);
        }
        return Collections.emptySet();
    }

    @Override
    public Object resolve(String key) {
        return this.resolve(key, null);
    }

    @Override
    public Object resolve(String key, Object defaultValue) {
        SQLCheckConstraintVariable variable = SQLCheckConstraintVariable.findVariable(key);
        if (variable == null) {
            return defaultValue;
        }
        return SQLCheckConstraintVariable.getVariableValue(this.column, variable.getVariableName());
    }

    @Override
    public Collection<Object> resolveCollection(String key) {
        Object value = this.resolve(key);
        if (value == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(value);
    }

    @Override
    public Collection<Object> resolveCollection(String key, Object defaultValue) {
        Object value = this.resolve(key);
        if (value == null) {
            return Collections.singleton(defaultValue);
        }
        return Collections.singleton(value);
    }

    @Override
    public boolean resolves(String key) {
        return SQLCheckConstraintVariable.findVariable(key) != null;
    }

    @Override
    public boolean resolvesNamespace(String namespace) {
        return namespace == null;
    }

    @Override
    public void store(String key, Object value) {
        throw new UnsupportedOperationException("The " + this.getClass().getName() + " does not support storing variable values.");
    }

    @Override
    public void update(String key, Object value) {
        throw new UnsupportedOperationException("The " + this.getClass().getName() + " does not support storing variable values.");
    }

    public static enum SQLCheckConstraintVariable {
        THIS("this");

        private final String variableName;

        private SQLCheckConstraintVariable(String variableName) {
            this.variableName = variableName;
        }

        public String getVariableName() {
            return this.variableName;
        }

        public static SQLCheckConstraintVariable findVariable(String variableName) {
            if (variableName != null) {
                for (SQLCheckConstraintVariable var : SQLCheckConstraintVariable.values()) {
                    if (!variableName.equals(var.getVariableName())) continue;
                    return var;
                }
            }
            return null;
        }

        public static Object getVariableValue(SQLColumn column, String variableName) {
            SQLCheckConstraintVariable var = SQLCheckConstraintVariable.findVariable(variableName);
            if (var == null) {
                return null;
            }
            switch (var) {
                case THIS: {
                    return column.getPhysicalName();
                }
            }
            return null;
        }
    }
}

