/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sqlobject;

import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.SPObjectNameComparator;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.object.annotation.Mutator;
import ca.sqlpower.object.annotation.NonProperty;
import ca.sqlpower.sqlobject.SQLCheckConstraint;
import ca.sqlpower.sqlobject.SQLCheckConstraintContainer;
import ca.sqlpower.sqlobject.SQLEnumeration;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLTypePhysicalPropertiesProvider;
import ca.sqlpower.util.SQLPowerUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SQLTypePhysicalProperties
extends SQLObject
implements SQLCheckConstraintContainer {
    private Integer precision;
    private Integer scale;
    private String defaultValue;
    private SQLTypeConstraint constraintType;
    private List<SQLCheckConstraint> checkConstraints = new ArrayList<SQLCheckConstraint>();
    private List<SQLEnumeration> enumerations = new ArrayList<SQLEnumeration>();
    private final String platform;
    private SQLTypePhysicalPropertiesProvider.PropertyType precisionType;
    private SQLTypePhysicalPropertiesProvider.PropertyType scaleType;
    public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.unmodifiableList(new ArrayList<Class>(Arrays.asList(SQLCheckConstraint.class, SQLEnumeration.class)));

    static final void copyProperties(SQLTypePhysicalProperties target, SQLTypePhysicalProperties source) {
        if (!SQLTypePhysicalProperties.areEqual(target, source)) {
            int compare;
            target.begin("Matching properties");
            target.setName(source.getName());
            target.setPhysicalName(source.getPhysicalName());
            target.setPrecision(source.getPrecision());
            target.setPrecisionType(source.getPrecisionType());
            target.setScale(source.getScale());
            target.setScaleType(source.getScaleType());
            target.setDefaultValue(source.getDefaultValue());
            target.setConstraintType(source.getConstraintType());
            ArrayList<SQLCheckConstraint> sourceCheckConstraints = new ArrayList<SQLCheckConstraint>(source.getCheckConstraints());
            ArrayList<SQLCheckConstraint> targetCheckConstraints = new ArrayList<SQLCheckConstraint>(target.getCheckConstraints());
            ArrayList<SQLEnumeration> sourceEnumerations = new ArrayList<SQLEnumeration>(source.getChildrenWithoutPopulating(SQLEnumeration.class));
            ArrayList<SQLEnumeration> targetEnumerations = new ArrayList<SQLEnumeration>(target.getChildrenWithoutPopulating(SQLEnumeration.class));
            SPObjectNameComparator nameComparator = new SPObjectNameComparator();
            Collections.sort(sourceCheckConstraints, nameComparator);
            Collections.sort(targetCheckConstraints, nameComparator);
            Collections.sort(sourceEnumerations, nameComparator);
            Collections.sort(targetEnumerations, nameComparator);
            int i = 0;
            int j = 0;
            while (i < sourceCheckConstraints.size() || j < targetCheckConstraints.size()) {
                SQLCheckConstraint targetConstraint;
                SQLCheckConstraint sourceConstraint;
                compare = 0;
                if (i < sourceCheckConstraints.size()) {
                    sourceConstraint = (SQLCheckConstraint)sourceCheckConstraints.get(i);
                } else {
                    sourceConstraint = null;
                    compare = 1;
                }
                if (j < targetCheckConstraints.size()) {
                    targetConstraint = (SQLCheckConstraint)targetCheckConstraints.get(i);
                } else {
                    targetConstraint = null;
                    compare = -1;
                }
                if (compare == 0) {
                    compare = nameComparator.compare(sourceConstraint, targetConstraint);
                }
                if (compare < 0) {
                    target.addCheckConstraint(new SQLCheckConstraint(sourceConstraint));
                    ++i;
                    continue;
                }
                if (compare > 0) {
                    target.removeCheckConstraint(targetConstraint);
                    ++j;
                    continue;
                }
                if (!sourceConstraint.getConstraint().equals(targetConstraint.getConstraint())) {
                    targetConstraint.setConstraint(sourceConstraint.getConstraint());
                }
                ++i;
                ++j;
            }
            i = 0;
            j = 0;
            while (i < sourceEnumerations.size() || j < targetEnumerations.size()) {
                SQLEnumeration targetEnumeration;
                SQLEnumeration sourceEnumeration;
                compare = 0;
                if (i < sourceEnumerations.size()) {
                    sourceEnumeration = (SQLEnumeration)sourceEnumerations.get(i);
                } else {
                    sourceEnumeration = null;
                    compare = 1;
                }
                if (j < targetEnumerations.size()) {
                    targetEnumeration = (SQLEnumeration)targetEnumerations.get(i);
                } else {
                    targetEnumeration = null;
                    compare = -1;
                }
                if (compare == 0) {
                    compare = nameComparator.compare(sourceEnumeration, targetEnumeration);
                }
                if (compare < 0) {
                    target.addEnumeration(new SQLEnumeration(sourceEnumeration));
                    ++i;
                    continue;
                }
                if (compare > 0) {
                    target.removeEnumeration(targetEnumeration);
                    ++j;
                    continue;
                }
                ++i;
                ++j;
            }
            target.commit();
        }
    }

    @Constructor
    public SQLTypePhysicalProperties(@ConstructorParameter(parameterType=ConstructorParameter.ParameterType.PROPERTY, propertyName="platform") String platformName) {
        this.platform = platformName;
        this.setName("SQLTypePhysicalProperties for " + this.platform);
    }

    public SQLTypePhysicalProperties(SQLTypePhysicalProperties properties) {
        this.platform = properties.getPlatform();
        this.updateToMatch(properties);
    }

    @Override
    protected void addChildImpl(SPObject child, int index) {
        if (child instanceof SQLCheckConstraint) {
            this.addCheckConstraint((SQLCheckConstraint)child, index);
        } else if (child instanceof SQLEnumeration) {
            this.addEnumeration((SQLEnumeration)child, index);
        } else {
            throw new IllegalArgumentException("The child " + child.getName() + " of type " + child.getClass() + " is not a valid child type of " + this.getClass() + ".");
        }
    }

    @Override
    public void addCheckConstraint(SQLCheckConstraint checkConstraint) {
        this.addCheckConstraint(checkConstraint, this.getChildrenWithoutPopulating(SQLCheckConstraint.class).size());
    }

    @Override
    public void addCheckConstraint(SQLCheckConstraint checkConstraint, int index) {
        this.checkConstraints.add(index, checkConstraint);
        checkConstraint.setParent(this);
        this.fireChildAdded(SQLCheckConstraint.class, checkConstraint, index);
    }

    public void addEnumeration(SQLEnumeration child) {
        this.addEnumeration(child, this.getChildrenWithoutPopulating(SQLEnumeration.class).size());
    }

    public void addEnumeration(SQLEnumeration child, int index) {
        this.enumerations.add(index, child);
        child.setParent(this);
        this.fireChildAdded(SQLEnumeration.class, child, index);
    }

    @Accessor
    public Integer getPrecision() {
        return this.precision;
    }

    @Mutator
    public void setPrecision(Integer precision) {
        this.begin("Setting precision.");
        Integer oldValue = this.precision;
        this.precision = precision;
        this.firePropertyChange("precision", oldValue, precision);
        this.commit();
    }

    @Accessor
    public Integer getScale() {
        return this.scale;
    }

    @Mutator
    public void setScale(Integer scale) {
        this.begin("Setting scale.");
        Integer oldValue = this.scale;
        this.scale = scale;
        this.firePropertyChange("scale", oldValue, scale);
        this.commit();
    }

    @Accessor
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Mutator
    public void setDefaultValue(String defaultValue) {
        this.begin("Setting default value.");
        String oldValue = this.defaultValue;
        this.defaultValue = defaultValue;
        this.firePropertyChange("defaultValue", oldValue, defaultValue);
        this.commit();
    }

    @Accessor
    public SQLTypeConstraint getConstraintType() {
        return this.constraintType;
    }

    @Mutator
    public void setConstraintType(SQLTypeConstraint constraint) {
        this.begin("Setting constraint type.");
        SQLTypeConstraint oldValue = this.constraintType;
        this.constraintType = constraint;
        this.firePropertyChange("constraintType", (Object)oldValue, (Object)this.constraintType);
        this.commit();
    }

    @Override
    public List<? extends SQLObject> getChildrenWithoutPopulating() {
        ArrayList<SQLObject> children = new ArrayList<SQLObject>();
        children.addAll(this.checkConstraints);
        children.addAll(this.enumerations);
        return Collections.unmodifiableList(children);
    }

    @Override
    public String getShortDisplayName() {
        return this.getName();
    }

    @Override
    protected void populateImpl() throws SQLObjectException {
    }

    @Override
    protected boolean removeChildImpl(SPObject child) {
        if (child instanceof SQLCheckConstraint) {
            return this.removeCheckConstraint((SQLCheckConstraint)child);
        }
        if (child instanceof SQLEnumeration) {
            return this.removeEnumeration((SQLEnumeration)child);
        }
        return false;
    }

    @Override
    public boolean removeCheckConstraint(SQLCheckConstraint child) {
        int index = this.checkConstraints.indexOf(child);
        if (index != -1) {
            this.checkConstraints.remove(index);
            this.fireChildRemoved(SQLCheckConstraint.class, child, index);
            child.setParent(null);
            return true;
        }
        return false;
    }

    public boolean removeEnumeration(SQLEnumeration child) {
        int index = this.enumerations.indexOf(child);
        if (index != -1) {
            this.enumerations.remove(index);
            this.fireChildRemoved(SQLEnumeration.class, child, index);
            child.setParent(null);
            return true;
        }
        return false;
    }

    @Override
    @NonProperty
    public List<Class<? extends SPObject>> getAllowedChildTypes() {
        return allowedChildTypes;
    }

    @Override
    public List<? extends SPObject> getDependencies() {
        return Collections.emptyList();
    }

    @Override
    public void removeDependency(SPObject dependency) {
    }

    @Accessor
    public String getPlatform() {
        return this.platform;
    }

    @Accessor
    public SQLTypePhysicalPropertiesProvider.PropertyType getPrecisionType() {
        return this.precisionType;
    }

    @Mutator
    public void setPrecisionType(SQLTypePhysicalPropertiesProvider.PropertyType precisionType) {
        this.begin("Setting precision type.");
        SQLTypePhysicalPropertiesProvider.PropertyType oldValue = this.precisionType;
        this.precisionType = precisionType;
        this.firePropertyChange("precisionType", (Object)oldValue, (Object)precisionType);
        this.commit();
    }

    @Accessor
    public SQLTypePhysicalPropertiesProvider.PropertyType getScaleType() {
        return this.scaleType;
    }

    @Mutator
    public void setScaleType(SQLTypePhysicalPropertiesProvider.PropertyType scaleType) {
        this.begin("Setting scale type.");
        SQLTypePhysicalPropertiesProvider.PropertyType oldValue = this.scaleType;
        this.scaleType = scaleType;
        this.firePropertyChange("scaleType", (Object)oldValue, (Object)scaleType);
        this.commit();
    }

    @Override
    public void updateToMatch(SQLObject matchMe) {
        if (!(matchMe instanceof SQLTypePhysicalProperties)) {
            throw new ClassCastException("Only " + SQLTypePhysicalProperties.class.getSimpleName() + " can be copied to " + SQLTypePhysicalProperties.class.getSimpleName() + ".");
        }
        SQLTypePhysicalProperties.copyProperties(this, (SQLTypePhysicalProperties)matchMe);
    }

    public static boolean areEqual(SQLTypePhysicalProperties prop1, SQLTypePhysicalProperties prop2) {
        SQLEnumeration enum2;
        SQLEnumeration enum1;
        int i;
        SQLCheckConstraint constraint2;
        SQLCheckConstraint constraint1;
        boolean equal = SQLPowerUtils.areEqual(prop1.getName(), prop2.getName()) && SQLPowerUtils.areEqual(prop1.getPhysicalName(), prop2.getPhysicalName()) && SQLPowerUtils.areEqual(prop1.getPrecision(), prop2.getPrecision()) && SQLPowerUtils.areEqual((Object)prop1.getPrecisionType(), (Object)prop2.getPrecisionType()) && SQLPowerUtils.areEqual(prop1.getScale(), prop2.getScale()) && SQLPowerUtils.areEqual((Object)prop1.getScaleType(), (Object)prop2.getScaleType()) && SQLPowerUtils.areEqual(prop1.getDefaultValue(), prop2.getDefaultValue()) && SQLPowerUtils.areEqual((Object)prop1.getConstraintType(), (Object)prop2.getConstraintType());
        equal &= prop1.getCheckConstraints().size() == prop2.getCheckConstraints().size();
        if (!(equal &= prop1.getChildrenWithoutPopulating(SQLEnumeration.class).size() == prop2.getChildrenWithoutPopulating(SQLEnumeration.class).size())) {
            return false;
        }
        ArrayList<SQLCheckConstraint> checkConstraints1 = new ArrayList<SQLCheckConstraint>(prop1.getCheckConstraints());
        ArrayList<SQLCheckConstraint> checkConstraints2 = new ArrayList<SQLCheckConstraint>(prop2.getCheckConstraints());
        ArrayList<SQLEnumeration> enumerations1 = new ArrayList<SQLEnumeration>(prop1.getChildrenWithoutPopulating(SQLEnumeration.class));
        ArrayList<SQLEnumeration> enumerations2 = new ArrayList<SQLEnumeration>(prop2.getChildrenWithoutPopulating(SQLEnumeration.class));
        SPObjectNameComparator nameComparator = new SPObjectNameComparator();
        Collections.sort(checkConstraints1, nameComparator);
        Collections.sort(checkConstraints2, nameComparator);
        for (i = 0; i < checkConstraints1.size() && equal; equal &= SQLPowerUtils.areEqual(constraint1.getConstraint(), constraint2.getConstraint()), ++i) {
            constraint1 = (SQLCheckConstraint)checkConstraints1.get(i);
            constraint2 = (SQLCheckConstraint)checkConstraints2.get(i);
            equal &= SQLPowerUtils.areEqual(constraint1.getName(), constraint2.getName());
        }
        if (!equal) {
            return false;
        }
        Collections.sort(enumerations1, nameComparator);
        Collections.sort(enumerations2, nameComparator);
        for (i = 0; i < enumerations1.size() && equal; equal &= SQLPowerUtils.areEqual(enum1.getName(), enum2.getName()), ++i) {
            enum1 = (SQLEnumeration)enumerations1.get(i);
            enum2 = (SQLEnumeration)enumerations2.get(i);
        }
        return equal;
    }

    @Override
    @NonProperty
    public List<SQLCheckConstraint> getCheckConstraints() {
        return this.getChildrenWithoutPopulating(SQLCheckConstraint.class);
    }

    public static enum SQLTypeConstraint {
        NONE,
        CHECK,
        ENUM;

    }
}

