/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sqlobject;

import ca.sqlpower.object.ObjectDependentException;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.object.annotation.Mutator;
import ca.sqlpower.object.annotation.NonProperty;
import ca.sqlpower.object.annotation.Transient;
import ca.sqlpower.sqlobject.SQLCheckConstraint;
import ca.sqlpower.sqlobject.SQLEnumeration;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLTypePhysicalProperties;
import ca.sqlpower.sqlobject.SQLTypePhysicalPropertiesProvider;
import ca.sqlpower.util.SQLPowerUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class UserDefinedSQLType
extends SQLObject
implements SQLTypePhysicalPropertiesProvider {
    public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.singletonList(SQLTypePhysicalProperties.class);
    private UserDefinedSQLType upstreamType;
    private SQLTypePhysicalPropertiesProvider.BasicSQLType basicType;
    private final SQLTypePhysicalProperties defaultPhysicalProperties;
    private List<SQLTypePhysicalProperties> overridingPhysicalProperties = new ArrayList<SQLTypePhysicalProperties>();
    private String description;
    private Integer type;
    private Integer myNullability;
    private Boolean myAutoIncrement;

    public UserDefinedSQLType() {
        this("UserDefinedSQLType", null, null, null, null, new SQLTypePhysicalProperties("GENERIC"));
    }

    @Constructor
    public UserDefinedSQLType(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="myNullability") Integer nullability, @ConstructorParameter(propertyName="myAutoIncrement") Boolean autoIncrement, @ConstructorParameter(propertyName="basicType") SQLTypePhysicalPropertiesProvider.BasicSQLType basicType, @ConstructorParameter(propertyName="upstreamType") UserDefinedSQLType upstreamType, @ConstructorParameter(parameterType=ConstructorParameter.ParameterType.CHILD, propertyName="primaryKeyIndex") SQLTypePhysicalProperties defaultPhysicalProperties) {
        this.defaultPhysicalProperties = defaultPhysicalProperties;
        this.setName(name);
        defaultPhysicalProperties.setParent(this);
        this.setPopulated(true);
        this.setMyNullability(nullability);
        this.setMyAutoIncrement(autoIncrement);
        this.setBasicType(basicType);
        this.setUpstreamType(upstreamType);
    }

    @NonProperty
    public SQLTypePhysicalProperties getPhysicalProperties(String platformName) {
        if (!"GENERIC".equals(platformName)) {
            for (SQLTypePhysicalProperties properties : this.overridingPhysicalProperties) {
                if (!properties.getPlatform().equals(platformName)) continue;
                return properties;
            }
        }
        return this.defaultPhysicalProperties;
    }

    @Override
    public List<? extends SQLObject> getChildrenWithoutPopulating() {
        ArrayList<SQLTypePhysicalProperties> properties = new ArrayList<SQLTypePhysicalProperties>();
        properties.add(this.defaultPhysicalProperties);
        properties.addAll(this.overridingPhysicalProperties);
        return Collections.unmodifiableList(properties);
    }

    @Override
    public String getShortDisplayName() {
        return this.getName();
    }

    @Override
    protected void populateImpl() throws SQLObjectException {
    }

    @Override
    protected boolean removeChildImpl(SPObject child) {
        int childIndex = this.overridingPhysicalProperties.indexOf(child);
        boolean removedFromList = this.overridingPhysicalProperties.remove(child);
        if (child != null && removedFromList) {
            this.fireChildRemoved(SQLTypePhysicalProperties.class, child, childIndex + 1);
            child.setParent(null);
            return true;
        }
        return false;
    }

    @Override
    public List<Class<? extends SPObject>> getAllowedChildTypes() {
        return allowedChildTypes;
    }

    @Override
    public List<? extends SPObject> getDependencies() {
        return Collections.singletonList(this.getUpstreamType());
    }

    @Override
    public void removeDependency(SPObject dependency) {
        if (dependency == this.getUpstreamType()) {
            this.setUpstreamType(null);
        }
    }

    @Mutator
    public void setBasicType(SQLTypePhysicalPropertiesProvider.BasicSQLType basicType) {
        this.begin("Setting basic type.");
        SQLTypePhysicalPropertiesProvider.BasicSQLType oldValue = this.basicType;
        this.basicType = basicType;
        this.firePropertyChange("basicType", (Object)oldValue, (Object)basicType);
        if (this.getType() == null) {
            this.setType(SQLTypePhysicalPropertiesProvider.BasicSQLType.convertFromBasicSQLType(basicType));
        }
        this.commit();
    }

    @Accessor
    public SQLTypePhysicalPropertiesProvider.BasicSQLType getBasicType() {
        if (this.basicType == null && this.upstreamType != null) {
            return this.upstreamType.getBasicType();
        }
        return this.basicType;
    }

    @Override
    @NonProperty
    public List<SQLCheckConstraint> getCheckConstraints(String platform) {
        List<SQLCheckConstraint> checkConstraints = null;
        SQLTypePhysicalProperties properties = this.getPhysicalProperties(platform);
        if (properties != null) {
            checkConstraints = properties.getCheckConstraints();
            if (checkConstraints.isEmpty() && this.getUpstreamType() != null) {
                checkConstraints = this.getUpstreamType().getCheckConstraints(platform);
            }
        } else {
            checkConstraints = this.getUpstreamType() != null ? this.getUpstreamType().getCheckConstraints(platform) : Collections.emptyList();
        }
        return Collections.unmodifiableList(checkConstraints);
    }

    @Override
    @NonProperty
    public SQLTypePhysicalProperties.SQLTypeConstraint getConstraintType(String platform) {
        SQLTypePhysicalProperties.SQLTypeConstraint constraintType = null;
        SQLTypePhysicalProperties properties = this.getPhysicalProperties(platform);
        if (properties != null) {
            constraintType = properties.getConstraintType();
            if (constraintType == null && this.getUpstreamType() != null) {
                constraintType = this.getUpstreamType().getConstraintType(platform);
            }
        } else if (this.getUpstreamType() != null) {
            constraintType = this.getUpstreamType().getConstraintType(platform);
        }
        return constraintType;
    }

    @Override
    @NonProperty
    public String getDefaultValue(String platform) {
        String defaultValue = null;
        SQLTypePhysicalProperties properties = this.getPhysicalProperties(platform);
        if (properties != null) {
            defaultValue = properties.getDefaultValue();
            if (defaultValue == null && this.getUpstreamType() != null) {
                defaultValue = this.getUpstreamType().getDefaultValue(platform);
            }
        } else if (this.getUpstreamType() != null) {
            defaultValue = this.getUpstreamType().getDefaultValue(platform);
        }
        return defaultValue;
    }

    @Override
    @NonProperty
    public List<SQLEnumeration> getEnumerations(String platform) {
        List<SQLEnumeration> enumerations = null;
        SQLTypePhysicalProperties properties = this.getPhysicalProperties(platform);
        if (properties != null) {
            enumerations = properties.getChildren(SQLEnumeration.class);
            if (enumerations.isEmpty() && this.getUpstreamType() != null) {
                enumerations = this.getUpstreamType().getEnumerations(platform);
            }
        } else {
            enumerations = this.getUpstreamType() != null ? this.getUpstreamType().getEnumerations(platform) : Collections.emptyList();
        }
        return Collections.unmodifiableList(enumerations);
    }

    @Override
    @NonProperty
    public int getPrecision(String platform) {
        Integer precision = null;
        if (this.getPrecisionType(platform) != SQLTypePhysicalPropertiesProvider.PropertyType.NOT_APPLICABLE) {
            SQLTypePhysicalProperties properties = this.getPhysicalProperties(platform);
            if (properties != null) {
                precision = properties.getPrecision();
                if (this.getUpstreamType() != null && (precision == null || this.getUpstreamType().getPrecisionType(platform) == SQLTypePhysicalPropertiesProvider.PropertyType.CONSTANT)) {
                    precision = this.getUpstreamType().getPrecision(platform);
                }
            } else if (this.getUpstreamType() != null) {
                precision = this.getUpstreamType().getPrecision(platform);
            }
        }
        return precision == null ? 0 : precision;
    }

    @Override
    @NonProperty
    public int getScale(String platform) {
        Integer scale = null;
        if (this.getScaleType(platform) != SQLTypePhysicalPropertiesProvider.PropertyType.NOT_APPLICABLE) {
            SQLTypePhysicalProperties properties = this.getPhysicalProperties(platform);
            if (properties != null) {
                scale = properties.getScale();
                if (this.getUpstreamType() != null && (scale == null || this.getUpstreamType().getScaleType(platform) == SQLTypePhysicalPropertiesProvider.PropertyType.CONSTANT)) {
                    scale = this.getUpstreamType().getScale(platform);
                }
            } else if (this.getUpstreamType() != null) {
                scale = this.getUpstreamType().getScale(platform);
            }
        }
        return scale == null ? 0 : scale;
    }

    @Override
    @Accessor
    public Integer getType() {
        if (this.type == null && this.upstreamType != null) {
            return this.upstreamType.getType();
        }
        return this.type;
    }

    @Override
    public void addCheckConstraint(String platform, SQLCheckConstraint checkConstraint) {
        this.getOrCreatePhysicalProperties(platform).addCheckConstraint(checkConstraint);
    }

    public void addCheckConstraint(String platform, SQLCheckConstraint checkConstraint, int index) {
        this.getOrCreatePhysicalProperties(platform).addCheckConstraint(checkConstraint, index);
    }

    @Override
    public boolean removeCheckConstraint(String platform, SQLCheckConstraint checkConstraint) {
        return this.getOrCreatePhysicalProperties(platform).removeCheckConstraint(checkConstraint);
    }

    @Override
    @NonProperty
    public void setConstraintType(String platform, SQLTypePhysicalProperties.SQLTypeConstraint constraint) {
        this.getOrCreatePhysicalProperties(platform).setConstraintType(constraint);
    }

    @Override
    @NonProperty
    public void setDefaultValue(String platform, String defaultValue) {
        this.getOrCreatePhysicalProperties(platform).setDefaultValue(defaultValue);
    }

    @Override
    @NonProperty
    public void addEnumeration(String platform, SQLEnumeration enumeration) {
        this.getOrCreatePhysicalProperties(platform).addEnumeration(enumeration);
    }

    public void addEnumeration(String platform, SQLEnumeration enumeration, int index) {
        this.getOrCreatePhysicalProperties(platform).addEnumeration(enumeration, index);
    }

    @NonProperty
    public void setPhysicalTypeName(String platform, String name) {
        this.getOrCreatePhysicalProperties(platform).setName(name);
    }

    @Override
    @NonProperty
    public void setPrecision(String platform, Integer precision) {
        this.getOrCreatePhysicalProperties(platform).setPrecision(precision);
    }

    @Override
    @NonProperty
    public void setScale(String platform, Integer scale) {
        this.getOrCreatePhysicalProperties(platform).setScale(scale);
    }

    @Override
    @Mutator
    public void setType(Integer type) {
        this.begin("Setting type.");
        Integer oldValue = this.getType();
        this.type = type;
        this.firePropertyChange("type", oldValue, type);
        this.commit();
    }

    @Override
    @NonProperty
    public SQLTypePhysicalPropertiesProvider.PropertyType getPrecisionType(String platform) {
        SQLTypePhysicalPropertiesProvider.PropertyType precisionType = null;
        SQLTypePhysicalProperties properties = this.getPhysicalProperties(platform);
        if (properties != null) {
            precisionType = properties.getPrecisionType();
            if (precisionType == null && this.getUpstreamType() != null) {
                precisionType = this.getUpstreamType().getPrecisionType(platform);
            }
        } else if (this.getUpstreamType() != null) {
            precisionType = this.getUpstreamType().getPrecisionType(platform);
        }
        if (precisionType == null) {
            precisionType = SQLTypePhysicalPropertiesProvider.PropertyType.NOT_APPLICABLE;
        }
        return precisionType;
    }

    @Override
    @NonProperty
    public SQLTypePhysicalPropertiesProvider.PropertyType getScaleType(String platform) {
        SQLTypePhysicalPropertiesProvider.PropertyType scaleType = null;
        SQLTypePhysicalProperties properties = this.getPhysicalProperties(platform);
        if (properties != null) {
            scaleType = properties.getScaleType();
            if (scaleType == null && this.getUpstreamType() != null) {
                scaleType = this.getUpstreamType().getScaleType(platform);
            }
        } else if (this.getUpstreamType() != null) {
            scaleType = this.getUpstreamType().getScaleType(platform);
        }
        if (scaleType == null) {
            scaleType = SQLTypePhysicalPropertiesProvider.PropertyType.NOT_APPLICABLE;
        }
        return scaleType;
    }

    @Override
    @NonProperty
    public void setPrecisionType(String platform, SQLTypePhysicalPropertiesProvider.PropertyType precisionType) {
        this.getOrCreatePhysicalProperties(platform).setPrecisionType(precisionType);
    }

    @Override
    @NonProperty
    public void setScaleType(String platform, SQLTypePhysicalPropertiesProvider.PropertyType scaleType) {
        this.getOrCreatePhysicalProperties(platform).setScaleType(scaleType);
    }

    @Mutator
    public void setMyDescription(String myDescription) {
        String oldValue = this.description;
        this.description = myDescription;
        this.firePropertyChange("myDescription", oldValue, this.description);
    }

    @Accessor
    public String getMyDescription() {
        return this.description;
    }

    @Transient
    @Accessor
    public String getDescription() {
        if (this.description == null && this.upstreamType != null) {
            return this.upstreamType.getDescription();
        }
        return this.description;
    }

    private SQLTypePhysicalProperties getOrCreatePhysicalProperties(String platform) {
        SQLTypePhysicalProperties properties = this.getPhysicalProperties(platform);
        if (properties == null) {
            properties = new SQLTypePhysicalProperties(platform);
            properties.setName(this.getName());
            this.putPhysicalProperties(platform, properties);
        }
        return properties;
    }

    @Mutator
    public void setUpstreamType(UserDefinedSQLType upstreamType) {
        this.begin("setting upstream type");
        UserDefinedSQLType oldValue = this.upstreamType;
        this.upstreamType = upstreamType;
        this.firePropertyChange("upstreamType", oldValue, upstreamType);
        if (upstreamType != null) {
            for (String platform : this.platforms()) {
                SQLTypePhysicalProperties upstreamProperties = upstreamType.getPhysicalProperties(platform);
                if (upstreamProperties == null) continue;
                SQLTypePhysicalProperties physicalProperties = this.getPhysicalProperties(platform);
                physicalProperties.setName(upstreamProperties.getName());
                if (upstreamProperties.getPrecisionType() != SQLTypePhysicalPropertiesProvider.PropertyType.VARIABLE) {
                    physicalProperties.setPrecision(null);
                    physicalProperties.setPrecisionType(null);
                }
                if (upstreamProperties.getScaleType() == SQLTypePhysicalPropertiesProvider.PropertyType.VARIABLE) continue;
                physicalProperties.setScale(null);
                physicalProperties.setScaleType(null);
            }
            this.setType(upstreamType.getType());
        }
        this.commit();
    }

    @Accessor
    public UserDefinedSQLType getUpstreamType() {
        return this.upstreamType;
    }

    public void putPhysicalProperties(String platform, SQLTypePhysicalProperties properties) {
        if (platform.equals("GENERIC")) {
            throw new IllegalArgumentException("The SQLTypePhysicalProperties object for GENERIC cannot be overwritten. Instead, use getDefaultPhysicalProperties and modify its properties");
        }
        SQLTypePhysicalProperties oldProperties = this.getPhysicalProperties(platform);
        this.overridingPhysicalProperties.add(properties);
        int index = this.overridingPhysicalProperties.indexOf(properties) + 1;
        properties.setParent(this);
        this.fireChildAdded(SQLTypePhysicalProperties.class, properties, index);
        if (oldProperties != null && oldProperties != this.defaultPhysicalProperties) {
            int oldIndex = this.overridingPhysicalProperties.indexOf(oldProperties);
            this.overridingPhysicalProperties.remove(oldProperties);
            this.fireChildRemoved(SQLTypePhysicalProperties.class, oldProperties, oldIndex);
            oldProperties.setParent(null);
        }
    }

    @Override
    protected void addChildImpl(SPObject child, int index) {
        if (child instanceof SQLTypePhysicalProperties) {
            SQLTypePhysicalProperties newProperties = (SQLTypePhysicalProperties)child;
            if (newProperties == this.defaultPhysicalProperties) {
                return;
            }
            if (index == 0) {
                throw new IllegalArgumentException("Cannot insert child " + child.getName() + " at index 0 for " + this.getName() + ", " + "as this is where the default physical properties must always be.");
            }
            SQLTypePhysicalProperties oldProperties = this.getPhysicalProperties(newProperties.getPlatform());
            this.overridingPhysicalProperties.add(index - 1, newProperties);
            newProperties.setParent(this);
            this.fireChildAdded(SQLTypePhysicalProperties.class, newProperties, index);
            if (oldProperties != null && oldProperties != this.defaultPhysicalProperties) {
                int oldIndex = this.overridingPhysicalProperties.indexOf(oldProperties);
                this.overridingPhysicalProperties.remove(oldProperties);
                this.fireChildRemoved(SQLTypePhysicalProperties.class, oldProperties, oldIndex);
                oldProperties.setParent(null);
            }
        } else {
            throw new IllegalArgumentException("Children Must be of type SQLTypePhysicalProperties");
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    @Mutator
    public void setMyNullability(Integer nullability) {
        this.begin("Setting myNullability.");
        Integer oldValue = this.getMyNullability();
        this.myNullability = nullability;
        this.firePropertyChange("myNullability", oldValue, nullability);
        this.commit();
    }

    @Override
    @Transient
    @Accessor
    public Integer getNullability() {
        if (this.myNullability == null && this.upstreamType != null) {
            return this.upstreamType.getNullability();
        }
        return this.myNullability;
    }

    @Accessor
    public Integer getMyNullability() {
        return this.myNullability;
    }

    @Override
    @Mutator
    public void setMyAutoIncrement(Boolean autoIncrement) {
        this.begin("Setting myAutoIncrement.");
        Boolean oldValue = this.getMyAutoIncrement();
        this.myAutoIncrement = autoIncrement;
        this.firePropertyChange("myAutoIncrement", oldValue, autoIncrement);
        this.commit();
    }

    @Override
    @Transient
    @Accessor
    public Boolean getAutoIncrement() {
        return this.myAutoIncrement == null && this.upstreamType != null ? this.upstreamType.getAutoIncrement() : this.myAutoIncrement;
    }

    @Accessor
    public Boolean getMyAutoIncrement() {
        return this.myAutoIncrement;
    }

    public List<String> platforms() {
        ArrayList<String> platforms = new ArrayList<String>();
        for (SQLTypePhysicalProperties properties : this.overridingPhysicalProperties) {
            platforms.add(properties.getPlatform());
        }
        platforms.add(this.defaultPhysicalProperties.getPlatform());
        return platforms;
    }

    public static boolean areEqual(UserDefinedSQLType udt1, UserDefinedSQLType udt2) {
        HashSet<String> oldPlatforms = new HashSet<String>(udt1.platforms());
        HashSet<String> newPlatforms = new HashSet<String>(udt2.platforms());
        String defaultPlatform = udt1.getDefaultPhysicalProperties().getPlatform();
        boolean equal = SQLTypePhysicalProperties.areEqual(udt1.getDefaultPhysicalProperties(), udt2.getDefaultPhysicalProperties());
        if (!equal) {
            return false;
        }
        oldPlatforms.remove(defaultPlatform);
        newPlatforms.remove(defaultPlatform);
        boolean bl = equal = SQLPowerUtils.areEqual(udt1.getName(), udt2.getName()) && SQLPowerUtils.areEqual(udt1.type, udt2.type) && SQLPowerUtils.areEqual(udt1.myNullability, udt2.myNullability) && SQLPowerUtils.areEqual(udt1.myAutoIncrement, udt2.myAutoIncrement) && SQLPowerUtils.areEqual(udt1.description, udt2.description) && SQLPowerUtils.areEqual((Object)udt1.basicType, (Object)udt2.basicType) && (udt1.getUpstreamType() == null && udt2.getUpstreamType() == null || udt1.getUpstreamType() != null && udt2.getUpstreamType() != null && UserDefinedSQLType.areEqual(udt1.getUpstreamType(), udt2.getUpstreamType())) && SQLPowerUtils.areEqual(oldPlatforms.size(), newPlatforms.size()) && oldPlatforms.containsAll(newPlatforms);
        if (equal) {
            for (String platform : oldPlatforms) {
                SQLTypePhysicalProperties newProperties;
                SQLTypePhysicalProperties oldProperties = udt1.getPhysicalProperties(platform);
                if (SQLTypePhysicalProperties.areEqual(oldProperties, newProperties = udt2.getPhysicalProperties(platform))) continue;
                return false;
            }
        }
        return equal;
    }

    @Override
    public void updateToMatch(SQLObject matchMe) {
        if (!(matchMe instanceof UserDefinedSQLType)) {
            throw new ClassCastException("Only " + UserDefinedSQLType.class.getSimpleName() + " can be copied to " + UserDefinedSQLType.class.getSimpleName() + ".");
        }
        UserDefinedSQLType.copyProperties(this, (UserDefinedSQLType)matchMe);
    }

    @Transient
    @Accessor
    public SQLTypePhysicalProperties getDefaultPhysicalProperties() {
        return this.defaultPhysicalProperties;
    }

    public static final void copyProperties(UserDefinedSQLType target, UserDefinedSQLType source) {
        if (!UserDefinedSQLType.areEqual(target, source)) {
            target.begin("Copying UserDefinedSQLType");
            target.setUpstreamType(source.getUpstreamType());
            target.setName(source.getName());
            target.setPhysicalName(source.getPhysicalName());
            target.setMyAutoIncrement(source.myAutoIncrement);
            target.setBasicType(source.basicType);
            target.setMyDescription(source.description);
            target.setMyNullability(source.myNullability);
            target.setType(source.type);
            SQLTypePhysicalProperties.copyProperties(target.getDefaultPhysicalProperties(), source.getDefaultPhysicalProperties());
            ArrayList<String> sourcePlatforms = new ArrayList<String>(source.platforms());
            ArrayList<String> targetPlatforms = new ArrayList<String>(target.platforms());
            sourcePlatforms.remove(source.getDefaultPhysicalProperties().getPlatform());
            targetPlatforms.remove(target.getDefaultPhysicalProperties().getPlatform());
            Collections.sort(sourcePlatforms);
            Collections.sort(targetPlatforms);
            int i = 0;
            int j = 0;
            while (i < sourcePlatforms.size() || j < targetPlatforms.size()) {
                String targetPlatform;
                String sourcePlatform;
                int compare = 0;
                if (i < sourcePlatforms.size()) {
                    sourcePlatform = (String)sourcePlatforms.get(i);
                } else {
                    sourcePlatform = null;
                    compare = 1;
                }
                if (j < targetPlatforms.size()) {
                    targetPlatform = (String)targetPlatforms.get(j);
                } else {
                    targetPlatform = null;
                    compare = -1;
                }
                if (compare == 0) {
                    compare = sourcePlatform.compareTo(targetPlatform);
                }
                if (compare < 0) {
                    try {
                        target.addChild(new SQLTypePhysicalProperties(source.getPhysicalProperties(sourcePlatform)));
                    }
                    catch (SQLObjectException e) {
                        target.rollback("Could not copy UserDefinedSQLType");
                        throw new IllegalStateException("Could not add new SQLTypePhysicalProperties for platform " + sourcePlatform + " to UserDefinedSQLType " + target.getPhysicalName() + " in copyProperties.");
                    }
                    ++i;
                    continue;
                }
                if (compare > 0) {
                    try {
                        target.removeChild(target.getPhysicalProperties(targetPlatform));
                    }
                    catch (IllegalArgumentException e) {
                        target.rollback("Could not copy UserDefinedSQLType");
                        throw new IllegalStateException("Could not remove SQLTypePhysicalProperties for platform " + targetPlatform + " from UserDefinedSQLType " + target.getPhysicalName());
                    }
                    catch (ObjectDependentException e) {
                        target.rollback("Could not copy UserDefinedSQLType");
                        throw new IllegalStateException("Could not remove SQLTypePhysicalProperties for platform " + targetPlatform + " from UserDefinedSQLType " + target.getPhysicalName());
                    }
                    ++j;
                    continue;
                }
                target.getPhysicalProperties(targetPlatform).updateToMatch(source.getPhysicalProperties(sourcePlatform));
                ++i;
                ++j;
            }
            target.commit();
        }
    }

    @NonProperty
    public String getPhysicalName(String platform) {
        String physicalName = null;
        SQLTypePhysicalProperties properties = this.getPhysicalProperties(platform);
        if (properties != null) {
            physicalName = properties.getName();
            if (physicalName == null && this.getUpstreamType() != null) {
                physicalName = this.getUpstreamType().getPhysicalName(platform);
            }
        } else if (this.getUpstreamType() != null) {
            physicalName = this.getUpstreamType().getPhysicalName(platform);
        }
        return physicalName;
    }

    @Override
    @Mutator
    public void setName(String name) {
        this.begin("Setting name");
        super.setName(name);
        this.defaultPhysicalProperties.setName(name);
        this.commit();
    }

    @Override
    public void removeEnumeration(String platform, SQLEnumeration enumeration) {
        this.getOrCreatePhysicalProperties(platform).removeEnumeration(enumeration);
    }
}

