/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui;

import java.awt.Color;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;

public class DocumentAppender
extends AppenderSkeleton {
    private final Document doc;
    private boolean setLimit;
    private int limit;
    private final SimpleAttributeSet attributes = new SimpleAttributeSet();

    public DocumentAppender(Document doc, boolean setLimit, int limit) {
        this.doc = doc;
        this.setLimit = setLimit;
        this.limit = limit;
        StyleConstants.setForeground(this.attributes, Color.BLACK);
        this.layout = new PatternLayout("%d %p %m\n");
    }

    protected void append(LoggingEvent evt) {
        try {
            String[] throwableStrRep;
            this.doc.insertString(this.doc.getLength(), this.layout.format(evt), this.attributes);
            if (this.layout.ignoresThrowable() && (throwableStrRep = evt.getThrowableStrRep()) != null) {
                for (String traceElem : throwableStrRep) {
                    this.doc.insertString(this.doc.getLength(), traceElem + "\n", this.attributes);
                }
            }
            if (this.setLimit && this.doc.getLength() + 25 >= this.limit) {
                int newlineposition = this.doc.getText(0, this.doc.getLength() - 1).indexOf("\n", 25);
                this.doc.remove(0, newlineposition);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return true;
    }
}

