/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class Arrow
implements Icon {
    private boolean descending;
    private int size;
    private int priority;
    private final int xShift;
    private final int yShift;

    public Arrow(boolean descending, int size, int priority, int xShift, int yShift) {
        this.descending = descending;
        this.size = size;
        this.priority = priority;
        this.xShift = xShift;
        this.yShift = yShift;
    }

    public Arrow(boolean descending, int size, int priority) {
        this(descending, size, priority, 0, 0);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Color color = c == null ? Color.GRAY : c.getBackground();
        int dx = (int)((double)(this.size / 2) * Math.pow(0.8, this.priority));
        int dy = this.descending ? dx : -dx;
        y = y + 5 * this.size / 6 + (this.descending ? -dy : 0);
        int shift = this.descending ? 1 : -1;
        g.translate(x + this.xShift, y + this.yShift);
        g.setColor(color.darker());
        g.fillPolygon(new int[]{dx, 0, dx / 2}, new int[]{0, 0, dy + shift}, 3);
        g.setColor(color);
        g.translate(-x - this.xShift, -y - this.yShift);
    }

    @Override
    public int getIconWidth() {
        return this.size;
    }

    @Override
    public int getIconHeight() {
        return this.size;
    }
}

