/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.table;

import au.com.bytecode.opencsv.CSVWriter;
import ca.sqlpower.swingui.table.ExportFormatter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableModel;

public class TableModelCSVFormatter
implements ExportFormatter {
    private final Map<Integer, Format> columnFormatters = new HashMap<Integer, Format>();

    public void setFormatter(int column, Format formatter) {
        this.columnFormatters.put(column, formatter);
    }

    @Override
    public void formatToStream(TableModel model, PrintWriter writer) {
        int[] allRows = new int[model.getRowCount()];
        for (int i = 0; i < model.getRowCount(); ++i) {
            allRows[i] = i;
        }
        this.formatToStream(model, writer, allRows);
    }

    @Override
    public void formatToStream(TableModel model, PrintWriter writer, int[] selectedRows) {
        try {
            CSVWriter csvWriter = new CSVWriter((Writer)writer);
            ArrayList<String[]> tableExport = new ArrayList<String[]>();
            int columnCount = model.getColumnCount();
            String[] rowArray = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                rowArray[i] = model.getColumnName(i);
            }
            tableExport.add(rowArray);
            for (int row = 0; row < selectedRows.length; ++row) {
                rowArray = new String[columnCount];
                for (int col = 0; col < columnCount; ++col) {
                    Object value = model.getValueAt(selectedRows[row], col);
                    if (value != null) {
                        if (this.columnFormatters.get(col) != null) {
                            rowArray[col] = this.columnFormatters.get(col).format(value);
                            continue;
                        }
                        rowArray[col] = value.toString();
                        continue;
                    }
                    rowArray[col] = "";
                }
                tableExport.add(rowArray);
            }
            csvWriter.writeAll(tableExport);
            csvWriter.close();
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not close the CSV Writer", ex);
        }
    }
}

