/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.testutil;

import ca.sqlpower.testutil.MockJDBCConnection;
import ca.sqlpower.testutil.MockJDBCResultSet;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class MockJDBCDatabaseMetaData
implements DatabaseMetaData {
    private static final Logger logger = Logger.getLogger(MockJDBCDatabaseMetaData.class);
    private MockJDBCConnection connection;

    MockJDBCDatabaseMetaData(MockJDBCConnection connection) {
        this.connection = connection;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public String getURL() throws SQLException {
        return this.connection.getURL();
    }

    @Override
    public String getUserName() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "SQL Power Mock JDBC Database";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return "0.0";
    }

    @Override
    public String getDriverName() throws SQLException {
        return "SQL Power Mock JDBC Database Driver";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return "0.0";
    }

    @Override
    public int getDriverMajorVersion() {
        return 0;
    }

    @Override
    public int getDriverMinorVersion() {
        return 0;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public String getStringFunctions() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return this.connection.getProperties().getProperty("dbmd.schemaTerm");
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return this.connection.getProperties().getProperty("dbmd.catalogTerm");
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        if (this.getCatalogTerm() == null) {
            throw new SQLException("Catalogs are not supported");
        }
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getMaxConnections() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getMaxStatements() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public ResultSet getTables(String catalogNamePattern, String schemaNamePattern, String tableNamePattern, String[] types) throws SQLException {
        String NO_CATALOG = "no_catalog";
        MockJDBCResultSet rs = new MockJDBCResultSet(null, 10);
        rs.setColumnName(1, "TABLE_CAT");
        rs.setColumnName(2, "TABLE_SCHEM");
        rs.setColumnName(3, "TABLE_NAME");
        rs.setColumnName(4, "TABLE_TYPE");
        rs.setColumnName(5, "REMARKS");
        rs.setColumnName(6, "TYPE_CAT");
        rs.setColumnName(7, "TYPE_SCHEM");
        rs.setColumnName(8, "TYPE_NAME");
        rs.setColumnName(9, "SELF_REFERENCING_COL_NAME");
        rs.setColumnName(10, "REF_GENERATION");
        Pattern catalogPattern = this.createPatternFromSQLWildcard(catalogNamePattern);
        Pattern schemaPattern = this.createPatternFromSQLWildcard(schemaNamePattern);
        Pattern tablePattern = this.createPatternFromSQLWildcard(tableNamePattern);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getTables: Searching for:");
            logger.debug((Object)("    catalog '" + catalogNamePattern + "' (pattern " + catalogPattern + ")"));
            logger.debug((Object)("     schema '" + schemaNamePattern + "' (pattern " + schemaPattern + ")"));
            logger.debug((Object)("      table '" + tableNamePattern + "' (pattern " + tablePattern + ")"));
        }
        ArrayList<String> catalogs = new ArrayList<String>();
        if (this.getCatalogTerm() != null) {
            String catalogList = this.connection.getProperties().getProperty("catalogs");
            for (String cat : Arrays.asList(catalogList.split(","))) {
                if (catalogPattern.matcher(cat).matches()) {
                    catalogs.add(cat);
                    logger.debug((Object)("  Adding catalog " + cat));
                    continue;
                }
                logger.debug((Object)("Skipping catalog " + cat + " (doesn't match pattern)"));
            }
        } else {
            catalogs.add("no_catalog");
        }
        TreeMap schemas = new TreeMap();
        if (this.getSchemaTerm() != null) {
            for (String cat : catalogs) {
                String schemaList = cat == "no_catalog" ? this.connection.getProperties().getProperty("schemas") : this.connection.getProperties().getProperty("schemas." + cat);
                ArrayList<String> schemasOfCat = new ArrayList<String>();
                if (schemaList != null) {
                    for (String sch : Arrays.asList(schemaList.split(","))) {
                        if (schemaPattern.matcher(sch).matches()) {
                            schemasOfCat.add(sch);
                            logger.debug((Object)("  Adding schema " + sch));
                            continue;
                        }
                        logger.debug((Object)("Skipping schema " + sch + " (doesn't match pattern)"));
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Putting schemas " + schemasOfCat + " under map key '" + cat + "'"));
                }
                schemas.put(cat, schemasOfCat);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Found Catalogs: " + catalogs));
            logger.debug((Object)("Found Schemas: " + schemas));
        }
        for (String cat : catalogs) {
            String tableList;
            if (cat.equals("no_catalog")) {
                if (schemas.get(cat) == null) {
                    tableList = this.connection.getProperties().getProperty("tables");
                    if (tableList == null) {
                        throw new SQLException("Missing property: 'tables'. property dump: " + this.connection.getProperties());
                    }
                    for (String table : Arrays.asList(tableList.split(","))) {
                        if (tablePattern.matcher(table).matches()) {
                            rs.addRow();
                            rs.updateObject(3, (Object)table);
                            rs.updateObject(4, (Object)"TABLE");
                            continue;
                        }
                        logger.debug((Object)("Skipping table " + table + " (doesn't match pattern)"));
                    }
                    continue;
                }
                List schemasOfCat = (List)schemas.get(cat);
                for (String sch : schemasOfCat) {
                    String tableList2 = this.connection.getProperties().getProperty("tables." + sch);
                    if (tableList2 == null) {
                        throw new SQLException("Missing property: 'tables." + sch + "'");
                    }
                    for (String table : Arrays.asList(tableList2.split(","))) {
                        if (tablePattern.matcher(table).matches()) {
                            rs.addRow();
                            rs.updateObject(2, (Object)sch);
                            rs.updateObject(3, (Object)table);
                            rs.updateObject(4, (Object)"TABLE");
                            continue;
                        }
                        logger.debug((Object)("Skipping table " + table + " (doesn't match pattern)"));
                    }
                }
                continue;
            }
            if (this.getSchemaTerm() == null) {
                tableList = this.connection.getProperties().getProperty("tables." + cat);
                if (tableList == null) {
                    throw new SQLException("Missing property: 'tables." + cat + "'");
                }
                for (String table : Arrays.asList(tableList.split(","))) {
                    if (tablePattern.matcher(table).matches()) {
                        rs.addRow();
                        rs.updateObject(1, (Object)cat);
                        rs.updateObject(3, (Object)table);
                        rs.updateObject(4, (Object)"TABLE");
                        continue;
                    }
                    logger.debug((Object)("Skipping table " + table + " (doesn't match pattern)"));
                }
                continue;
            }
            if (schemas.get(cat) == null) continue;
            for (String sch : (List)schemas.get(cat)) {
                String tableList3 = this.connection.getProperties().getProperty("tables." + cat + "." + sch);
                if (tableList3 == null) {
                    throw new SQLException("Missing property: 'tables." + cat + "." + sch + "'");
                }
                for (String table : Arrays.asList(tableList3.split(","))) {
                    if (tablePattern.matcher(table).matches()) {
                        rs.addRow();
                        rs.updateObject(1, (Object)cat);
                        rs.updateObject(2, (Object)sch);
                        rs.updateObject(3, (Object)table);
                        rs.updateObject(4, (Object)"TABLE");
                        continue;
                    }
                    logger.debug((Object)("Skipping table " + table + " (doesn't match pattern)"));
                }
            }
        }
        rs.beforeFirst();
        return rs;
    }

    private Pattern createPatternFromSQLWildcard(String sqlWildcard) {
        if (sqlWildcard == null || sqlWildcard.equals("") || sqlWildcard.equals("%")) {
            return Pattern.compile(".+");
        }
        sqlWildcard = sqlWildcard.replace(".", "\\.");
        sqlWildcard = sqlWildcard.replace("[", "\\[");
        sqlWildcard = sqlWildcard.replace("\\", "\\\\");
        sqlWildcard = sqlWildcard.replace("%", ".*");
        sqlWildcard = sqlWildcard.replace("_", ".");
        return Pattern.compile(sqlWildcard);
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        String catalogList = this.connection.getProperties().getProperty("catalogs");
        TreeMap<String, String> schemas = new TreeMap<String, String>();
        if (this.getSchemaTerm() == null) {
            logger.debug((Object)"getSchemas: schemaTerm==null; returning empty result set");
        } else if (this.getCatalogTerm() == null) {
            String schemaList = this.connection.getProperties().getProperty("schemas");
            logger.debug((Object)("getSchemas: catalogTerm==null; schemaList=" + schemaList));
            if (schemaList == null) {
                throw new SQLException("Missing property: 'schemas'");
            }
            for (String string : Arrays.asList(schemaList.split(","))) {
                if (string.equals("")) continue;
                schemas.put(string, null);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("getSchemas: put '" + string + "'"));
            }
        } else {
            logger.debug((Object)"getSchemas: database has catalogs and schemas!");
            String restrictToCatalog = this.connection.getCatalog();
            for (String string : Arrays.asList(catalogList.split(","))) {
                if (string.equals("") || restrictToCatalog != null && !restrictToCatalog.equalsIgnoreCase(string)) continue;
                String schemaList = this.connection.getProperties().getProperty("schemas." + string);
                if (schemaList == null) {
                    throw new SQLException("Missing property: 'schemas." + string + "'");
                }
                for (String schName : Arrays.asList(schemaList.split(","))) {
                    schemas.put(schName, string);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("getSchemas: put '" + string + "'.'" + schName + "'"));
                }
            }
        }
        MockJDBCResultSet rs = new MockJDBCResultSet(null, 2);
        rs.setColumnName(1, "TABLE_SCHEM");
        rs.setColumnName(2, "TABLE_CATALOG");
        for (Map.Entry entry : schemas.entrySet()) {
            rs.addRow();
            rs.updateObject(1, entry.getKey());
            rs.updateObject(2, entry.getValue());
        }
        rs.beforeFirst();
        return rs;
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        String catalogList = this.connection.getProperties().getProperty("catalogs");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getCatalogs: user-supplied catalog list is '" + catalogList + "'"));
        }
        MockJDBCResultSet rs = new MockJDBCResultSet(null, 1);
        rs.setColumnName(1, "TABLE_CAT");
        if (this.getCatalogTerm() != null) {
            for (String catName : Arrays.asList(catalogList.split(","))) {
                if (catName.equals("")) continue;
                rs.addRow();
                rs.updateObject(1, (Object)catName);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("getCatalogs: added '" + catName + "'"));
            }
        }
        rs.beforeFirst();
        return rs;
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        MockJDBCResultSet rs = new MockJDBCResultSet(null, 1);
        rs.setColumnName(1, "TABLE_TYPE");
        rs.updateObject(1, (Object)"TABLE");
        rs.beforeFirst();
        return rs;
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        logger.debug((Object)"getColumns: Searching for:");
        logger.debug((Object)("    catalog '" + catalog + "' (pattern )"));
        logger.debug((Object)("     schema '" + schemaPattern + "' (pattern )"));
        logger.debug((Object)("      table '" + tableNamePattern + "' (pattern )"));
        logger.debug((Object)("     column '" + columnNamePattern + "' (pattern )"));
        MockJDBCResultSet rs = new MockJDBCResultSet(null, 23);
        rs.setColumnName(1, "TABLE_CAT");
        rs.setColumnName(2, "TABLE_SCHEM");
        rs.setColumnName(3, "TABLE_NAME");
        rs.setColumnName(4, "COLUMN_NAME");
        rs.setColumnName(5, "DATA_TYPE");
        rs.setColumnName(6, "TYPE_NAME");
        rs.setColumnName(7, "COLUMN_SIZE");
        rs.setColumnName(8, "BUFFER_LENGTH");
        rs.setColumnName(9, "DECIMAL_DIGITS");
        rs.setColumnName(10, "NUM_PREC_RADIX");
        rs.setColumnName(11, "NULLABLE");
        rs.setColumnName(12, "REMARKS");
        rs.setColumnName(13, "COLUMN_DEF");
        rs.setColumnName(14, "SQL_DATA_TYPE");
        rs.setColumnName(15, "SQL_DATETIME_SUB");
        rs.setColumnName(16, "CHAR_OCTET_LENGTH");
        rs.setColumnName(17, "ORDINAL_POSITION");
        rs.setColumnName(18, "IS_NULLABLE");
        rs.setColumnName(19, "SCOPE_CATLOG");
        rs.setColumnName(20, "SCOPE_SCHEMA");
        rs.setColumnName(21, "SCOPE_TABLE");
        rs.setColumnName(22, "SOURCE_DATA_TYPE");
        rs.setColumnName(23, "IS_AUTOINCREMENT");
        StringBuilder qualifier = new StringBuilder();
        if (this.getCatalogTerm() != null) {
            if (catalog == null) {
                throw new SQLException("Catalog name is mandatory for this JDBC Driver.");
            }
            qualifier.append(catalog).append(".");
        }
        if (this.getSchemaTerm() != null) {
            if (schemaPattern == null) {
                throw new SQLException("Schema name is mandatory for this JDBC Driver.");
            }
            qualifier.append(schemaPattern).append(".");
        }
        ResultSet tables = this.getTables(catalog, schemaPattern, tableNamePattern, new String[]{"TABLE"});
        while (tables.next()) {
            String tableName = tables.getString(3);
            String fqTableName = qualifier + tableName;
            String colListPropName = "columns." + qualifier + tableName;
            logger.debug((Object)("getColumns: property name for column list is '" + colListPropName + "'"));
            String columnList = this.connection.getProperties().getProperty(colListPropName.toString());
            logger.debug((Object)("getColumns: user-supplied column list is '" + columnList + "'"));
            if (columnList == null) {
                columnList = tableName + "_col_1," + tableName + "_col_2," + tableName + "_col_3," + tableName + "_col_4";
            }
            HashSet<String> autoIncCols = new HashSet<String>();
            if (this.connection.getProperties().getProperty("autoincrement_cols") != null) {
                String[] colList = this.connection.getProperties().getProperty("autoincrement_cols").split(",");
                autoIncCols.addAll(Arrays.asList(colList));
            }
            System.err.println("autoincCols=" + autoIncCols);
            int colNo = 1;
            for (String colName : Arrays.asList(columnList.split(","))) {
                rs.addRow();
                rs.updateObject(1, (Object)catalog);
                rs.updateObject(2, (Object)schemaPattern);
                rs.updateObject(3, (Object)tableName);
                rs.updateObject(4, (Object)colName);
                rs.updateInt(5, 12);
                rs.updateObject(6, (Object)"VARCHAR");
                rs.updateInt(7, 20);
                rs.updateObject(8, null);
                rs.updateInt(9, 0);
                rs.updateInt(10, 0);
                rs.updateInt(11, 0);
                rs.updateObject(12, null);
                rs.updateObject(13, null);
                rs.updateInt(14, 0);
                rs.updateInt(15, 0);
                rs.updateInt(16, 20);
                rs.updateInt(17, colNo);
                rs.updateObject(18, (Object)"NO");
                rs.updateObject(19, null);
                rs.updateObject(20, null);
                rs.updateObject(21, null);
                rs.updateObject(22, null);
                System.err.println(" checking " + fqTableName + "." + colName);
                if (autoIncCols.contains(fqTableName + "." + colName)) {
                    System.err.println("  FOUND");
                    rs.updateObject(23, (Object)"YES");
                } else {
                    System.err.println("  NOT FOUND");
                    rs.updateObject(23, (Object)"NO");
                }
                ++colNo;
            }
        }
        rs.beforeFirst();
        return rs;
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        MockJDBCResultSet rs = new MockJDBCResultSet(null, 6);
        rs.setColumnName(1, "TABLE_CAT");
        rs.setColumnName(2, "TABLE_SCHEM");
        rs.setColumnName(3, "TABLE_NAME");
        rs.setColumnName(4, "COLUMN_NAME");
        rs.setColumnName(5, "KEY_SEQ");
        rs.setColumnName(6, "PK_NAME");
        return rs;
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        MockJDBCResultSet rs = new MockJDBCResultSet(null, 14);
        rs.setColumnName(1, "PKTABLE_CAT");
        rs.setColumnName(2, "PKTABLE_SCHEM");
        rs.setColumnName(3, "PKTABLE_NAME");
        rs.setColumnName(4, "PKCOLUMN_NAME");
        rs.setColumnName(5, "FKTABLE_CAT");
        rs.setColumnName(6, "FKTABLE_SCHEM");
        rs.setColumnName(7, "FKTABLE_NAME");
        rs.setColumnName(8, "FKCOLUMN_NAME");
        rs.setColumnName(9, "KEY_SEQ");
        rs.setColumnName(10, "UPDATE_RULE");
        rs.setColumnName(11, "DELETE_RULE");
        rs.setColumnName(12, "FK_NAME");
        rs.setColumnName(13, "PK_NAME");
        rs.setColumnName(14, "DEFERRABILITY");
        return rs;
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        MockJDBCResultSet rs = new MockJDBCResultSet(null, 14);
        rs.setColumnName(1, "PKTABLE_CAT");
        rs.setColumnName(2, "PKTABLE_SCHEM");
        rs.setColumnName(3, "PKTABLE_NAME");
        rs.setColumnName(4, "PKCOLUMN_NAME");
        rs.setColumnName(5, "FKTABLE_CAT");
        rs.setColumnName(6, "FKTABLE_SCHEM");
        rs.setColumnName(7, "FKTABLE_NAME");
        rs.setColumnName(8, "FKCOLUMN_NAME");
        rs.setColumnName(9, "KEY_SEQ");
        rs.setColumnName(10, "UPDATE_RULE");
        rs.setColumnName(11, "DELETE_RULE");
        rs.setColumnName(12, "FK_NAME");
        rs.setColumnName(13, "PK_NAME");
        rs.setColumnName(14, "DEFERRABILITY");
        return rs;
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        MockJDBCResultSet rs = new MockJDBCResultSet(null, 18);
        rs.setColumnName(1, "TYPE_NAME");
        rs.setColumnName(2, "DATA_TYPE");
        rs.setColumnName(3, "PRECISION");
        rs.setColumnName(4, "LITERAL_PREFIX");
        rs.setColumnName(5, "LITERAL_SUFFIX");
        rs.setColumnName(6, "CREATE_PARAMS");
        rs.setColumnName(7, "NULLABLE");
        rs.setColumnName(8, "CASE_SENSITIVE");
        rs.setColumnName(9, "SEARCHABLE");
        rs.setColumnName(10, "UNSIGNED_ATTRIBUTE");
        rs.setColumnName(11, "FIXED_PREC_SCALE");
        rs.setColumnName(12, "AUTO_INCREMENT");
        rs.setColumnName(13, "LOCAL_TYPE_NAME");
        rs.setColumnName(14, "MINIMUM_SCALE");
        rs.setColumnName(15, "MAXIMUM_SCALE");
        rs.setColumnName(16, "SQL_DATA_TYPE");
        rs.setColumnName(17, "SQL_DATETIME_SUB");
        rs.setColumnName(18, "NUM_PREC_RADIX");
        return rs;
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        MockJDBCResultSet rs = new MockJDBCResultSet(null, 13);
        rs.setColumnName(1, "TABLE_CAT");
        rs.setColumnName(2, "TABLE_SCHEM");
        rs.setColumnName(3, "TABLE_NAME");
        rs.setColumnName(4, "NON_UNIQUE");
        rs.setColumnName(5, "INDEX_QUALIFIER");
        rs.setColumnName(6, "INDEX_NAME");
        rs.setColumnName(7, "TYPE");
        rs.setColumnName(8, "ORDINAL_POSITION");
        rs.setColumnName(9, "COLUMN_NAME");
        rs.setColumnName(10, "ASC_OR_DESC");
        rs.setColumnName(11, "CARDINALITY");
        rs.setColumnName(12, "PAGES");
        rs.setColumnName(13, "FILTER_CONDITION");
        return rs;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }
}

