/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.validation.swingui;

import ca.sqlpower.validation.ValidateResult;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

public class StatusComponent
extends JLabel {
    private static final Logger logger = Logger.getLogger(StatusComponent.class);
    private static final Border DEFAULT_BORDER = BorderFactory.createEmptyBorder(7, 0, 7, 0);
    private ValidateResult result = null;
    private Icon nullIcon;
    private Icon okIcon;
    private Icon warnIcon;
    private Icon failIcon;

    public StatusComponent() {
        this.setOpaque(true);
        this.setBorder(DEFAULT_BORDER);
        this.setResult(null);
        this.setNullIcon(new ImageIcon(StatusComponent.class.getClassLoader().getResource("ca/sqlpower/validation/swingui/stat_null_16.png")));
        this.setOkIcon(this.getNullIcon());
        this.setWarnIcon(new ImageIcon(StatusComponent.class.getClassLoader().getResource("ca/sqlpower/validation/swingui/stat_warn_16.png")));
        this.setFailIcon(new ImageIcon(StatusComponent.class.getClassLoader().getResource("ca/sqlpower/validation/swingui/stat_fail_16.png")));
    }

    public void setResult(ValidateResult error) {
        Icon icon;
        String text;
        this.result = error;
        if (this.result == null) {
            text = null;
            icon = this.getNullIcon();
        } else {
            text = this.result.getMessage();
            switch (this.result.getStatus()) {
                case OK: {
                    icon = this.getOkIcon();
                    break;
                }
                case WARN: {
                    icon = this.getWarnIcon();
                    break;
                }
                case FAIL: {
                    icon = this.getFailIcon();
                    break;
                }
                default: {
                    icon = this.getNullIcon();
                }
            }
        }
        this.setText(text);
        this.setIcon(icon);
    }

    @Override
    public void setText(String text) {
        if (text == null || text.trim().length() == 0) {
            text = "&nbsp;";
        }
        super.setText("<html>" + text);
    }

    public ValidateResult getResult() {
        return this.result;
    }

    public Icon getFailIcon() {
        return this.failIcon;
    }

    public void setFailIcon(Icon failIcon) {
        this.failIcon = failIcon;
    }

    public Icon getNullIcon() {
        return this.nullIcon;
    }

    public void setNullIcon(Icon nullIcon) {
        this.nullIcon = nullIcon;
    }

    public Icon getOkIcon() {
        return this.okIcon;
    }

    public void setOkIcon(Icon okIcon) {
        this.okIcon = okIcon;
    }

    public Icon getWarnIcon() {
        return this.warnIcon;
    }

    public void setWarnIcon(Icon warnIcon) {
        this.warnIcon = warnIcon;
    }
}

